
%    Copyright (C) 2005
%    Geoff Gordon  ggordon@cs.cmu.edu
%    Andrew Gove
%
%    This file is part of DotTrack, dot tracking software for
%    fluorescence microscope images.
%
%    DotTrack is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published
%    by the Free Software Foundation; either version 2 of the License,
%    or (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
%    02110-1301 USA

d = zeros(n,1);
perm = randperm(n);
d(perm(1:numreal)) = 1:numreal;

[swts, topwts] = sort(wts);
d = zeros(n, 1);
d(topwts(end-numreal+1:end)) = 1:numreal;

lreal = 5.71*exp(-5.71*(1-wts));
lnoise = .05;
lextra = .05;
lsum = lreal+lnoise+lextra;
%lreal = exp(-(wts-1).^2/.1)/sqrt(pi*.1);
%lnoise = exp(-(wts+.4).^2/.1)/sqrt(pi*.1);
%lextra = .089*ones(size(wts));		% corresp. to width of 11.24

% Select likelihoods corresponding to d and multiply them.  For noise
% or extra, also multiply in the likelihood of (x,y,z).  (Since there
% are always the same number of real points, and since the likelihood
% of (x,y,z) for those points is always the same, we can ignore their
% location likelihood.)
p = 1;
area = 10;
%area = (xmax-xmin)*(ymax-ymin);
sig2 = 1;
for i = 1:length(xs)
  if (d(i) > 0)				% real
    p = p * lreal(i);
  elseif (0 == d(i))			% noise
    p = p * lnoise(i);
    p = p / area;
  else					% extra
    p = p * lextra(i);
    j = find(d == -d(i));
%    if (length(j) ~= 1)
%      warning(sprintf('length of j is %d, i=%d, d(i)=%d', length(j), ...
%		      i, d(i)));
%    end
    dist = (xs(i) - xs(j)).^2 + (ys(i) - ys(j)).^2 + (zs(i) - zs(j)).^2;
    p = p * exp(-dist/(2*sig2))/sqrt(2*pi*sig2);
  end
end

p
