
%    Copyright (C) 2005
%    Geoff Gordon  ggordon@cs.cmu.edu
%    Andrew Gove
%
%    This file is part of DotTrack, dot tracking software for
%    fluorescence microscope images.
%
%    DotTrack is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published
%    by the Free Software Foundation; either version 2 of the License,
%    or (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
%    02110-1301 USA

function testcandmatch(movie, k, xmin, xmax, ymin, ymax)

% cut out desired box of movie
for i = 1:length(movie)
  movie{i} = movie{i}(ymin:ymax,xmin:xmax,:);
end

% get a target point
%clf;
%imagesc(sum(movie{1},3));
%axis image;
%[x, y] = ginput(1);
%x = round(x);
%y = round(y);
%[val, z] = max(movie{1}(x,y,:));

% get and display candidates
for i = 1:length(movie)
  %[cx, cy, cz, wt] = candmatch(movie{i}, x, y, z, k, res);
  [cx, cy, cz, wt] = candregion(movie{i}, 1, xmax-xmin+1, 1, ymax-ymin+1, k);

  subplot('position', [.05 .2 .75 .75]);
  imagesc(max(movie{i},[],3));
  axis off;
  line(cx, cy, 'LineStyle', 'none', 'Marker', 'x', 'Color', [1 .2 .2]);
%  line(x, y, 'LineStyle', 'none', 'Marker', 'o', 'Color', [1 .2 .2]);

  subplot('position', [.05 .05 .75 .1]);
  imagesc(max(permute(movie{i},[3 2 1]),[],3));
  line(cx, cz, 'LineStyle', 'none', 'Marker', 'x', 'Color', [1 .2 .2]);

  subplot('position', [.86 .2 .08 .75]);
  imagesc(max(permute(movie{i},[1 3 2]),[],3));
  line(cz, cy, 'LineStyle', 'none', 'Marker', 'x', 'Color', [1 .2 .2]);
  
  pause;
end

% testcandmatch(movie, 10, 214, 276, 158, 211, micronsPerPixel)
% testcandmatch(movie, 15, 200, 300, 125, 240)
