% RUN
%
% Main entry point for DotTrack ThreeD.
%
% Please edit this file to include the correct pathname for your movie
% and the desired prefix for output files.

%    Copyright (C) 2005
%    Geoff Gordon  ggordon@cs.cmu.edu
%    Andrew Gove
%
%    This file is part of DotTrack, dot tracking software for
%    fluorescence microscope images.
%
%    DotTrack is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published
%    by the Free Software Foundation; either version 2 of the License,
%    or (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
%    02110-1301 USA

fprintf('DotTrack v 0.1, Copyright (C) 2005 Geoff Gordon, Andrew Gove\n\n');
fprintf('DotTrack comes with ABSOLUTELY NO WARRANTY; for details see\n');
fprintf('the file LICENSE.TXT in the distribution.  This is free software,\n');
fprintf('and you are welcome to redistribute it under certain conditions;\n');
fprintf('again, see LICENSE.TXT for details.\n\n');
fprintf('Please edit the file run.m to include the correct pathname for\n');
fprintf('your movie and the desired prefix for output files.\n\n');

% 1st param is set of files, where %d or %02d gets expanded to a number
% 2nd param is range of time values
% 3rd param is range of z-values
movie = loadmovie('nl1rt/nl1rt07_w617_t%02d_z%02d.tif',1:20,1:10);
prefix = 'rednl1rt07'

% Conversion factors.  These are used for transforming the output, but are
% also necessary for computing the aspect ratio between distances in the
% XY-plane and the Z-axis.  Note that all values remain in pixel
% coordinates until written out as CSV files.
micronsPerPixel = [.132, .132, .5];

track = 1;
npoints = -1;
while (1)

  while (npoints < 1 || npoints > 4)
    cmd = input('Enter number of dots to track, from 1 to 4 [2]: ', 's');
    if (isempty(cmd))
      cmd = '2';
    end
    npoints = floor(str2num(cmd));
  end
  
  fprintf('Working on track %d\n', track);
  figure(1);
  clf;
  colormap gray;
  [xs, ys, zs, wts] = track3improved(movie, npoints, micronsPerPixel);

  % polish each candidate 
  % -- no longer necessary here (done inside candidate finding routine)
% for i = 1:length(movie)
%   for j = 1:npoints
%    [xs(j,i), ys(j,i), zs(j,i)] = polish(movie{i}, xs(j,i), ys(j,i), zs(j,i));
%   end
% end

  viewresults(movie, xs, ys, zs, wts, npoints);
  
  while (1)
    cmd = input('[s]ave, [d]iscard, e[x]it, or e[X]it without saving: ', 's');

    if (isequal(cmd, 's') | isequal(cmd, 'x'))
      csvwrite(sprintf('%s-%03d-xs.csv',prefix,track), xs .* micronsPerPixel(1));
      csvwrite(sprintf('%s-%03d-ys.csv',prefix,track), ys .* micronsPerPixel(2));
      csvwrite(sprintf('%s-%03d-zs.csv',prefix,track), zs .* micronsPerPixel(3));
      csvwrite(sprintf('%s-%03d-wts.csv',prefix,track), wts);
      track = track + 1;
    end

    if (isequal(cmd, 's'))
      break;
    elseif (isequal(cmd, 'd'))
      break;
    elseif (isequal(cmd, 'x'))
      return;
    elseif (isequal(cmd, 'X'))
      return;
    end
  end

end

