% LOADMOVIE
%
% MOVIE = LOADMOVIE(BASENAME, FRAMES, SLICES)
%
% Load a bunch of images given a template filename.  The template,
% passed as BASENAME, should be suitable for fprintf, and should
% contain two %d or %s escapes: the first for the frame ID, and the
% second for the slice ID within the frame.  The movie is then
% returned as a cell array, with one 3d image stack per frame.
% The array of frame IDs is passed as FRAMES, and the array of
% slice IDs is passed as SLICES.

%    Copyright (C) 2005
%    Geoff Gordon  ggordon@cs.cmu.edu
%    Andrew Gove
%
%    This file is part of DotTrack, dot tracking software for
%    fluorescence microscope images.
%
%    DotTrack is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published
%    by the Free Software Foundation; either version 2 of the License,
%    or (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
%    02110-1301 USA

function movie = loadmovie(basename, frames, slices)

movie = {};
for fr = frames
  im = [];
  for z = slices
    thisim = imread(getfilename(basename, fr, z));
    im = cat(3, im, thisim);
  end
  movie{fr} = im;
end

