import sys

# Read in the DIMACS CNF formula and return an array of sets of literals
def read_formula(filename):
    FH = open(filename)
    F = []
    for l in FH:
        if l[0] == 'c' or l[0] == 'p':
            continue
        F.append(set(map(int,l.split(' ')[:-1])))
    FH.close()
    return F

# Read in the solution file and return a model as a set of literals
def read_model(filename):
    FH = open(filename)
    M = set([])
    for l in FH:
        v,a = map(int,l.split(' '))
        if 0 == a and v not in M:
            M.add(-v)
            continue
        if 1 == a and -v not in M:
            M.add(v)
            continue
        assert(False)
    return M

# Check each clause in the formula and make sure that at least one of the
# literals can be found in the model.
def check(F,M):
    for C in F:
        sat = False
        for l in C:
            if l in M:
                sat = True
                break
        if not sat:
            print "FAIL: Clause {0} not satisfied!".format(C)
            return False
    return True

# --- MAIN ---
me, formula, solution = sys.argv
F = read_formula(formula)
M = read_model(solution)
if check(F,M):
    print "SUCCESS: Formula satisfied."
