function p1 = mcmc_ask(x, evid_vars, evid_vals, bn, iterations)
%MCMC_ASK performs approximate inference on a Bayesian network by Gibbs
%sampling (fill in implementation for problem 3b).
%   P1 = MCMC_ASK(X, EVID_VARS, EVID_VALS, BN) calculates the
%   conditional probability of variable X being true, P1, given the
%   evidence variables EVID_VARS being values EVID_VALS on the Bayesian
%   network BN. X is the index of the query variable, range from 1 to
%   bn_varnum(BN). EVID_VARS(i) is the index of the i-th evidence variable.
%   EVID_VALS(i) is the value of the i-th evidence variables, and can be 0
%   or 1. The ordering of EVID_VARS and EVID_VALS does not matter as long
%   as they match each other. BN is the Bayesian network created by
%   load_bn(). Hence P1 = Pr(X = true | EVID_VARS = EVID_VALS, BN).
%
%   Examples:
%
%       alarm_bn = create_alarm_bn();
%       tic; p1 = mcmc_ask(1, [4 5], [1 0], alarm_bn, 5000); toc
%       pedigree_bn = create_pedigree_bn();
%       tic; p1 = mcmc_ask(10, [9 11], [0 1], pedigree_bn, 50000); toc
%
%   See also BN_PA, BN_CPT, BN_VARNUM.
%
%   Reference: AI: A Modern Approach (2nd ed), Russell and Norvig, Prentice
%   Hall, 2002.
%
%   Hint: "if rand() < p, ..." can sample a Bernoulli distribution.

% Fill in implementation here!