function p1 = enumeration_ask(x, evid_vars, evid_vals, bn)
%ENUMERATION_ASK performs exact inference on a Bayesian network by
%enumeration (fill in implementation for problem 3a).
%   P1 = ENUMERATION_ASK(X, EVID_VARS, EVID_VALS, BN) calculates the
%   conditional probability of variable X being true, P1, given the
%   evidence variables EVID_VARS being values EVID_VALS on the Bayesian
%   network BN. X is the index of the query variable, range from 1 to
%   bn_varnum(BN). EVID_VARS(i) is the index of the i-th evidence variable.
%   EVID_VALS(i) is the value of the i-th evidence variables, and can be 0
%   or 1. The ordering of EVID_VARS and EVID_VALS does not matter as long
%   as they match each other. BN is the Bayesian network created by
%   load_bn(). Hence P1 = Pr(X = true | EVID_VARS = EVID_VALS, BN).
%
%   Note that since all variables are binary, specifying the probability of
%   a variable being true gives the full distribution of that variable.
%
%   Examples:
%
%       alarm_bn = create_alarm_bn();
%       tic; p1 = enumeration_ask(1, [4 5], [1 1], alarm_bn); toc
%       tic; p1 = enumeration_ask(1, [4 5], [1 0], alarm_bn); toc
%       pedigree_bn = create_pedigree_bn();
%       tic; p1 = enumeration_ask(10, [9 11], [0 1], pedigree_bn); toc
%
%   See also BN_PA, BN_CPT, BN_VARNUM.
%
%   Reference: AI: A Modern Approach (2nd ed), Russell and Norvig, Prentice
%   Hall, 2002.
%
%   Hint: "evid_vals(evid_vars == v)" can retrieve the value of variable v
%   in a list, or assign a value to a value list.

% Fill in implementation here!
