function bn = create_pedigree_bn()
%CREATE_PEDIGREE_BN creates the predigree Bayesian network.
%   BN = CREATE_PEDIGREE_BN() creates the pedigree Bayesian network data
%   structure, which can be accessed by BN_VARS, BN_PARENTS, and BN_CPT. 
%
%   The variables are ordered from parents to children (i.e. parents always
%   appear before their children), which is important for inference by
%   enumeration.
%
%   For those who want to use a language other than Matlab (not recommended),
%   here is a explanation of the CPT:
%   for any hidden variable X without parents (X from 1 to 5), 
%      p(X) = 0.1;
%   for any hidden variable X with parents Y and Z (X from 6 to 8), 
%      p(X|~Y,~Z) = 0.01, p(X|~Y,Z) = p(X|Y,~Z) = 0.5, p(X|Y,Z) = 0.99;
%   for any observed variable X with parents Y and Z (X from 9 to 11), 
%      p(X|~Y,~Z) = p(X|~Y,Z) = p(X|Y,~Z) = 0.01, p(X|Y,Z) = 0.99;

bn.parents = {[], [], [], [], [], [1 2], [3 4], [1 2], [3 4], [5 6], [7 8]};
bn.cpt = {.1, .1, .1, .1, .1, ...
          [.01 .5 .5 .99], [.01 .5 .5 .99], [.01 .5 .5 .99], ...
          [.01 .01 .01 .99], [.01 .01 .01 .99], [.01 .01 .01 .99]};
