function xdist = bn_cpt(bn, x, vars, vals)
%BN_CPT returns the conditional probability distribution of a variable
%given the specified values of its parents.
%   XDIST = BN_CPT(BN, X, VARS, VALS) returns the conditional probability
%   distribution, XDIST, of a variable X, given the specified values of its
%   parents. XDIST(1) is the probability of X being false, and XDIST(2) is
%   the probability of X being true. This corresponds to one row of the
%   conditional probability table (CPT).
%   VALS(i) is the value of the variable VARS(i), and can be 0 or 1.
%   The ordering of VARS and VALS does not matter as long as they match
%   each other. VARS must contains the parents of X, but can include other
%   variables.

parents = bn_parents(bn, x);
pa_vals = zeros(1, length(parents));
for k = 1:length(parents), pa_vals(k) = vals(vars == parents(k)); end

idx = 0;
for pa_val = pa_vals, idx = idx * 2 + pa_val; end
p1 = bn.cpt{x}(idx + 1);
xdist = [1 - p1, p1];
