function xdist = bn_cond_mb(bn, x, vars, vals)
%BN_COND_MB calculates the conditional probability distribution of a
%variable given its Markov blanket.
%   XDIST = BN_COND_MB(BN, X, VARS, VALS) returns the conditional probability
%   distribution, XDIST, of a variable X, given the specified values of its
%   Markov blanket. XDIST(1) is the probability of X being false, and XDIST(2)
%   is the probability of X being true. 
%   VALS(i) is the value of the variable VARS(i), and can be 0 or 1.
%   The ordering of VARS and VALS does not matter as long as they match
%   each other. VARS must contains the Markov blanket of X, but can include
%   other variables.
%
%   See also BN_CPT.

vals = vals(vars ~= x); vars = vars(vars ~= x);

children = [];
for y = bn_vars(bn)
    if any(bn_parents(bn, y) == x), children = [children y]; end
end

prX = bn_cpt(bn, x, vars, vals);
for xval = 0 : 1
    for y = children
        prY = bn_cpt(bn, y, [vars x], [vals xval]);
        yval = vals(vars == y);
        prX(xval+1) = prX(xval+1) * prY(yval+1);
    end
end
xdist = prX ./ sum(prX);
