structure Util =
struct
exception NotFound

fun alterNth ([], _, _) = raise NotFound
  | alterNth (h::tl, 0, f) = (f h)::tl
  | alterNth (h::tl, n, f) = h::(alterNth (tl,n-1,f))
(* alterNth : 'a list * int * ('a -> 'a) -> 'a list
   alterNth (<list>,<n>,<func>) = returns <list> except element
   <n> has been replaced by <func> applied to it *)

fun alterItem ([], p, _) = raise NotFound
  | alterItem (h::tl, p, f) = if p h 
			     then (f h)::tl
			     else h::(alterItem (tl,p,f))
(* alterItem : 'a list * int * ('a -> 'a) -> 'a list
   alterItem (<list>,<n>,<func>) = returns <list> except element
   the first element matching predicate <p> has been replaced by the
   result of <func> applied to it *)

fun findIndex' p [] n = raise NotFound
  | findIndex' p (h::tl) n = if p h then n else findIndex' p tl (n+1)
fun findIndex p l = findIndex' p l 0
(* findIndex : ('a -> bool) -> 'a list -> int
   findIndex <predicate> <list> = 0-based index of the first item 
   in <list> that satisfies <predicate> *)

fun findItem p [] = raise NotFound
  | findItem p (h::tl) = if p h then h else findItem p tl 
(* findItem : ('a -> bool) -> 'a list -> int
   findItem <predicate> <list> = the first item 
   in <list> that satisfies <predicate> *)
end