signature BINDINGS =
sig

    type bindings
    type label = string

    type class = {abstract : bool,
		  name : label,
		  superclass : label option,
		  repn : (label * T.typ) list}

    type method = {internal : bool,
		   name : label,
		   args : label list,
		   ret : T.typ}

    type methodimpl = {args : label list,
		       impl : DBMinML.exp}

    val noBindings : bindings

    val namedClass : bindings -> string -> class
    (* this creates new bindings *)
    val installClass : bindings -> class -> bindings

    val namedMethod : bindings -> label -> method
    val methodImpls : bindings -> label -> methodimpl list
    val ownedMethods : bindings -> label -> method list

    (* these create new bindings *)
    val installMethod : bindings -> method -> bindings
    val installImpl : bindings -> label -> methodimpl -> bindings 

end

structure Bindings :> BINDINGS  = 
struct
(* XXX: lot of unused code in here *)

open Util

type classid = string
type methodid = string
type label = string

type class = {abstract : bool,
	      name : label,
	      superclass : label option,
	      repn : (label * T.typ) list}
	     
type method = {internal : bool,
	       name : label,
	       args : label list,
	       ret : T.typ}
	      
type methodimpl = {args : label list,
		   impl : DBMinML.exp}

type imethod = {internal : bool,
		name : label,
		args : label list,
		ret : T.typ,
		impls : methodimpl list}

type bindings = {classes : class list, methods : imethod list}

val noBindings = {classes = [], methods = []}

fun namedClass (b : bindings) s = findItem (fn x => #name x = s) (#classes b)
fun className (b : bindings) n = #name (List.nth (#classes b, n))
fun classeq (id1:int, id2) = id1 = id2
fun installClass (b : bindings) nc = {classes = #classes b @ [nc], methods = #methods b}
fun installMethod (b : bindings) (r:method) =
    let
	val nm = {internal = #internal r, name = #name r, args = #args r, ret = #ret r, impls = []}
    in
	{classes = #classes b, methods = #methods b @ [nm]} 
    end

fun exportMethod (r : imethod) = {internal = #internal r, name = #name r, args = #args r, ret = #ret r}

fun namedMethod (b : bindings) s = exportMethod(findItem (fn x => #name x = s) (#methods b))

fun methodImpls (b : bindings) s = 
    let val r = findItem (fn x => #name x = s) (#methods b)
    in #impls r end

fun ownedMethods (b : bindings) c = map exportMethod (List.filter (fn r => c = hd (#args r)) (#methods b))

fun installImpl (b : bindings) m r =
    let
	fun addimpl {internal = internal, name = name, args = args, ret = ret, impls = impls} =
	    {internal = internal, name = name, args = args, ret = ret, impls = r :: impls}
    in
	{classes = #classes b, methods = alterItem (#methods b, (fn x => m = #name x), addimpl)}
    end

fun methodName (b : bindings) n = #name (List.nth (#methods b, n))
fun methodeq (id1:int, id2) = id1 = id2
fun method (b : bindings) (internal, name, args, ret) = 
    let 
	val id = length (#methods b)
	val nm = {internal = internal, name = name, args = args, ret = ret, impls = []}
    in
	(id, {classes = #classes b, methods = #methods b @ [nm]})
    end
end
