structure MarkAndSweepGC : GC = 
struct

  (* Raised to indicate that an allocation or dereference has failed (due to
  lack of resources (or breaking of another invariant) and a collection should
  be invoked. *) 
  exception OutOfMemory
  exception Error of string

  type location = int

  datatype sVal =
      Int of int
    | True 
    | False 
    | Nil 
    | Loc of location
    | Unit
  and lVal = 
      Closure of Env * DBMinML.exp
    | Cons of sVal * sVal
    | Pair of sVal * sVal
  and Bind =
      ValBind of sVal 
    | ExpBind of sVal
  
  withtype Env = Bind list
  
  datatype Frame =
      FPrimopN of P.primop * sVal list * DBMinML.exp list
    | If1 of DBMinML.exp * DBMinML.exp
    | App1 of DBMinML.exp 
    | App2 of sVal
    | Cons1 of DBMinML.exp 
    | Cons2 of sVal 
    | FPair1 of DBMinML.exp
    | FPair2 of sVal
    | FFst
    | FSnd
    | Case1 of DBMinML.exp * (DBMinML.bind * DBMinML.bind * DBMinML.exp)
    | Let1 of DBMinML.bind * DBMinML.exp
  
  datatype Cont =
      Frame of Frame
    | Env of Env
  
  type stack = Cont list
  
  datatype HeapElement = Free of int | Unmarked of lVal | Marked of lVal

  val (heap, next) = (ref (Array.tabulate (0,fn i => Free(i+1))), ref 0)

  val allocs = ref 0
  val reads = ref 0
  val collects = ref 0
  val accesses = ref 0

  (* Initialize the GC heap. *)
  fun init heap_size = 
    let in
      heap := Array.tabulate (heap_size,fn i => Free(i+1));
      next := 0
    end
  
  fun sweep _ = raise Error "Unimplemented"
  
  fun markStack _ = raise Error "Unimplemented"

  and markEnv _ = raise Error "Unimplemented"

  and markPtr _ = raise Error "Unimplemented"

  and marksVal _ = raise Error "Unimplemented"

  and marklVal _ = raise Error "Unimplemented"

  fun alloc k w = raise Error "Unimplemented"
  
  fun read l = raise Error "Unimplemented"

  fun numAllocs () = !allocs

  fun numReads () = !reads

  fun numCollects () = !collects

  fun numAccesses () = !accesses

end;



