signature TOP =
sig
    val file_type  : string -> unit
    val file_eval  : string -> unit
end

structure Top :> TOP =
struct

    fun println s = print(s^"\n")

    fun file_type  f = 
        (Loop.loopFile f Loop.showType)
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n");

    fun file_eval  f =
        ((Loop.loopFile f (Loop.eval Loop.showType)) 
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n")) 
         handle Eval.Stuck s => println s 
              | Typing.Error s => println s

end
