#include <stdio.h>

class Reader
 { private:
      bool firstFile;
      FILE *file;
      char *file1, *file2;

   private:
      void Open(void);
      void Close(void);

   public:
      Reader(char *_file1, char *_file2)
       : firstFile(true), file(0), file1(_file1), file2(_file2)
       { }

      ~Reader() { if (file) fclose(file); }

      int Read(void);
      void UnRead(char c);
      void Finish(void);
 };

void Reader::Open(void)
 { file = fopen(firstFile ? file1 : file2, "r"); firstFile = false; }

void Reader::Close(void) { fclose(file); file = 0; }

int Reader::Read(void)
 { if (!file) Open();
   
   int c = fgetc(file);

   if (c == EOF) { Close(); Open(); }

   return c;
 }

void Reader::UnRead(char c) { if (!file) Open(); ungetc(c, file); }

void Reader::Finish(void)
 { int c;

   while ((c = fgetc(file)) != EOF) putchar(c); fclose(file); file = 0;
 }


class Machine
 { public:
      class Transition;

   private:
      typedef enum Action { UNKNOWN = 0, ECHO, CONSUME, PUSH, NEWLINE, OUTPUT }
         Action;

      typedef enum State
       { SAME = 0, BOL_WHITE, BOL_TOKEN, INT_WHITE, INT_TOKEN }
         State;

      class Transition
       { public:
            int c;
            int next;
            Action action;
       };

      Transition *tr;
      Reader *reader;

   public:
      Machine(Reader *_reader) : reader(_reader), tr(0) { }
      ~Machine() { }
      Transition *Process(Transition *tr, unsigned char x);
 };


Machine::Transition *Machine::Process(Transition *tr, unsigned char x)
 { static Transition bolWhiteTrans[] =
    {  { ' ',  SAME,      ECHO },
       { '\t', SAME,      ECHO },
       { '\r', SAME,      ECHO },
       { '\n', SAME,      ECHO },
       { EOF,  SAME,      CONSUME },
       { '\0', BOL_TOKEN, PUSH }
    };

   static Transition bolTokenTrans[] =
    {  { ' ',  INT_WHITE, PUSH },
       { '\t', INT_WHITE, PUSH },
       { '\r', BOL_WHITE, ECHO },
       { '\n', BOL_WHITE, ECHO },
       { EOF,  BOL_WHITE, NEWLINE },
       { '\0', SAME,      ECHO }
    };

   static Transition intWhiteTrans[] =
    {  { ' ',  SAME,      CONSUME },
       { '\t', SAME,      CONSUME },
       { '\r', BOL_WHITE, ECHO },
       { '\n', BOL_WHITE, ECHO },
       { EOF,  BOL_WHITE, NEWLINE },
       { '\0', INT_TOKEN, OUTPUT }
    };

   static Transition intTokenTrans[] =
    {  { ' ',  INT_WHITE, CONSUME },
       { '\t', INT_WHITE, CONSUME },
       { '\r', BOL_WHITE, ECHO },
       { '\n', BOL_WHITE, ECHO },
       { EOF,  BOL_WHITE, NEWLINE },
       { '\0', SAME,      ECHO }
    };

   static Transition *transMap[] =
    { 0, bolWhiteTrans, bolTokenTrans, intWhiteTrans, intTokenTrans };

   static char *spaces = "      ";

   for (;;)
    { int c = reader->Read();

      Transition *trp;

      for (trp = tr ? tr : bolWhiteTrans; trp->c && (trp->c != c); trp++) ;

      switch (trp->action)
       { case ECHO:    putchar(c);            break;
         case CONSUME:                        break;
         case PUSH:    reader->UnRead(c);     break;
         case NEWLINE: putchar('\n');         break;
         case OUTPUT:  printf("%s%c", spaces + 5 - x, c); break;
         default:                             break;
       }

      if (trp->next) tr = transMap[trp->next];

      if (trp->action == OUTPUT) break;
    }

   return tr;
}


main(int argc, char *argv[])
 { Reader reader(argv[1], argv[2]);
   Machine machine(&reader);
   Machine::Transition *tr = 0;

   for (int x = getchar(); x != EOF; x = getchar())
    { tr = machine.Process(tr, (x >> 6) & 0x3);
      tr = machine.Process(tr, (x >> 4) & 0x3);
      tr = machine.Process(tr, (x >> 2) & 0x3);
      tr = machine.Process(tr, x & 0x3);
    }

   machine.Process(tr, 4);
   reader.Finish();
 }

 
