#include <stdio.h>

class Writer
 { private:
      int i;
      char c;

   public:
      Writer(void) : i(0), c(0) {}
      ~Writer() {}

      void Write(int x)
       { c = (c << 2) | (x & 0x3);

         if (++i >= 4) { putchar(c); i = 0; c = 0; }
       }
 };

class Machine
 { private:
      typedef enum Action { UNKNOWN = 0, COUNT, RESET, OUTPUT, DONE } Action;

      typedef enum State
       { SAME = 0, BOL_WHITE, BOL_TOKEN, INT_WHITE, INT_TOKEN }
         State;

      class Transition
       { public:
            int c;
            int next;
            Action action;
       };

      Writer writer;
      int i;

   public:
      Machine(void) : i(0) { }
      ~Machine() { }
      Transition *Process(Transition *tr, int c);
 };


Machine::Transition *Machine::Process(Transition *tr, int c)
 { static Transition bolWhiteTrans[] =
    {  { ' ',  SAME,      RESET },
       { '\t', SAME,      RESET },
       { '\r', SAME,      RESET },
       { '\n', SAME,      RESET },
       { EOF,  SAME,      DONE  },
       { '\0', BOL_TOKEN, RESET }
    };

   static Transition bolTokenTrans[] =
    {  { ' ',  INT_WHITE, COUNT },
       { '\t', INT_WHITE, COUNT },
       { '\r', BOL_WHITE, RESET },
       { '\n', BOL_WHITE, RESET },
       { EOF,  BOL_WHITE, DONE  },
       { '\0', SAME,      RESET }
    };

   static Transition intWhiteTrans[] =
    {  { ' ',  SAME,      COUNT },
       { '\t', SAME,      COUNT },
       { '\r', BOL_WHITE, RESET },
       { '\n', BOL_WHITE, RESET },
       { EOF,  BOL_WHITE, DONE  },
       { '\0', INT_TOKEN, OUTPUT }
    };

   static Transition intTokenTrans[] =
    {  { ' ',  INT_WHITE, COUNT },
       { '\t', INT_WHITE, COUNT },
       { '\r', BOL_WHITE, RESET },
       { '\n', BOL_WHITE, RESET },
       { EOF,  BOL_WHITE, DONE  },
       { '\0', SAME,      RESET }
    };

   static Transition *transMap[] =
    { 0, bolWhiteTrans, bolTokenTrans, intWhiteTrans, intTokenTrans };

   Transition *trp;

   for (trp = tr ? tr : bolWhiteTrans; trp->c && (trp->c != c); trp++) ;

   switch (trp->action)
    { case RESET:   i = 0;                   break;
      case COUNT:   i++;                     break;

      case OUTPUT:
 	 if (i > 4) return 0; else { writer.Write(i - 1); i = 0; break; }

      case DONE:                             return 0;
      default:                               break;
    }

   if (trp->next) tr = transMap[trp->next];

   return tr;
 }


main(int argc, char *argv[])
 { Machine machine;
   Machine::Transition *tr = 0;

   for (int x = getchar(); x != EOF; x = getchar())
      if (!(tr = machine.Process(tr, x))) break;
 }

 
