unit unitURLEntry;

interface
uses SysUtils,Classes,CRC32;

type
 PTHashEntry = ^THashEntry;
 THashEntry = Record
  hash           :LongInt;
  hashstr        :AnsiString; { dynamic }
  next           :PTHashEntry;
 end;

 POURLEntry = ^OURLEntry;
 OURLEntry = Object
  Constructor  Create;
  Destructor   Destroy;

  Procedure    AddHash(const hash: LongInt);
  Function     AttachHashStr(const s: String;const Lock: Boolean): Integer;
  Function     GetURL: String;
  Function     isFullURL: Boolean;

  public
   IP            :String[16];
   FiltCat       :Word;

  private
   Hashes        :PTHashEntry;
   HashCnt       :Byte;
   CntAttached   :Byte;
 end;

implementation

Constructor OURLEntry.Create;
begin
 IP:='';
 FiltCat:=$0000;
 Hashes:=nil;
 HashCnt:=0;
 CntAttached:=0;
end;

Destructor OURLEntry.Destroy;
begin
end;

Procedure  OURLEntry.AddHash(const hash: LongInt);
var
 NewNode,CurrNode    :PTHashEntry;
begin
 New(Newnode);
 NewNode.hash:=hash;
 NewNode.hashstr:='';
 NewNode.next:=nil;
 if Hashes=nil then Hashes:=NewNode else
 begin
  CurrNode:=Hashes;
  While CurrNode.next<>nil do CurrNode:=CurrNode.next;
  CurrNode.next:=NewNode;
 end;
 Inc(HashCnt);
end;

Function   OURLEntry.AttachHashStr(const s: String;const Lock: Boolean): Integer;
var
 CurrNode     :PTHashEntry;
 CRC          :LongInt;
begin
  result:=0;
  CurrNode:=Hashes;
  CRC:=CRC32String(S);
  While CurrNode<>nil do
  begin
   if CurrNode.hash=CRC then { let's attach it then }
    if (not lock) or ((lock and (CurrNode.hashstr=''))) then
    begin
     if CurrNode.hashstr='' then Inc(CntAttached);
     CurrNode.hashstr:=s;
     Inc(result);
    end;
   CurrNode:=CurrNode.next;
  end;
end;

Function   OURLEntry.GetURL: String;
var
 s            :String;
 CurrNode     :PTHashEntry;
begin
  s:='';
  CurrNode:=Hashes;
  While CurrNode<>nil do
  begin
   if CurrNode.hashstr='' then
     s:=s+'/<'+IntToHex(CurrNode.hash,8)+'>'
   else s:=s+'/'+CurrNode.hashstr;
   CurrNode:=CurrNode.next;
  end;
 GetURL:=s;
end;

Function   OURLEntry.isFullURL: Boolean;
(*
var
 CurrNode     :PTHashEntry;
begin
 result:=false;
 CurrNode:=Hashes;
 While CurrNode<>nil do
 begin
  if CurrNode.hashstr='' then exit;
  CurrNode:=CurrNode.next;
 end;
 result:=true;*)
begin
 isFullURL:=(HashCnt=CntAttached);
end;

end.
