print "Running Simple.py"


	#####################################################################
	# The purpose of this file is to provide working sample code that   #
	# you can cut and paste into your own scripts.  You can run it, but #
	# it doesn't do anything interesting and it makes a mess.           #
	#####################################################################


####################################################################
# The "desktop" object is in the namespace by default.  
# Here are some things you can do with it.
####################################################################

# --------------------------
# Get the name of the server
# --------------------------

serverName = desktop.getServerName()
print "Server Name: " + serverName

# -------------------------
# get the size of the board
# -------------------------

left, top, right, bottom = desktop.getRect()
width = right - left
height = bottom - top
print "board size: " + `width` + " by " + `height`

# --------------------------------
# get and set the background color
# --------------------------------

bgColor = desktop.getBackgroundColor()
print "current background color: " + `bgColor`

desktop.setBackgroundColor((0, 0, 255))
# could also do "desktop.setBackgroundColor(BLUE)"

# --------------------------
# set the background picture
# --------------------------

# This appears to have some bugs right now, but feel free to try it

# desktop.setBackgroundPictureFromFile("examplestuff\\stars.bmp")

# to remove the current background picture:

# desktop.setBackgroundPictureFromFile(None)

# ----------------------------
# save a snapshot of the board
# ----------------------------

desktop.saveSnapshot("snapshot.bmp")

####################################################################
# Manipulating objects
####################################################################

# WARNING: DO NOT MANIPULATE OBJECTS IMMEDIATELY AFTER THEY ARE CREATED!!!
# The object creation functions allow you to specify everything about the
# appearance of the object.  This is good:
# 
#	desktop.createNote(100, 100)
#
# This is bad:
#
#	myNote = desktop.createNote()
#   myNote.setPosition(100, 100)
#
# The above code will put MessyBoard in an unstable state, and you may
# need to reboot your computer.  Yes, I'm working on it. :-)

# for a complete list of object member functions, see the class definitions
# for Arrow, Note, Link, etc. in MessyAPI.py

# ------------------
# create new objects
# ------------------

# See MessyAPI.py for the full list of parameters for each of these functions

# * left, top, right, and bottom are for specifying the initial position and dimensions
# * autoSize is a boolean parameter indicating weather or not a note or picture should have
#   its size set automatically
# * callListeners is a boolean parameter indicating whether or not your creation callbacks should
#   be called.  (More about this under "Events and listeners")

# myNote = desktop.createNote(10, 10, text="Note")
# myPicture = desktop.createPictureFromFile("stage3faces\\adam.jpg", 10, 30)
# myArrow = desktop.createArrow(10, 50, RIGHT, text="Arrow")
# myThoughtBubble = desktop.createThoughtBubble(10, 70, LEFT, text="Thought Bubble")
# myCapsule = desktop.createCapsule(10, 90, text="Capsule")
# myLink = desktop.createLink(10, 110, text="Link", url="http://www.cs.cmu.edu")

# ---------------
# destroy objects
# ---------------

# desktop.destroyObject(anyObject)

# ---------------------
# get a list of objects
# ---------------------

# objectList = desktop.getObjectList()
# for object in objectList:
#	print str(object)

# ------------
# object types
# ------------

# for a list of object types, see MessyAPI.py

# print the type of every object

# print "object types: "
# for object in desktop.getObjectList():
# 	print object.getType()

# -----------------------------------------------------
# test if an object is a note (or picture, arrow, etc.)
# -----------------------------------------------------

# for object in desktop.getObjectList():
#	if (object.isNote()):
#		print "found a note!"

# ----------------------------
# get and set an object's text
# ----------------------------

# all objects have text, but you never see the text for a picture

# for object in desktop.getObjectList():
#	text = object.getText()
#	print "object text: " + text
#	newtext = text + " new text"
#	object.setText(newtext)

# ------------------------------------------
# change an object's position and dimensions
# ------------------------------------------

# use setRect and getRect to deal with objects as simple rectangles

# left, top, right, bottom = anyObject.getRect()
# anyObject.setRect(left + 10, top + 10, right + 10, bottom + 10)

# convenient functions to move without resizing or vice-versa

# anyObject.setPosition(30, 30)
# anyObject.setSize(50, 100)

# save a snapshot

# anyObject.saveSnapshot("snapshot.bmp")

####################################################################
# Events and listeners
####################################################################

# --------------------------
# adding a listener function
# --------------------------

# all event listeners should take two parameters: desktop and object
# this function will be called any time an object is created

def createListener(desktop, object):
	print "object created: " + str(object.getType())

desktop.addListener(CREATE_EVENT, createListener)

# to remove the event listener:

# desktop.removeListener(CREATE_EVENT, createListener)

# for a complete list of events, see MessyAPI.py
# these events aren't working yet:
# SETBGIMAGE_EVENT
# SETBGCOLOR_EVENT
# STRINGBROADCAST_EVENT

# -------------------
# using callListeners
# -------------------
 
# if your program generates an event, you may not want your listener
# to be called.  For example, you might have a create listener that
# creates a new object, and you don't want the listener to be called
# again for that object.  (This could cause infinite recursion.)

# All functions that generate an event have a "callListeners" parameter.
# If the value is TRUE then any installed listeners will be called.
# If the value is FALSE then your listeners will not be called.
# The default value is TRUE.

# here's how to create a note without calling listener:

# desktop.createNote(text="no listener", callListeners=FALSE)

####################################################################
# Timers
####################################################################

# this function will be called every 5 seconds

def timerCallback():
	print "timer"

# setting the timer: the first parameter is an interval in seconds

timerID = startTimer(5.0, timerCallback)

# to remove the timer:

# stopTimer(timerID)

# to remove all timers:

# stopAllTimers()

####################################################################
# USB Camera
####################################################################

# capture a frame from a USB camera and save it to a file

# import FrameGrab
# FrameGrab.grabFrame("frame.bmp")

# put it on the desktop

# desktop.createPictureFromFile("frame.bmp")