print "running Advanced.py"

	############################################
	# This file contains some sample projects. #
	# Each example declares functions to start #
	# and stop its behavior.  You must call    #
	# these functions yourself.                #
	############################################

#######################################################################
# PONG
#######################################################################

# The name says it all.

import random

g_pongTimerID = 0
g_pongInterval = 1.0 / 15.0
g_pongBallSpeed = 90.0				# pixels per second
g_pongBall = None
g_pongBallRadius = 10.0
g_pongLeftPaddle = None
g_pongRightPaddle = None

def randomBounce(x):
	new = x + (random.uniform(-g_pongBallSpeed, g_pongBallSpeed))
	if (new < -g_pongBallSpeed):
		new = -g_pongBallSpeed
	if (new > g_pongBallSpeed):
		new = g_pongBallSpeed

	return new

def moveBall(ball, interval):
	newPosition = ((ball.position[0] + ball.velocity[0] * interval), (ball.position[1] + ball.velocity[1] * interval))

	left, top, right, bottom = g_pongRightPaddle.getRect()
	rp_x = left
	rp_top = top
	rp_bottom = bottom

	left, top, right, bottom = g_pongLeftPaddle.getRect()
	lp_x = right
	lp_top = top
	lp_bottom = bottom

	# Right paddle collision
	if ((ball.velocity[0] > 0) and (newPosition[0] + g_pongBallRadius > rp_x) and (newPosition[1] >= rp_top) and (newPosition[1] <= rp_bottom)):
		ball.velocity = (-ball.velocity[0], randomBounce(ball.velocity[1]))
		newPosition = ((ball.position[0] + ball.velocity[0] * interval), (ball.position[1] + ball.velocity[1] * interval))

	# Left paddle collision
	if ((ball.velocity[0] < 0) and (newPosition[0] - g_pongBallRadius < lp_x) and (newPosition[1] >= lp_top) and (newPosition[1] <= lp_bottom)):
		ball.velocity = (-ball.velocity[0], randomBounce(ball.velocity[1]))
		newPosition = ((ball.position[0] + ball.velocity[0] * interval), (ball.position[1] + ball.velocity[1] * interval))

	# top wall
	if (newPosition[1] - g_pongBallRadius < 0):
		ball.velocity = (ball.velocity[0], -ball.velocity[1])
		newPosition = ((ball.position[0] + ball.velocity[0] * interval), (ball.position[1] + ball.velocity[1] * interval))

	# bottom wall
	if (newPosition[1] + g_pongBallRadius > 707):
		ball.velocity = (ball.velocity[0], -ball.velocity[1])
		newPosition = ((ball.position[0] + ball.velocity[0] * interval), (ball.position[1] + ball.velocity[1] * interval))

	ball.position = newPosition
	ball.setRect(newPosition[0] - g_pongBallRadius, newPosition[1] - g_pongBallRadius, newPosition[0] + g_pongBallRadius, newPosition[1] + g_pongBallRadius, FALSE)

def pongTimerCallback():
	moveBall(g_pongBall, g_pongInterval)

def startPong():
	global g_pongTimerID, g_pongBall, g_pongLeftPaddle, g_pongRightPaddle

	g_pongTimerID = startTimer(g_pongInterval, pongTimerCallback)
	g_pongBall = desktop.createNote(500 - g_pongBallRadius, 300 - g_pongBallRadius, 500 + g_pongBallRadius, 300 + g_pongBallRadius, noteColor=GREEN, autoSize=FALSE, callListeners=FALSE)
	g_pongLeftPaddle = desktop.createNote(50, 300, 90, 450, (255, 255, 255), (0, 0, 0), "C\nM\nU", FALSE, FALSE)
	g_pongRightPaddle = desktop.createNote(900, 300, 940, 450, (255, 255, 255), (0, 0, 0), "U\nV\na", FALSE, FALSE)
	g_pongBall.position = (500.0, 300.0)
	g_pongBall.velocity = (g_pongBallSpeed, 0)
	print "Pong program running"

def stopPong():
	stopTimer(g_pongTimerID)
	desktop.destroyObject(g_pongBall, FALSE)
	desktop.destroyObject(g_pongLeftPaddle, FALSE)
	desktop.destroyObject(g_pongRightPaddle, FALSE)
	print "Pong program stopped"

#########################################################################################
# GOOGLE IMAGE SEARCH
#########################################################################################

# This program searches for an image whenever a note is dragged into the bottom left-hand
# corner of the board.  It uses the text of note as a query and it takes the first hit from
# the Google image search engine and puts it on the board.

import urllib

# make it look like the search request is really coming from Mozilla, otherwise
# Google will return an error
class AppURLopener(urllib.FancyURLopener):
    def __init__(self, *args):
        self.version = "Mozilla/4.0"
        urllib.FancyURLopener.__init__(self, *args)

urllib._urlopener = AppURLopener()

g_filenameCounter = 0

def makeTempFilename():
	global g_filenameCounter
	filenameCounter = filenameCounter + 1
	return "file%d.jpg"%(filenameCounter,)

def getImage(text):
	iTag = text.find("<a href=/imgres?imgurl=")
	if (iTag < 0):
		return None

	iBegin = iTag + len("<a href=/imgres?imgurl=")
	iEnd = iBegin + text[iBegin:].find("&")
	if (iEnd < iBegin):
		print "end < begin"
		return None

	imageURL = "http://" + text[iBegin:iEnd]
	
	filename, headers = urllib.urlretrieve(imageURL)
	# print filename
	
	if (headers.typeheader in ["image/jpeg", "image/gif", "image/bmp"]):
		# print headers.typeheader
		return filename
	else:
		return None

def googleImageSearch(query):
	keywordlist = query.split()
	searchURL = "http://images.google.com/images?q="
	searchURL = searchURL + keywordlist[0]
	for keyword in keywordlist[1:]:
		searchURL = searchURL + "+" + keyword

	searchURL= searchURL + "&ie=UTF8&oe=UTF8&hl=en"

	print "-----searchURL: " + searchURL
	
	try:
		resultsFile = urllib.urlopen(searchURL)
	except:
		return None

	if (resultsFile == None):
		return None

	for line in resultsFile.readlines():
		filename = getImage(line)
		if (filename):
			resultsFile.close()
			return filename

	resultsFile.close()
	return None

def googleMoveListener(desktop, userID, object):
	if (object.isNote()):
		left, top, right, bottom = object.getRect()
		if ((left <  50) and (bottom > 650)):
			print "search"
			imagefile = googleImageSearch(object.getText())
			if (imagefile != None):
				desktop.createPictureFromFile(imagefile)
			else:
				desktop.createNote(text="No Picture")

def startGoogle():
	print "running google image search"
	desktop.addListener(MOVE_EVENT, googleMoveListener)

def stopGoogle():
	desktop.removeListener(MOVE_EVENT, googleMoveListener)
	print "stopped google image search"

#########################################################################################
# TIMELINE
#########################################################################################

# slowly moves everything to the left over time.

TIMELINE_INTERVAL = 1

timelineTimerID = None

def moveAllObjects(distance):
	objectList = desktop.getObjectList(EVERY_TYPE)
	for object in objectList:
		left, top, right, bottom = object.getRect()
		object.setPosition(left - distance, top)

def timelineTimerCallback():
	moveAllObjects(1)

def startTimeline():
	global timelineTimerID
	timelineTimerID = startTimer(TIMELINE_INTERVAL, timelineTimerCallback)
	print "started timeline"

def stopTimeline():
	global timelineTimerID
	stopTimer(timelineTimerID)
	timelineTimerID = None
	print "stopped timeline"

def rewind(t):
	moveAllObjects(-t)

#########################################################################################
# SATURATION
#########################################################################################

# slowly desaturates the background color of all notes over time

SATURATION_INTERVAL = 0.5

saturationTimerID = None

def saturateAllObjects(distance):
	objectList = desktop.getObjectList(EVERY_TYPE)
	for object in objectList:
		if (object.isNote()):
			if (object.saturation > 0.01):
				object.saturation -= 0.05
				
				red, green, blue = object.initColor
				
				if ((red == green) and (green == blue)):
					pass
				else:
					highest = red
					if (green > highest):
						highest = green
					if (blue > highest):
						highest = blue

					redDiff = highest - red
					greenDiff = highest - green
					blueDiff = highest - blue


					newRed = red + (redDiff * (1.0 - object.saturation))
					newGreen = green + (greenDiff * (1.0 - object.saturation))
					newBlue = blue + (blueDiff * (1.0 - object.saturation))
					newBgColor = (newRed, newGreen, newBlue)

					bgColor, fgColor = object.getColors()
					object.setColors(newBgColor, fgColor)

def saturationTimerCallback():
	saturateAllObjects(1)

def saveInitColors():
	objectList = desktop.getObjectList(EVERY_TYPE)
	for object in objectList:
		if (object.isNote()):
			bgColor, fgColor = object.getColors()
			object.initColor = bgColor
			object.saturation = 1.0

def restoreInitColors():
	objectList = desktop.getObjectList(EVERY_TYPE)
	for object in objectList:
		if (object.isNote()):
			bgColor, fgColor = object.getColors()
			object.setColors(object.initColor, fgColor)

def saturationCreateListener(desktop, userID, object):
	if (object.isNote()):
		bgColor, fgColor = object.getColors()
		object.initColor = bgColor
		object.saturation = 1.0

def saturationMoveListener(desktop, userID, object):
	if (object.isNote()):
		object.saturation = 1.0
		bgColor, fgColor = object.getColors()
		object.setColors(object.initColor, fgColor)

def startSaturation():
	global saturationTimerID

	print "saturation running"

	saveInitColors()
	desktop.addListener(CREATE_EVENT, saturationCreateListener)
	desktop.addListener(MOVE_EVENT, saturationMoveListener)
	saturationTimerID = startTimer(SATURATION_INTERVAL, saturationTimerCallback)

def stopSaturation():
	global saturationTimerID
	stopTimer(saturationTimerID)
	saturationTimerID = None
	desktop.removeListener(CREATE_EVENT, saturationCreateListener)
	desktop.removeListener(MOVE_EVENT, saturationMoveListener)
	restoreInitColors()

	print "saturation stopped"

#########################################################################################
# FACES
#########################################################################################

# this script look at a new note's background color to see who made it, and it puts a
# picture of that person's face next to the note.  Any time the note is moved, the picture
# is automatically moved to stay with it, and vice-versa.  Deleting the note causes the
# picture to be deleted, and vice-versa.

DENNIS = 0
JASON = 1
DAN = 2
DAVE = 3
BEN = 4
ADAM = 5
MONZY = 6
DESNEY = 7

COLOR_LIST = [0, 1, 2, 3, 4, 5, 6, 7]

COLOR_LIST[DENNIS] = (154, 209, 148)
COLOR_LIST[JASON] = (91, 126, 185)
COLOR_LIST[DAN] = (0, 64, 0)
COLOR_LIST[DAVE] = (147, 60, 145)
COLOR_LIST[BEN] = (255, 153, 0)
COLOR_LIST[ADAM] = (128, 0, 0)
COLOR_LIST[MONZY] = (110, 160, 240)
COLOR_LIST[DESNEY] = (0, 0, 160)

PICTURE_PATH = "stage3faces\\"

FILENAME_LIST = [0, 1, 2, 3, 4, 5, 6, 7]

FILENAME_LIST[DENNIS] = PICTURE_PATH + "dennis.jpg"
FILENAME_LIST[JASON] = PICTURE_PATH + "jason.jpg"
FILENAME_LIST[DAN] = PICTURE_PATH + "dan.jpg"
FILENAME_LIST[DAVE] = PICTURE_PATH + "dave.jpg"
FILENAME_LIST[BEN] = PICTURE_PATH + "ben.jpg"
FILENAME_LIST[ADAM] = PICTURE_PATH + "adam.jpg"
FILENAME_LIST[MONZY] = PICTURE_PATH + "monzy.jpg"
FILENAME_LIST[DESNEY] = PICTURE_PATH + "desney.jpg"

def personFromColor(color):
	for i in range(0, len(COLOR_LIST)):
		if (color == COLOR_LIST[i]):
			return i

def putPictureByNote(picture, note):
	left, top, right, bottom = note.getRect()
	picture.setPosition(left - 100, top, callListeners = FALSE)
	
def putNoteByPicture(picture, note):
	left, top, right, bottom = picture.getRect()
	note.setPosition(left + 100, top, callListeners = FALSE)

def facesCreateListener(desktop, userID, object):
	if (object.isNote()):
		bgColor, fgColor = object.getColors()
		if (bgColor in COLOR_LIST):
			left, top, right, bottom = object.getRect()
			person = personFromColor(bgColor)
			picture = desktop.createPictureFromFile(FILENAME_LIST[person], left=left-100, top=top)
			object.picture = picture
			picture.note = object
			# putPictureByNote(picture, object)
		else:
			object.picture = None

def facesDestroyListener(desktop, userID, object):
	if (object.isNote() and (object.picture != None)):
		object.picture.note = None
		desktop.destroyObject(object.picture, callListeners=FALSE)
		object.picture = None
	elif (object.isPicture() and (object.note != None)):
		object.note.picture = None
		desktop.destroyObject(object.note, callListeners=FALSE)
		object.note = None

def facesMoveListener(desktop, userID, object):
	if (object.isNote() and (object.picture != None)):
		putPictureByNote(object.picture, object)
	elif (object.isPicture() and (object.note != None)):
		putNoteByPicture(object, object.note)

def initObjects():
	objectList = desktop.getObjectList(EVERY_TYPE)
	for object in objectList:
		if object.isNote():
			object.picture = None
		elif object.isPicture():
			object.note = None

def startFaces():
	initObjects()
	desktop.addListener(CREATE_EVENT, facesCreateListener)
	desktop.addListener(MOVE_EVENT, facesMoveListener)
	desktop.addListener(DESTROY_EVENT, facesDestroyListener)

	print "faces started"

def stopFaces():
	desktop.removeListener(CREATE_EVENT, facesCreateListener)
	desktop.removeListener(MOVE_EVENT, facesMoveListener)
	desktop.removeListener(DESTROY_EVENT, facesDestroyListener)

	print "faces stopped"

#######################################################################
# CAMERA
#######################################################################

# DO NOT TRY TO RUN THIS IF YOU DON'T HAVE A USB CAMERA PLUGGED IN AND
# THE CORRECT DRIVERS INSTALLED!!!

# This script posts an image from the camera on MessyBoard every 30 seconds.
# The previous image is deleted.

import FrameGrab

CAMERA_INTERVAL = 30.0

g_cameraLastPicture = None
g_cameraTimerID = None

def grabFrame():
	global g_cameraLastPicture
	print "grabbing frame"
	FrameGrab.grabFrame("frame.bmp")
	newPicture = desktop.createPictureFromFile("frame.bmp")
	if (g_cameraLastPicture != None):
		try:
			desktop.destroyObject(g_cameraLastPicture)
		except:
			pass
	g_cameraLastPicture = newPicture

def cameraTimerCallback():
	grabFrame()

def startCamera():
	global g_cameraTimerID

	print "camera started"
	cameraTimerCallback()
	g_cameraTimerID = startTimer(CAMERA_INTERVAL, cameraTimerCallback)

def stopCamera():
	global g_cameraTimerID
	stopTimer(g_cameraTimerID)
	print "camera stopped"