/*
 * hostafs - A lightweight AFS server
 *
 * Copyright (c) 1998-1999, 2002 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software_Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

/* hostafsd/includes.h - Include files and antibogosity for hostafsd */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <signal.h>
#include <unistd.h>
#include <memory.h>
#include <sys/stat.h>
#include <pwd.h>
#include <grp.h>
#include <netdb.h>
#include <errno.h>
#include <fcntl.h>
#include <netinet/in.h>

#if HAVE_DIRENT_H
#include <dirent.h>
#endif

#if HAVE_SYS_MNTTAB_H
#include <sys/mnttab.h>
#endif
#if HAVE_MNTENT_H
#include <mntent.h>
#endif
#if HAVE_FSTAB_H
#include <fstab.h>
#endif

#if HAVE_SYS_STATFS_H
#include <sys/statfs.h>
#endif
#if HAVE_SYS_VFS_H
#include <sys/vfs.h>
#endif
#if HAVE_SYS_STATVFS_H
#include <sys/statvfs.h>
#endif
#if HAVE_SYS_FSTYP_H
#include <sys/fstyp.h>
#endif


#include <lwp.h>
#include <rx/rx.h>
#include <rx/rx_null.h>
#include <rx/rxkad.h>
#include <lock.h>
#include <krb.h>
#include <krb_err.h>

#include <afs/afsint.h>
#include <afs/errors.h>
#include <afs/vlserver.h>
#include <afs/volint.h>
#include <afs/volser.h>
#include <afs/prs_fs.h>
#include <int/services.h>
#include <int/hafsint.h>
#include <int/hafserrs.h>

#ifndef VNAMESIZE
#define VNAMESIZE 32 
#endif

/* The set of filesystem types we will export by default. */
/* XXX allow this to change at runtime */
/* XXX pick better os-dependent defaults in configure */
#define DEF_FSTYPES "ext2", "ext3", "ufs", "hsfs", "iso9660", "hfs"

#ifndef MNTOPT_RO
#define MNTOPT_RO "ro"
#endif

#if !defined(MOUNTED) && defined(MNTTAB)
#define MOUNTED MNTTAB
#endif

#if !HAVE_STRUCT_MNTENT && HAVE_STRUCT_MNTTAB
#define mntent mnttab
#define mnt_fsname  mnt_special
#define mnt_dir     mnt_mountp
#define mnt_type    mnt_fstype
#define mnt_opts    mnt_mntopts
#endif

#if HAVE_GETMNTENT && !HAVE_SETMNTENT
#define setmntent fopen
#define endmntent fclose
#endif

#if HAVE_GETMNTENT2
#define getmntent_2(f,e) (getmntent((f),(e)) ? 0 : (e))
#else
#define getmntent_2(f,e) (getmntent(f))
#endif
