/*
 * hostafs - A lightweight AFS server
 *
 * Copyright (c) 1998-1999 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software_Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

/* hafsprocs.c - hostafs control RPC's */

#include "includes.h"
#include "hostafsd.h"


int SHAFS_InstallCheck(struct rx_call *call, hafs_version *vers)
{
  debug(DEBUG_RPC, "%I => HAFS_InstallCheck()",
        rx_HostOf(rx_PeerOf(rx_ConnectionOf(call))));
  *vers = HAFS_VERCODE;
  return 0;
}


int SHAFS_SetDebug(struct rx_call *call, afs_uint32 level)
{
  CI *client;

  debug(DEBUG_RPC, "%I => HAFS_SetDebug(%u)",
        rx_HostOf(rx_PeerOf(rx_ConnectionOf(call))), level);
  client = ci_getinfo(call);
  if (!ci_rootok(client)) return HAFS_NOTAUTH;
  hafs_debug = level;
  return 0;
}


int 
SHAFS_GetDebug(struct rx_call *call, afs_uint32 *level)
{
  CI *client;

  debug(DEBUG_RPC, "%I => HAFS_GetDebug()",
        rx_HostOf(rx_PeerOf(rx_ConnectionOf(call))));
  *level = hafs_debug;
  return 0;
}


int SHAFS_SetUser(struct rx_call *call, afs_uint32 mode, char *lcluser)
{
  CI *client;

  if (lcluser && !lcluser[0]) lcluser = 0;
  debug(DEBUG_RPC, "%I => HAFS_SetUser(%d, %s)",
        rx_HostOf(rx_PeerOf(rx_ConnectionOf(call))),
        mode, lcluser ? lcluser : "<none>");
  client = ci_getinfo(call);
  return ci_setauth(client, mode, lcluser);
}
