/*
 * hostafs - A lightweight AFS server
 *
 * Copyright (c) 1998-1999 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software_Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

/* bulk.c - Rx bulk data transfer */

#include "includes.h"
#include "hostafsd.h"


#define BULK_ROCK    0x42554C4B   /* tag for LWP rocks holding our buffers */
#define BULK_BUFSIZE 32768        /* buffer size */


afs_uint32 bulk_xmit_fd(struct rx_call *call, int fd, afs_uint32 length)
{
  struct stat sbuf;
  off_t where;
  afs_uint32 x;
  size_t count;
  ssize_t r;
  char *buf;

  if (fstat(fd, &sbuf)) return errno;
  where = lseek(fd, 0, SEEK_CUR);
  if (where == -1) return errno;

  if (where > sbuf.st_size) length = 0;
  else if (length == 999999999 || length > sbuf.st_size - where)
    length = sbuf.st_size - where;
  x = htonl(length);
  rx_Write(call, &x, 4);

  if (LWP_GetRock(BULK_ROCK, &buf)) {
    buf = osi_Alloc(BULK_BUFSIZE);
    LWP_NewRock(BULK_ROCK, buf);
  }

  while (length > 0) {
    count = length > BULK_BUFSIZE ? BULK_BUFSIZE : length;
    r = read(fd, buf, count);
    if (r < 0) return errno;
    if (!r) break;
    rx_Write(call, buf, r);
    length -= r;
  }
  return 0;
}


afs_uint32 bulk_xmit_str(struct rx_call *call, char *str, afs_uint32 length)
{
  afs_uint32 x;

  if (length == 999999999) length = strlen(str);
  if (length > strlen(str)) length = strlen(str);
  x = htonl(length);
  rx_Write(call, &x, 4);
  rx_Write(call, str, length);
  return 0;
}
