/*
 * humanPPI.java
 *
 * Created on July 5, 2006, 1:50 PM
 */

package humanFPPI;

import java.util.*;

/**
 *
 * @author  qyj
 */
public class humanPPI extends javax.swing.JFrame {

   // Variable self declared
    public int ConfirmGeneID = -1; 
    public Vector ConfirmGeneIDArray = new Vector(); 
    public String ConfirmGeneName = "";     
    public humanPPIRunCommand current; 
    public int currentCheckChoice = 0; 
    public int currentPredictChoice = 0; 
    public int currentPredictRFmodelChoice = 0; 
    
    /** Creates new form humanPPI */
    public humanPPI(  ) {
        initComponents();
        current = new humanPPIRunCommand();         
    }
   
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        InputPanel = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        geneIDinput = new javax.swing.JTextField();
        geneNameInput = new javax.swing.JTextField();
        jScrollPane2 = new javax.swing.JScrollPane();
        ncbiGeneInfo = new javax.swing.JTextArea();
        checkInputGeneButton = new javax.swing.JButton();
        RequestGeneInfoFile = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jComboBoxCheckChoice = new javax.swing.JComboBox();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        reTrainPanel = new javax.swing.JPanel();
        retrainButton = new javax.swing.JButton();
        inputRelatedGeneListFileField = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTextAreaReTrainLog = new javax.swing.JTextArea();
        TaskNameTestField = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        TestPanel = new javax.swing.JPanel();
        generatePPIlist = new javax.swing.JButton();
        GenerateFeature = new javax.swing.JButton();
        predictTesting = new javax.swing.JButton();
        analyzeTesting = new javax.swing.JButton();
        testPairListFileField = new javax.swing.JTextField();
        testFeatureFileField = new javax.swing.JTextField();
        testResultFileField = new javax.swing.JTextField();
        testAnalyzeResultFileField = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaLog = new javax.swing.JTextArea();
        jButtonBatchPredictPPI = new javax.swing.JButton();
        jLabel9 = new javax.swing.JLabel();
        jComboBoxPredictChoice = new javax.swing.JComboBox();
        jLabel11 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        jComboBoxRFModelChoice = new javax.swing.JComboBox();
        jTextFieldNewRFModelFile = new javax.swing.JTextField();
        jTextFieldPartnerGeneFile = new javax.swing.JTextField();
        jLabel15 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("HumanPPI");
        setBackground(new java.awt.Color(255, 255, 204));
        setIconImage(getIconImage());
        setResizable(false);
        jLabel1.setBackground(new java.awt.Color(204, 255, 255));
        jLabel1.setFont(new java.awt.Font("Arial Unicode MS", 1, 14));
        jLabel1.setForeground(new java.awt.Color(0, 51, 153));
        jLabel1.setIcon(new javax.swing.ImageIcon("G:\\qyj\\research\\12-HumanDrosophiliavalidate-software\\pic\\ppi.bmp"));
        jLabel1.setText("Interface of HPPIPM ( Human Protein-Protein Interaction Prediction from Multiple Sources Integration)");

        InputPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(new javax.swing.border.LineBorder(new java.awt.Color(102, 0, 102), 1, true), "Test Gene Information Input ", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 1, 12)));
        InputPanel.setName("Input");
        InputPanel.setOpaque(false);
        jLabel2.setText("Gene ID");

        jLabel3.setText("Gene Name");

        geneIDinput.setAutoscrolls(false);

        geneNameInput.setAutoscrolls(false);

        jScrollPane2.setBackground(new java.awt.Color(252, 249, 231));
        ncbiGeneInfo.setBackground(new java.awt.Color(255, 255, 239));
        ncbiGeneInfo.setColumns(20);
        ncbiGeneInfo.setEditable(false);
        ncbiGeneInfo.setRows(5);
        ncbiGeneInfo.setAutoscrolls(false);
        ncbiGeneInfo.setBorder(javax.swing.BorderFactory.createTitledBorder("Request Gene Information"));
        ncbiGeneInfo.setVerifyInputWhenFocusTarget(false);
        jScrollPane2.setViewportView(ncbiGeneInfo);

        checkInputGeneButton.setFont(new java.awt.Font("Arial", 1, 11));
        checkInputGeneButton.setText("Check Input Request Gene(s)");
        checkInputGeneButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkInputGeneButtonActionPerformed(evt);
            }
        });

        RequestGeneInfoFile.setFont(new java.awt.Font("Tahoma", 0, 10));
        RequestGeneInfoFile.setAutoscrolls(false);
        RequestGeneInfoFile.setEnabled(false);
        RequestGeneInfoFile.setVerifyInputWhenFocusTarget(false);

        jLabel7.setFont(new java.awt.Font("Tahoma", 0, 10));
        jLabel7.setForeground(new java.awt.Color(51, 51, 255));
        jLabel7.setText(" (Please Use Absolute File Path)");

        jComboBoxCheckChoice.setFont(new java.awt.Font("Arial", 0, 10));
        jComboBoxCheckChoice.setForeground(new java.awt.Color(0, 51, 204));
        jComboBoxCheckChoice.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Single Gene", "Gene List" }));
        jComboBoxCheckChoice.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxCheckChoiceActionPerformed(evt);
            }
        });

        jLabel12.setText("Gene List File");

        jLabel13.setText("Choice");

        org.jdesktop.layout.GroupLayout InputPanelLayout = new org.jdesktop.layout.GroupLayout(InputPanel);
        InputPanel.setLayout(InputPanelLayout);
        InputPanelLayout.setHorizontalGroup(
            InputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(InputPanelLayout.createSequentialGroup()
                .add(InputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(InputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, InputPanelLayout.createSequentialGroup()
                            .addContainerGap()
                            .add(InputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(jLabel3)
                                .add(InputPanelLayout.createSequentialGroup()
                                    .add(16, 16, 16)
                                    .add(jLabel2)))
                            .add(22, 22, 22)
                            .add(InputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(InputPanelLayout.createSequentialGroup()
                                    .add(geneNameInput, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 208, Short.MAX_VALUE)
                                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED))
                                .add(geneIDinput, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 208, Short.MAX_VALUE)
                                .add(jComboBoxCheckChoice, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 94, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(32, 32, 32))
                        .add(org.jdesktop.layout.GroupLayout.LEADING, InputPanelLayout.createSequentialGroup()
                            .add(46, 46, 46)
                            .add(jLabel13)))
                    .add(InputPanelLayout.createSequentialGroup()
                        .add(18, 18, 18)
                        .add(checkInputGeneButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 239, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)))
                .add(InputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(InputPanelLayout.createSequentialGroup()
                        .add(jLabel12, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 93, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(21, 21, 21)
                        .add(jLabel7, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 278, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jScrollPane2)
                    .add(RequestGeneInfoFile, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 564, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        InputPanelLayout.setVerticalGroup(
            InputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, InputPanelLayout.createSequentialGroup()
                .add(InputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(InputPanelLayout.createSequentialGroup()
                        .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 102, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(InputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(jLabel7)
                            .add(jLabel12))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(RequestGeneInfoFile, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 26, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(InputPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(checkInputGeneButton)
                        .add(15, 15, 15)
                        .add(InputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(jLabel13)
                            .add(jComboBoxCheckChoice, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(22, 22, 22)
                        .add(InputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(jLabel2)
                            .add(geneIDinput, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(16, 16, 16)
                        .add(InputPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(jLabel3)
                            .add(geneNameInput, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
        );

        reTrainPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(new javax.swing.border.LineBorder(new java.awt.Color(102, 0, 102), 1, true), "Re-Train on PPIs Related to Input Gene List Only", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 1, 12)));
        reTrainPanel.setName("Input");
        reTrainPanel.setOpaque(false);
        retrainButton.setFont(new java.awt.Font("Arial", 1, 11));
        retrainButton.setText("Re-Train RF model on Task List Related Only");
        retrainButton.setAutoscrolls(true);
        retrainButton.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        retrainButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                retrainButtonActionPerformed(evt);
            }
        });

        inputRelatedGeneListFileField.setFont(new java.awt.Font("Arial", 0, 10));
        inputRelatedGeneListFileField.setText("G:\\qyj\\research\\12-HumanDrosophiliavalidate-software\\12HumanValidate\\5taskListTrain\\inputTaskList\\test2.GeneNames.txt");
        inputRelatedGeneListFileField.setAutoscrolls(false);

        jLabel4.setText("Input Task Related Gene List File Location:");

        jTextAreaReTrainLog.setBackground(new java.awt.Color(255, 255, 239));
        jTextAreaReTrainLog.setColumns(20);
        jTextAreaReTrainLog.setEditable(false);
        jTextAreaReTrainLog.setRows(5);
        jTextAreaReTrainLog.setBorder(javax.swing.BorderFactory.createTitledBorder("Training Log Information"));
        jScrollPane3.setViewportView(jTextAreaReTrainLog);

        TaskNameTestField.setFont(new java.awt.Font("Arial", 0, 10));
        TaskNameTestField.setAutoscrolls(false);

        jLabel10.setText("Current Task Name");

        jLabel8.setFont(new java.awt.Font("Tahoma", 0, 10));
        jLabel8.setForeground(new java.awt.Color(0, 51, 255));
        jLabel8.setText("(Please Use Absolute File Path)");

        org.jdesktop.layout.GroupLayout reTrainPanelLayout = new org.jdesktop.layout.GroupLayout(reTrainPanel);
        reTrainPanel.setLayout(reTrainPanelLayout);
        reTrainPanelLayout.setHorizontalGroup(
            reTrainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(reTrainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(reTrainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(reTrainPanelLayout.createSequentialGroup()
                        .add(reTrainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(jLabel10)
                            .add(jLabel4))
                        .add(28, 28, 28))
                    .add(reTrainPanelLayout.createSequentialGroup()
                        .add(retrainButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 262, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)))
                .add(reTrainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(jLabel8, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 169, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(reTrainPanelLayout.createSequentialGroup()
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(inputRelatedGeneListFileField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 613, Short.MAX_VALUE))
                    .add(TaskNameTestField)
                    .add(jScrollPane3))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        reTrainPanelLayout.setVerticalGroup(
            reTrainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(reTrainPanelLayout.createSequentialGroup()
                .add(reTrainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(reTrainPanelLayout.createSequentialGroup()
                        .add(19, 19, 19)
                        .add(reTrainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(jLabel4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 32, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(inputRelatedGeneListFileField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 25, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(reTrainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(jLabel10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 32, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(TaskNameTestField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 25, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(reTrainPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel8)))
                .add(reTrainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(reTrainPanelLayout.createSequentialGroup()
                        .add(35, 35, 35)
                        .add(retrainButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 41, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(reTrainPanelLayout.createSequentialGroup()
                        .add(17, 17, 17)
                        .add(jScrollPane3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 96, Short.MAX_VALUE)))
                .addContainerGap())
        );

        TestPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(new javax.swing.border.LineBorder(new java.awt.Color(102, 0, 102), 1, true), "Predict PPI (Default: Receptor Proteins Related Only)", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 1, 12)));
        TestPanel.setName("Input");
        TestPanel.setOpaque(false);
        generatePPIlist.setFont(new java.awt.Font("Arial", 0, 11));
        generatePPIlist.setText("(1). Possible Protein Pairs to Test");
        generatePPIlist.setAutoscrolls(true);
        generatePPIlist.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        generatePPIlist.setEnabled(false);
        generatePPIlist.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                generatePPIlistActionPerformed(evt);
            }
        });

        GenerateFeature.setFont(new java.awt.Font("Arial", 0, 11));
        GenerateFeature.setText("(2). Create Related Feature Set");
        GenerateFeature.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        GenerateFeature.setEnabled(false);
        GenerateFeature.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                GenerateFeatureActionPerformed(evt);
            }
        });

        predictTesting.setFont(new java.awt.Font("Arial", 0, 11));
        predictTesting.setText("(3). Interact Partners Predictions");
        predictTesting.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        predictTesting.setEnabled(false);
        predictTesting.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                predictTestingActionPerformed(evt);
            }
        });

        analyzeTesting.setFont(new java.awt.Font("Arial", 0, 11));
        analyzeTesting.setText("(4). Analyze Prediction Result");
        analyzeTesting.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        analyzeTesting.setEnabled(false);
        analyzeTesting.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                analyzeTestingActionPerformed(evt);
            }
        });

        testPairListFileField.setEditable(false);
        testPairListFileField.setAutoscrolls(false);

        testFeatureFileField.setEditable(false);
        testFeatureFileField.setAutoscrolls(false);

        testResultFileField.setEditable(false);
        testResultFileField.setAutoscrolls(false);

        testAnalyzeResultFileField.setEditable(false);
        testAnalyzeResultFileField.setAutoscrolls(false);

        jScrollPane1.setEnabled(false);
        jTextAreaLog.setBackground(new java.awt.Color(255, 255, 239));
        jTextAreaLog.setColumns(20);
        jTextAreaLog.setEditable(false);
        jTextAreaLog.setRows(5);
        jTextAreaLog.setBorder(javax.swing.BorderFactory.createTitledBorder("Predict Running Log Information"));
        jScrollPane1.setViewportView(jTextAreaLog);

        jButtonBatchPredictPPI.setFont(new java.awt.Font("Arial", 1, 11));
        jButtonBatchPredictPPI.setText("Predict Interact Partners for Request Gene/s");
        jButtonBatchPredictPPI.setEnabled(false);
        jButtonBatchPredictPPI.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBatchPredictPPIActionPerformed(evt);
            }
        });

        jLabel9.setFont(new java.awt.Font("Tahoma", 1, 12));
        jLabel9.setForeground(new java.awt.Color(51, 51, 255));
        jLabel9.setText("We could also predict PPIs Step by Step ( 4 steps ) - Only Valid for Single Request Gene Input Choce ");

        jComboBoxPredictChoice.setFont(new java.awt.Font("Arial", 0, 10));
        jComboBoxPredictChoice.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "1. Among All Human Proteins/Genes", "2. Among Request Gene/Protein List", "3. Among Task Gene/Protein List" }));
        jComboBoxPredictChoice.setEnabled(false);
        jComboBoxPredictChoice.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxPredictChoiceActionPerformed(evt);
            }
        });

        jLabel11.setText("Partners");

        jLabel14.setText("Model");

        jComboBoxRFModelChoice.setFont(new java.awt.Font("Arial", 0, 10));
        jComboBoxRFModelChoice.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Default (Receptor Task) RF Model File", "Input (other Task) RF Model File" }));
        jComboBoxRFModelChoice.setEnabled(false);
        jComboBoxRFModelChoice.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxRFModelChoiceActionPerformed(evt);
            }
        });

        jTextFieldNewRFModelFile.setFont(new java.awt.Font("Arial", 0, 10));
        jTextFieldNewRFModelFile.setEnabled(false);

        jTextFieldPartnerGeneFile.setFont(new java.awt.Font("Arial", 0, 10));
        jTextFieldPartnerGeneFile.setEnabled(false);

        jLabel15.setFont(new java.awt.Font("Tahoma", 0, 10));
        jLabel15.setForeground(new java.awt.Color(0, 51, 255));
        jLabel15.setText(" Partner Genes List File (Please Use Absolute File Path)");

        jLabel16.setFont(new java.awt.Font("Tahoma", 0, 10));
        jLabel16.setForeground(new java.awt.Color(0, 51, 255));
        jLabel16.setText(" RF Trained Model File (Please Use Absolute File Path)");

        org.jdesktop.layout.GroupLayout TestPanelLayout = new org.jdesktop.layout.GroupLayout(TestPanel);
        TestPanel.setLayout(TestPanelLayout);
        TestPanelLayout.setHorizontalGroup(
            TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(TestPanelLayout.createSequentialGroup()
                .add(10, 10, 10)
                .add(jLabel9, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 636, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
            .add(TestPanelLayout.createSequentialGroup()
                .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, TestPanelLayout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(predictTesting, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 199, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(analyzeTesting, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 199, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(27, 27, 27)
                        .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(TestPanelLayout.createSequentialGroup()
                                .add(testAnalyzeResultFileField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 655, Short.MAX_VALUE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED))
                            .add(testResultFileField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 655, Short.MAX_VALUE)))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                        .add(org.jdesktop.layout.GroupLayout.LEADING, TestPanelLayout.createSequentialGroup()
                            .add(10, 10, 10)
                            .add(GenerateFeature, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 199, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(26, 26, 26)
                            .add(testFeatureFileField))
                        .add(org.jdesktop.layout.GroupLayout.LEADING, TestPanelLayout.createSequentialGroup()
                            .add(10, 10, 10)
                            .add(generatePPIlist, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 199, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(26, 26, 26)
                            .add(testPairListFileField))
                        .add(org.jdesktop.layout.GroupLayout.LEADING, TestPanelLayout.createSequentialGroup()
                            .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(TestPanelLayout.createSequentialGroup()
                                    .add(10, 10, 10)
                                    .add(jButtonBatchPredictPPI, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 283, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                .add(TestPanelLayout.createSequentialGroup()
                                    .addContainerGap()
                                    .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                        .add(jLabel11)
                                        .add(jLabel14))
                                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                    .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                        .add(jComboBoxRFModelChoice, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .add(jComboBoxPredictChoice, 0, 225, Short.MAX_VALUE))))
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                .add(jTextFieldNewRFModelFile)
                                .add(jLabel15, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 290, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(jLabel16, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 290, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(jScrollPane1)
                                .add(jTextFieldPartnerGeneFile, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 592, Short.MAX_VALUE)))))
                .add(70, 70, 70))
        );

        TestPanelLayout.linkSize(new java.awt.Component[] {GenerateFeature, analyzeTesting, generatePPIlist, predictTesting}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        TestPanelLayout.setVerticalGroup(
            TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(TestPanelLayout.createSequentialGroup()
                .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(TestPanelLayout.createSequentialGroup()
                        .add(42, 42, 42)
                        .add(jButtonBatchPredictPPI, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 37, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 110, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel15)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jComboBoxPredictChoice, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel11)
                    .add(jTextFieldPartnerGeneFile, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel16)
                .add(3, 3, 3)
                .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel14)
                    .add(jComboBoxRFModelChoice, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jTextFieldNewRFModelFile, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(25, 25, 25)
                .add(jLabel9)
                .add(18, 18, 18)
                .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(generatePPIlist, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(testPairListFileField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(14, 14, 14)
                .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(GenerateFeature)
                    .add(testFeatureFileField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 23, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(17, 17, 17)
                .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(predictTesting)
                    .add(testResultFileField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 23, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(17, 17, 17)
                .add(TestPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(analyzeTesting, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(testAnalyzeResultFileField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        TestPanelLayout.linkSize(new java.awt.Component[] {GenerateFeature, analyzeTesting, predictTesting}, org.jdesktop.layout.GroupLayout.VERTICAL);

        TestPanelLayout.linkSize(new java.awt.Component[] {testAnalyzeResultFileField, testFeatureFileField, testPairListFileField, testResultFileField}, org.jdesktop.layout.GroupLayout.VERTICAL);

        jLabel5.setFont(new java.awt.Font("Tahoma", 0, 10));
        jLabel5.setForeground(new java.awt.Color(51, 153, 255));
        jLabel5.setText("Copyright @ CMU  ||    Contact: Yanjun Qi ( qyj@cs.cmu.edu )  ||    Date:  2006.07.05");

        jLabel6.setIcon(new javax.swing.ImageIcon("G:\\qyj\\research\\12-HumanDrosophiliavalidate-software\\pic\\ppi.GIF"));
        jLabel6.setDisabledIcon(new javax.swing.ImageIcon("G:\\qyj\\research\\12-HumanDrosophiliavalidate-software\\pic\\ppi.GIF"));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, TestPanel, 0, 911, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(25, 25, 25)
                                .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 760, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED))
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                                .add(jLabel5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 399, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(42, 42, 42)))
                        .add(jLabel6, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 83, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, reTrainPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, InputPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel6, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 37, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 32, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jLabel5)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(InputPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(reTrainPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(TestPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(27, Short.MAX_VALUE))
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jComboBoxRFModelChoiceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxRFModelChoiceActionPerformed
        currentPredictRFmodelChoice = jComboBoxRFModelChoice.getSelectedIndex(); 
        if (currentPredictRFmodelChoice == 1) {
            jTextFieldNewRFModelFile.setEnabled(true); 
            jTextFieldNewRFModelFile.setEditable(true); 
        }         
        else if (currentPredictRFmodelChoice == 0) {
            jTextFieldNewRFModelFile.setEnabled(false); 
            jTextFieldNewRFModelFile.setEditable(false); 
        }         
    }//GEN-LAST:event_jComboBoxRFModelChoiceActionPerformed

    
    
    private void jComboBoxPredictChoiceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxPredictChoiceActionPerformed
        currentPredictChoice = jComboBoxPredictChoice.getSelectedIndex(); 
        if ((currentPredictChoice == 1)||(currentPredictChoice == 2)) {
            jTextFieldPartnerGeneFile.setEnabled(true); 
            jTextFieldPartnerGeneFile.setEditable(true); 
        } 
        else if (currentPredictChoice == 0) {
            jTextFieldPartnerGeneFile.setEnabled(false); 
            jTextFieldPartnerGeneFile.setEditable(false);             
        }
    }//GEN-LAST:event_jComboBoxPredictChoiceActionPerformed

    
    
    private void jComboBoxCheckChoiceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxCheckChoiceActionPerformed
        currentCheckChoice = jComboBoxCheckChoice.getSelectedIndex(); 
        ConfirmGeneIDArray.clear();  
        ConfirmGeneID = -1;        
        if (currentCheckChoice == 0)   {   
            RequestGeneInfoFile.setEnabled(false);   
            RequestGeneInfoFile.setText(""); 
            geneIDinput.setEnabled(true); 
            geneNameInput.setEnabled(true);             
        }
        else  {   
            geneIDinput.setText(""); 
            geneIDinput.setEnabled(false); 
            geneNameInput.setEnabled(false); 
            geneNameInput.setText(""); 
            RequestGeneInfoFile.setEnabled(true);                         
        }
    }//GEN-LAST:event_jComboBoxCheckChoiceActionPerformed

    
    
    private void jButtonBatchPredictPPIActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBatchPredictPPIActionPerformed

        //choose which list to search the interaction partners in
        String PartnerGeneList = ""; 
        if ((currentPredictChoice == 1)||(currentPredictChoice == 2)) {
            PartnerGeneList = jTextFieldPartnerGeneFile.getText();
        } 
                
        // begin the predicting process 
        int sizeloop = 0; 
        if ((currentCheckChoice == 0)&&(ConfirmGeneID != -1))     {
            sizeloop = 1;           
        } 
        else if ((currentCheckChoice == 1) && ( ConfirmGeneIDArray.size() > 0 )) {
            sizeloop = ConfirmGeneIDArray.size();           
        }

        int curGeneID = -1;         
        for (int i = 0; i < sizeloop; i++) 
        {
            if ((currentCheckChoice == 0)&&(ConfirmGeneID != -1))     {
                curGeneID = ConfirmGeneID ;           
            } 
            else if ((currentCheckChoice == 1) && ( ConfirmGeneIDArray.size() > 0 )) {
                curGeneID = Integer.parseInt(ConfirmGeneIDArray.get(i).toString()); 
            }
                
            jTextAreaLog.append("\n --------------------- Gene:" +  curGeneID + " ---------------- \n"); 

                String result = ""; 
                if (currentPredictChoice == 0) {
                    result = current.create_ppi_list(curGeneID, 0, "");    
                }
                else if ((currentPredictChoice == 1) || (currentPredictChoice == 2)) {
                    result = current.create_ppi_list(curGeneID, currentPredictChoice, PartnerGeneList);  
                }                        
                testPairListFileField.setText(result); 
                if ((result.compareTo("Required requestGeneFile Not exist !") == 0) || 
                   (result.compareTo("The create PPI choice parameter is wrong !!") == 0) ||
                   (result.compareTo("Required partnerGeneListFile (to search for parterners in) does not exist !") == 0))
                {   
                    jTextAreaLog.append("1. Create Protein Pair List: " + result + "  \n");
                    jTextAreaLog.append(" ------------------------  ----------------------------  \n");                                    
                    return;   
                }
                
                jTextAreaLog.append("\n 1. Create Protein Pair List: " + result + " \n"); 
                jTextAreaLog.append("     Log Information in file: " + result + ".log \n"); 
                result = current.generate_ppi_fea(curGeneID); 
                testFeatureFileField.setText(result);     
                jTextAreaLog.append("\n 2. Generate feature sets for List: " + result + " \n");   
                jTextAreaLog.append("     Log Information in file: " + result + ".log \n");             
                result = current.predictPPI(curGeneID, currentPredictChoice); 
                testResultFileField.setText(result);    
                jTextAreaLog.append("\n 3. Predict the interacting partners : " + result + " \n" ); 
                jTextAreaLog.append("     Log Information in file: " + result + ".log \n");             
                result = current.AddInfoResultPPI(curGeneID, currentPredictChoice); 
                testAnalyzeResultFileField.setText(result);             
                jTextAreaLog.append("\n 4. Add geneInfo and disease info on the predicted score file: " + result + " \n");
                jTextAreaLog.append("     Log Information in file: " + result + ".log \n");      
                jTextAreaLog.append(" -------------------------   -------------------------------  \n");                    
        }
    }//GEN-LAST:event_jButtonBatchPredictPPIActionPerformed

    
    private void retrainButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_retrainButtonActionPerformed
        String taskInputListFile = inputRelatedGeneListFileField.getText(); 
        String taskName = TaskNameTestField.getText(); 
        if (taskName.compareTo("") == 0)   {
            taskName = "NoTaskName"; 
            TaskNameTestField.setText(taskName); 
        }
        jTextAreaLog.append("\n -----------------------------------------------------------------  \n");    
        jTextAreaReTrainLog.append( "\nInput: Task Name: " + taskName + "\n") ;         
        jTextAreaReTrainLog.append( "\nInput: TaskInputGeneList: " + taskInputListFile + "\n") ; 
        String newTrainFile = current.generateNewTrainFeaFile(taskInputListFile); 
        if (newTrainFile.compareTo("Required task InputList File Not exist !") == 0) {
            jTextAreaReTrainLog.append("\n" + newTrainFile + "\n") ;   
            return; 
        }
        else {
            jTextAreaReTrainLog.append( "\n1. New Task related Train File: " + newTrainFile + "\n") ;         
            String newModelFile = current.reTrainRFmodel(); 
            jTextAreaReTrainLog.append( "\n2. Re-Train RF model on input Task related only: " + newModelFile + "\n") ;  
            String curtestPre = current.updateModelTaskName( taskName ); 
            jTextFieldNewRFModelFile.setText(  newModelFile );       
            jTextAreaReTrainLog.append( "\n3. Update trained RF model file by: "  + newModelFile + "\n"); 
            jTextAreaReTrainLog.append( "\n   Update testing result file Name Prefix: ./" + curtestPre + "\n\n") ; 
        }
    }//GEN-LAST:event_retrainButtonActionPerformed

    
    
    private void generatePPIlistActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_generatePPIlistActionPerformed
        if (ConfirmGeneID != -1)  
        {
            String PartnerGeneList = ""; 
            if ((currentPredictChoice == 1)||(currentPredictChoice == 2)) {
                PartnerGeneList = jTextFieldPartnerGeneFile.getText();
            }             
            
            String result = ""; 
            if (currentPredictChoice == 0) {
                result = current.create_ppi_list(ConfirmGeneID, 0, "");    
            }
            else if ((currentPredictChoice == 1) || (currentPredictChoice == 2)) {
                result = current.create_ppi_list(ConfirmGeneID, currentPredictChoice, PartnerGeneList);  
            }                        
            testPairListFileField.setText(result); 

            if ((result.compareTo("Required requestGeneFile Not exist !") == 0) || 
                   (result.compareTo("The create PPI choice parameter is wrong !!") == 0) ||
                   (result.compareTo("Required partnerGeneListFile (to search for parterners in) does not exist !") == 0))
            {   
                jTextAreaLog.append("1. Create Protein Pair List: " + result + "  \n");
                jTextAreaLog.append(" ------------------------  ----------------------------  \n");                                    
                return;   
            }
            
            jTextAreaLog.append("\n --------------------- Gene:" +  ConfirmGeneID + " ---------------- \n");                         
            jTextAreaLog.append("\n 1. Create Protein Pair List: " + result + " \n");             
            jTextAreaLog.append("     Log Information in file: " + result + ".log \n"); 
        }
    }//GEN-LAST:event_generatePPIlistActionPerformed

    
    
    private void analyzeTestingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_analyzeTestingActionPerformed
        String resultStatus = current.AddInfoResultPPI(ConfirmGeneID, currentPredictChoice); 
        testAnalyzeResultFileField.setText(resultStatus); 
        jTextAreaLog.append("\n 4. Add geneInfo and disease info on the predicted score file: " + resultStatus + " \n");        
        jTextAreaLog.append("     Log Information in file: " + resultStatus + ".log \n");         
    }//GEN-LAST:event_analyzeTestingActionPerformed

    
    
    private void predictTestingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_predictTestingActionPerformed
        jTextAreaLog.append("\n 3. Warning: Predict the interacting partners for a request gene among all human gene List: needs ~40 mins. \n");      
        String resultStatus = current.predictPPI(ConfirmGeneID, currentPredictChoice); 
        testResultFileField.setText(resultStatus); 
        jTextAreaLog.append("\n 3. Predict the interacting partners for a request gene: " + resultStatus + " \n" );         
        jTextAreaLog.append("     Log Information in file: " + resultStatus + ".log \n");                 
    }//GEN-LAST:event_predictTestingActionPerformed

    
    private void GenerateFeatureActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_GenerateFeatureActionPerformed
        jTextAreaLog.append("\n 2. Warning: Generate feature sets for one request gene with all human gene List: needs ~10 mins. \n");                           
        String resultStatus = current.generate_ppi_fea(ConfirmGeneID); 
        testFeatureFileField.setText(resultStatus); 
        jTextAreaLog.append("\n 2. Generate feature sets for List: " + resultStatus + " \n");           
        jTextAreaLog.append("     Log Information in file: " + resultStatus + ".log \n");                 
    }//GEN-LAST:event_GenerateFeatureActionPerformed

    
    private void checkInputGeneButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_checkInputGeneButtonActionPerformed
      int returnedGeneID = -1; 
      String curGeneFullInfo = "\nInput not Found or Matched in NCBI protein-gene List!\n";       
      int curGeneID = 0; 
      current.readinNCBIproteinList(); 
      ConfirmGeneIDArray.clear();  
      ConfirmGeneID = -1;        
      
      // In the single gene input case 
      if (currentCheckChoice == 0)   { 
        String returnedGeneName = ""; 
        String requestGeneFile = "Not valid human GeneID. So requestGeneFile not Generated!"; 
   
        String curGeneIDs = geneIDinput.getText();
        String curGeneNameS = geneNameInput.getText();
 
        if (curGeneIDs.compareTo("") != 0) 
        {   curGeneID = Integer.parseInt(curGeneIDs);     } 
        
        if ((curGeneIDs.compareTo("") != 0) && (curGeneNameS.compareTo("") != 0))
        {   returnedGeneID = current.checkNcbiProteinGene(curGeneID, curGeneNameS);  } 
        if ((curGeneIDs.compareTo("") == 0) && (curGeneNameS.compareTo("") != 0))
        {   returnedGeneID = current.checkNcbiProteinGene(curGeneNameS);  } 
        if ((curGeneIDs.compareTo("") != 0) && (curGeneNameS.compareTo("") == 0))
        {   returnedGeneID = current.checkNcbiProteinGene(curGeneID);  }         

        if ( returnedGeneID != -1 )     {
            requestGeneFile = current.generateRequestGeneFile(returnedGeneID); 
            curGeneFullInfo = current.getRequestGeneInfo(returnedGeneID);      
            returnedGeneName = current.getRequestGeneName(returnedGeneID); 
            ConfirmGeneID = returnedGeneID;             
            ConfirmGeneName = returnedGeneName; 
            jButtonBatchPredictPPI.setEnabled(true); 
            jComboBoxPredictChoice.setEnabled(true); 
            jComboBoxRFModelChoice.setEnabled(true); 
            generatePPIlist.setEnabled(true); 
            GenerateFeature.setEnabled(true); 
            predictTesting.setEnabled(true); 
            analyzeTesting.setEnabled(true); 
            jTextAreaLog.append("\n ---------------------  ---------------- ------------------------------- ");                                                     
            jTextAreaLog.append("\n The Full Prediction of one request gene need roughly 40 mins (Step2: ~10mins; Step3: ~27mins )");                         
            jTextAreaLog.append("\n --------------------- Gene:" +  ConfirmGeneID + " ---------------- \n");                         
        }
        else {
            ConfirmGeneID = -1;             
            ConfirmGeneName = ""; 
            jButtonBatchPredictPPI.setEnabled(false); 
            jComboBoxPredictChoice.setEnabled(false);        
            jComboBoxRFModelChoice.setEnabled(false);             
            generatePPIlist.setEnabled(false); 
            GenerateFeature.setEnabled(false); 
            predictTesting.setEnabled(false); 
            analyzeTesting.setEnabled(false);       
            testAnalyzeResultFileField.setText("");
            testFeatureFileField.setText("");
            testPairListFileField.setText("");
            testResultFileField.setText("");  
            jTextAreaLog.append("\n ---------------------  ---------------- ------------------------------- ");                                         
            jTextAreaLog.append("\n The input request gene info is not a valid human gene having proteins produce in NCBI records !");                         
            jTextAreaLog.append("\n ---------------------  ---------------- ------------------------------- \n");                           
        }
        geneNameInput.setText(returnedGeneName); 
        geneIDinput.setText( Integer.toString(returnedGeneID)); 
        RequestGeneInfoFile.setText(requestGeneFile);         
        ncbiGeneInfo.append(curGeneFullInfo);                 
      }
      
      // In the gene list input case       
      else {
        String inputRequestGeneListFile = RequestGeneInfoFile.getText(); 
        Vector InputGeneIDArray = new Vector();
        InputGeneIDArray = current.readRequestGeneListFile(inputRequestGeneListFile); 
        int index = 0; 
        ConfirmGeneIDArray.clear();
        for (int i = 0; i < InputGeneIDArray.size(); i++) 
        {
            returnedGeneID = -1; 
            curGeneID = Integer.parseInt(InputGeneIDArray.get(i).toString()); 
            returnedGeneID = current.checkNcbiProteinGene(curGeneID); 
            curGeneFullInfo = "\nInput not Found or Matched in NCBI protein-gene List!\n";  
            if ( returnedGeneID != -1 )     {
                curGeneFullInfo = current.getRequestGeneInfo(returnedGeneID);
                ncbiGeneInfo.append(curGeneFullInfo);                 
                current.generateRequestGeneFile(returnedGeneID); 
                ConfirmGeneIDArray.add(index,returnedGeneID); 
                index ++; 
            }
        }
        if ( index != 0 ) 
        {
            jButtonBatchPredictPPI.setEnabled(true);     
            jComboBoxPredictChoice.setEnabled(true);   
            jComboBoxRFModelChoice.setEnabled(true);             
            jTextAreaLog.append("\n ---------------------  ---------------- ------------------------------- ");                                         
            jTextAreaLog.append("\n The Full Prediction (among all human proteins) of each request gene needs roughly 40 mins (Step2: ~10mins; Step3: ~27mins ) ");                         
            jTextAreaLog.append("\n --------------------- " + index + " valid request genes : ---------------- \n");   
        }
        else {
            jButtonBatchPredictPPI.setEnabled(false);      
            jComboBoxPredictChoice.setEnabled(false);
            jComboBoxRFModelChoice.setEnabled(false);             
            jTextAreaLog.append("\n ---------------------  ---------------- ------------------------------- ");                                         
            jTextAreaLog.append("\n The input request gene list file contains no valid genes !");                         
            jTextAreaLog.append("\n ---------------------  ---------------- ------------------------------- \n");               
            RequestGeneInfoFile.setText("");
        }
      }
    }//GEN-LAST:event_checkInputGeneButtonActionPerformed
    
    
    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String arg[]) 
    {
        java.awt.EventQueue.invokeLater(new Runnable() {            
            public void run() {
                new humanPPI().setVisible(true);
            }
        });
    }

 
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton GenerateFeature;
    private javax.swing.JPanel InputPanel;
    private javax.swing.JTextField RequestGeneInfoFile;
    private javax.swing.JTextField TaskNameTestField;
    private javax.swing.JPanel TestPanel;
    private javax.swing.JButton analyzeTesting;
    private javax.swing.JButton checkInputGeneButton;
    private javax.swing.JTextField geneIDinput;
    private javax.swing.JTextField geneNameInput;
    private javax.swing.JButton generatePPIlist;
    private javax.swing.JTextField inputRelatedGeneListFileField;
    private javax.swing.JButton jButtonBatchPredictPPI;
    private javax.swing.JComboBox jComboBoxCheckChoice;
    private javax.swing.JComboBox jComboBoxPredictChoice;
    private javax.swing.JComboBox jComboBoxRFModelChoice;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTextArea jTextAreaLog;
    private javax.swing.JTextArea jTextAreaReTrainLog;
    private javax.swing.JTextField jTextFieldNewRFModelFile;
    private javax.swing.JTextField jTextFieldPartnerGeneFile;
    private javax.swing.JTextArea ncbiGeneInfo;
    private javax.swing.JButton predictTesting;
    private javax.swing.JPanel reTrainPanel;
    private javax.swing.JButton retrainButton;
    private javax.swing.JTextField testAnalyzeResultFileField;
    private javax.swing.JTextField testFeatureFileField;
    private javax.swing.JTextField testPairListFileField;
    private javax.swing.JTextField testResultFileField;
    // End of variables declaration//GEN-END:variables
    
}
