/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

/*
 *
 * Header file for symbol_table.c.
 */

#ifndef	_SYMTAB
#define	_SYMTAB 1

#include "vcode.h"

typedef struct hash_entry {
    char                 fn_name[FN_NAME_MAX];  /* name of function */
    int                  prog_num;      /* line in prog where defined */
    struct hash_entry   *next;          /* pointer for hash collisions */
} hash_entry_data_t, *hash_entry_t;

extern void		hash_table_init();
extern void		hash_table_enter();
extern hash_entry_t	hash_table_lookup();

#endif /* _SYMTAB */
