/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

#include "vstack.h"

/* a stack_entry is an index into the stack */
typedef int stack_entry_t;		

extern vb_t **stack;			/* the stack */
extern int stack_index;			/* index of TOS */

#define TOS 	(stack_index)		/* top of stack */

#define se_vb(_se) (stack[_se])

#define stack_size (stack_index + 1)	/* number of elements in stack */

extern void stack_init();
extern int  do_cond();
extern void do_const();
extern void do_copy();
extern void do_pop();
extern void do_write();
extern void do_read();
extern void do_fopen();
extern void do_fclose();
extern void do_fread();
extern void do_fwrite();
extern void do_spawn();
extern void get_args();
extern void show_stack();
extern void show_stack_values();
extern void stack_pop();
extern void stack_push();
extern void do_fread_char();
