/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/
/****************************************************************

                         /-------------\
                        /               \
                       /                 \
                      /                   \
                      |   XXXX     XXXX   |
                      |   XXXX     XXXX   |
                      |   XXX       XXX   |
                      \         X         /
                       --\     XXX     /--
                        | |    XXX    | |
                        | |           | |
                        | I I I I I I I |
                        |  I I I I I I  |
                         \             /
                          --         --
                            \-------/
                    XXX                    XXX
                   XXXXX                  XXXXX
                   XXXXXXXXX         XXXXXXXXXX
                          XXXXX   XXXXX
                             XXXXXXX
                          XXXXX   XXXXX
                   XXXXXXXXX         XXXXXXXXXX
                   XXXXX                  XXXXX
                    XXX                    XXX

                          **************
                          *  BEWARE!!  *
                          **************

           ******************************************
           * THIS FILE IS GENERATED AUTOMAGICALLY!! *
           *          DO NOT EDIT IT!!!             *
           ******************************************

*****************************************************************/

#ifdef __STDC__
#	define HAS_VOIDP
#endif  /* __STDC__ */

#ifdef CM2
#       include <cm/paris.h>
        typedef CM_field_id_t vec_p;
#else
#ifdef CM5
	typedef int vec_p;
#else
#ifdef HAS_VOIDP
        typedef void *vec_p;
#else
        typedef char *vec_p;
#endif /* HAS_VOIDP */
#endif /* CM5 */
#endif /* CM2 */

#ifdef CM2
        typedef unsigned cvl_bool;
#else
#ifdef CM5
	typedef unsigned cvl_bool;
#else
        typedef int cvl_bool;
#endif /* CM5 */
#endif /* CM2 */

#ifdef cray
	typedef unsigned long cvl_timer_t;
#else
#ifdef CM2
	typedef double cvl_timer_t;
#else
#ifdef CM5
	typedef double cvl_timer_t;
#else
	typedef struct CVL_TIMER_T {
	    long sec, usec;
	} cvl_timer_t;
#endif /* CM5 */
#endif /* CM2 */
#endif /* cray */

#define CVL_SCRATCH_NULL ((vec_p) NULL)

/* below this is automatically generated by make include */
#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif

void max_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int max_wuz_scratch P_((int len));
int max_wuz_inplace P_((void));
void max_wud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int max_wud_scratch P_((int len));
int max_wud_inplace P_((void));
void min_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int min_wuz_scratch P_((int len));
int min_wuz_inplace P_((void));
void min_wud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int min_wud_scratch P_((int len));
int min_wud_inplace P_((void));
void add_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int add_wuz_scratch P_((int len));
int add_wuz_inplace P_((void));
void add_wud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int add_wud_scratch P_((int len));
int add_wud_inplace P_((void));
void sub_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int sub_wuz_scratch P_((int len));
int sub_wuz_inplace P_((void));
void sub_wud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int sub_wud_scratch P_((int len));
int sub_wud_inplace P_((void));
void mul_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int mul_wuz_scratch P_((int len));
int mul_wuz_inplace P_((void));
void mul_wud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int mul_wud_scratch P_((int len));
int mul_wud_inplace P_((void));
void div_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int div_wuz_scratch P_((int len));
int div_wuz_inplace P_((void));
void div_wud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int div_wud_scratch P_((int len));
int div_wud_inplace P_((void));
void grt_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int grt_wuz_scratch P_((int len));
int grt_wuz_inplace P_((void));
void grt_wud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int grt_wud_scratch P_((int len));
int grt_wud_inplace P_((void));
void les_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int les_wuz_scratch P_((int len));
int les_wuz_inplace P_((void));
void les_wud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int les_wud_scratch P_((int len));
int les_wud_inplace P_((void));
void geq_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int geq_wuz_scratch P_((int len));
int geq_wuz_inplace P_((void));
void geq_wud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int geq_wud_scratch P_((int len));
int geq_wud_inplace P_((void));
void leq_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int leq_wuz_scratch P_((int len));
int leq_wuz_inplace P_((void));
void leq_wud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int leq_wud_scratch P_((int len));
int leq_wud_inplace P_((void));
void lsh_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int lsh_wuz_scratch P_((int len));
int lsh_wuz_inplace P_((void));
void rsh_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int rsh_wuz_scratch P_((int len));
int rsh_wuz_inplace P_((void));
void mod_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int mod_wuz_scratch P_((int len));
int mod_wuz_inplace P_((void));
void rnd_wuz P_((vec_p d, vec_p s, int len, vec_p scratch));
int rnd_wuz_scratch P_((int len));
int rnd_wuz_inplace P_((void));
void eql_wub P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int eql_wub_scratch P_((int len));
int eql_wub_inplace P_((void));
void eql_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int eql_wuz_scratch P_((int len));
int eql_wuz_inplace P_((void));
void eql_wud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int eql_wud_scratch P_((int len));
int eql_wud_inplace P_((void));
void neq_wub P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int neq_wub_scratch P_((int len));
int neq_wub_inplace P_((void));
void neq_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int neq_wuz_scratch P_((int len));
int neq_wuz_inplace P_((void));
void neq_wud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int neq_wud_scratch P_((int len));
int neq_wud_inplace P_((void));
void sel_wuz P_((vec_p d, vec_p s1, vec_p s2, vec_p s3, int len, vec_p scratch));
int sel_wuz_scratch P_((int len));
int sel_wuz_inplace P_((void));
void sel_wub P_((vec_p d, vec_p s1, vec_p s2, vec_p s3, int len, vec_p scratch));
int sel_wub_scratch P_((int len));
int sel_wub_inplace P_((void));
void sel_wud P_((vec_p d, vec_p s1, vec_p s2, vec_p s3, int len, vec_p scratch));
int sel_wud_scratch P_((int len));
int sel_wud_inplace P_((void));
void not_wub P_((vec_p d, vec_p s, int len, vec_p scratch));
int not_wub_scratch P_((int len));
int not_wub_inplace P_((void));
void xor_wub P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int xor_wub_scratch P_((int len));
int xor_wub_inplace P_((void));
void or_wub P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int or_wub_scratch P_((int len));
int or_wub_inplace P_((void));
void and_wub P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int and_wub_scratch P_((int len));
int and_wub_inplace P_((void));
void or_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int or_wuz_scratch P_((int len));
int or_wuz_inplace P_((void));
void and_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int and_wuz_scratch P_((int len));
int and_wuz_inplace P_((void));
void not_wuz P_((vec_p d, vec_p s, int len, vec_p scratch));
int not_wuz_scratch P_((int len));
int not_wuz_inplace P_((void));
void xor_wuz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int xor_wuz_scratch P_((int len));
int xor_wuz_inplace P_((void));
void int_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int int_wud_scratch P_((int len));
int int_wud_inplace P_((void));
void int_wub P_((vec_p d, vec_p s, int len, vec_p scratch));
int int_wub_scratch P_((int len));
int int_wub_inplace P_((void));
void dbl_wuz P_((vec_p d, vec_p s, int len, vec_p scratch));
int dbl_wuz_scratch P_((int len));
int dbl_wuz_inplace P_((void));
void boo_wuz P_((vec_p d, vec_p s, int len, vec_p scratch));
int boo_wuz_scratch P_((int len));
int boo_wuz_inplace P_((void));
void flr_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int flr_wud_scratch P_((int len));
int flr_wud_inplace P_((void));
void cei_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int cei_wud_scratch P_((int len));
int cei_wud_inplace P_((void));
void trn_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int trn_wud_scratch P_((int len));
int trn_wud_inplace P_((void));
void rou_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int rou_wud_scratch P_((int len));
int rou_wud_inplace P_((void));
void exp_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int exp_wud_scratch P_((int len));
int exp_wud_inplace P_((void));
void log_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int log_wud_scratch P_((int len));
int log_wud_inplace P_((void));
void sqt_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int sqt_wud_scratch P_((int len));
int sqt_wud_inplace P_((void));
void sin_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int sin_wud_scratch P_((int len));
int sin_wud_inplace P_((void));
void cos_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int cos_wud_scratch P_((int len));
int cos_wud_inplace P_((void));
void tan_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int tan_wud_scratch P_((int len));
int tan_wud_inplace P_((void));
void asn_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int asn_wud_scratch P_((int len));
int asn_wud_inplace P_((void));
void acs_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int acs_wud_scratch P_((int len));
int acs_wud_inplace P_((void));
void atn_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int atn_wud_scratch P_((int len));
int atn_wud_inplace P_((void));
void snh_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int snh_wud_scratch P_((int len));
int snh_wud_inplace P_((void));
void csh_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int csh_wud_scratch P_((int len));
int csh_wud_inplace P_((void));
void tnh_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int tnh_wud_scratch P_((int len));
int tnh_wud_inplace P_((void));
void cpy_wuz P_((vec_p d, vec_p s, int len, vec_p scratch));
int cpy_wuz_scratch P_((int len));
int cpy_wuz_inplace P_((void));
void cpy_wub P_((vec_p d, vec_p s, int len, vec_p scratch));
int cpy_wub_scratch P_((int len));
int cpy_wub_inplace P_((void));
void cpy_wud P_((vec_p d, vec_p s, int len, vec_p scratch));
int cpy_wud_scratch P_((int len));
int cpy_wud_inplace P_((void));
void cpy_wus P_((vec_p d, vec_p s, int n, int m, vec_p scratch));
int cpy_wus_scratch P_((int n, int m));
int cpy_wus_inplace P_((void));
int add_suz P_((vec_p d, vec_p s, int in, int len, vec_p scratch));
int add_suz_scratch P_((int len));
int add_suz_inplace P_((void));
double add_sud P_((vec_p d, vec_p s, double in, int len, vec_p scratch));
int add_sud_scratch P_((int len));
int add_sud_inplace P_((void));
int min_suz P_((vec_p d, vec_p s, int in, int len, vec_p scratch));
int min_suz_scratch P_((int len));
int min_suz_inplace P_((void));
double min_sud P_((vec_p d, vec_p s, double in, int len, vec_p scratch));
int min_sud_scratch P_((int len));
int min_sud_inplace P_((void));
int max_suz P_((vec_p d, vec_p s, int in, int len, vec_p scratch));
int max_suz_scratch P_((int len));
int max_suz_inplace P_((void));
double max_sud P_((vec_p d, vec_p s, double in, int len, vec_p scratch));
int max_sud_scratch P_((int len));
int max_sud_inplace P_((void));
cvl_bool and_sub P_((vec_p d, vec_p s, cvl_bool in, int len, vec_p scratch));
int and_sub_scratch P_((int len));
int and_sub_inplace P_((void));
int and_suz P_((vec_p d, vec_p s, int in, int len, vec_p scratch));
int and_suz_scratch P_((int len));
int and_suz_inplace P_((void));
cvl_bool or_sub P_((vec_p d, vec_p s, cvl_bool in, int len, vec_p scratch));
int or_sub_scratch P_((int len));
int or_sub_inplace P_((void));
int or_suz P_((vec_p d, vec_p s, int in, int len, vec_p scratch));
int or_suz_scratch P_((int len));
int or_suz_inplace P_((void));
void add_nuz P_((vec_p d, vec_p s, int len, vec_p scratch));
int add_nuz_scratch P_((int len));
int add_nuz_inplace P_((void));
void add_nud P_((vec_p d, vec_p s, int len, vec_p scratch));
int add_nud_scratch P_((int len));
int add_nud_inplace P_((void));
void min_nuz P_((vec_p d, vec_p s, int len, vec_p scratch));
int min_nuz_scratch P_((int len));
int min_nuz_inplace P_((void));
void min_nud P_((vec_p d, vec_p s, int len, vec_p scratch));
int min_nud_scratch P_((int len));
int min_nud_inplace P_((void));
void max_nuz P_((vec_p d, vec_p s, int len, vec_p scratch));
int max_nuz_scratch P_((int len));
int max_nuz_inplace P_((void));
void max_nud P_((vec_p d, vec_p s, int len, vec_p scratch));
int max_nud_scratch P_((int len));
int max_nud_inplace P_((void));
void and_nub P_((vec_p d, vec_p s, int len, vec_p scratch));
int and_nub_scratch P_((int len));
int and_nub_inplace P_((void));
void and_nuz P_((vec_p d, vec_p s, int len, vec_p scratch));
int and_nuz_scratch P_((int len));
int and_nuz_inplace P_((void));
void or_nub P_((vec_p d, vec_p s, int len, vec_p scratch));
int or_nub_scratch P_((int len));
int or_nub_inplace P_((void));
void or_nuz P_((vec_p d, vec_p s, int len, vec_p scratch));
int or_nuz_scratch P_((int len));
int or_nuz_inplace P_((void));
void add_nez P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int add_nez_scratch P_((int vec_len, int seg_len));
int add_nez_inplace P_((void));
void add_ned P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int add_ned_scratch P_((int vec_len, int seg_len));
int add_ned_inplace P_((void));
void min_nez P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int min_nez_scratch P_((int vec_len, int seg_len));
int min_nez_inplace P_((void));
void min_ned P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int min_ned_scratch P_((int vec_len, int seg_len));
int min_ned_inplace P_((void));
void max_nez P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int max_nez_scratch P_((int vec_len, int seg_len));
int max_nez_inplace P_((void));
void max_ned P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int max_ned_scratch P_((int vec_len, int seg_len));
int max_ned_inplace P_((void));
void and_neb P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int and_neb_scratch P_((int vec_len, int seg_len));
int and_neb_inplace P_((void));
void and_nez P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int and_nez_scratch P_((int vec_len, int seg_len));
int and_nez_inplace P_((void));
void or_neb P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int or_neb_scratch P_((int vec_len, int seg_len));
int or_neb_inplace P_((void));
void or_nez P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int or_nez_scratch P_((int vec_len, int seg_len));
int or_nez_inplace P_((void));
void add_sez P_((vec_p d1, vec_p d2, vec_p s, vec_p in, vec_p sd, int n, int m, vec_p scratch));
int add_sez_scratch P_((int vec_len, int seg_len));
int add_sez_inplace P_((void));
void add_sed P_((vec_p d1, vec_p d2, vec_p s, vec_p in, vec_p sd, int n, int m, vec_p scratch));
int add_sed_scratch P_((int vec_len, int seg_len));
int add_sed_inplace P_((void));
void min_sez P_((vec_p d1, vec_p d2, vec_p s, vec_p in, vec_p sd, int n, int m, vec_p scratch));
int min_sez_scratch P_((int vec_len, int seg_len));
int min_sez_inplace P_((void));
void min_sed P_((vec_p d1, vec_p d2, vec_p s, vec_p in, vec_p sd, int n, int m, vec_p scratch));
int min_sed_scratch P_((int vec_len, int seg_len));
int min_sed_inplace P_((void));
void max_sez P_((vec_p d1, vec_p d2, vec_p s, vec_p in, vec_p sd, int n, int m, vec_p scratch));
int max_sez_scratch P_((int vec_len, int seg_len));
int max_sez_inplace P_((void));
void max_sed P_((vec_p d1, vec_p d2, vec_p s, vec_p in, vec_p sd, int n, int m, vec_p scratch));
int max_sed_scratch P_((int vec_len, int seg_len));
int max_sed_inplace P_((void));
void and_seb P_((vec_p d1, vec_p d2, vec_p s, vec_p in, vec_p sd, int n, int m, vec_p scratch));
int and_seb_scratch P_((int vec_len, int seg_len));
int and_seb_inplace P_((void));
void and_sez P_((vec_p d1, vec_p d2, vec_p s, vec_p in, vec_p sd, int n, int m, vec_p scratch));
int and_sez_scratch P_((int vec_len, int seg_len));
int and_sez_inplace P_((void));
void or_seb P_((vec_p d1, vec_p d2, vec_p s, vec_p in, vec_p sd, int n, int m, vec_p scratch));
int or_seb_scratch P_((int vec_len, int seg_len));
int or_seb_inplace P_((void));
void or_sez P_((vec_p d1, vec_p d2, vec_p s, vec_p in, vec_p sd, int n, int m, vec_p scratch));
int or_sez_scratch P_((int vec_len, int seg_len));
int or_sez_inplace P_((void));
int add_ruz P_((vec_p s, int len, vec_p scratch));
int add_ruz_scratch P_((int len));
int add_ruz_inplace P_((void));
double add_rud P_((vec_p s, int len, vec_p scratch));
int add_rud_scratch P_((int len));
int add_rud_inplace P_((void));
int min_ruz P_((vec_p s, int len, vec_p scratch));
int min_ruz_scratch P_((int len));
int min_ruz_inplace P_((void));
double min_rud P_((vec_p s, int len, vec_p scratch));
int min_rud_scratch P_((int len));
int min_rud_inplace P_((void));
int max_ruz P_((vec_p s, int len, vec_p scratch));
int max_ruz_scratch P_((int len));
int max_ruz_inplace P_((void));
double max_rud P_((vec_p s, int len, vec_p scratch));
int max_rud_scratch P_((int len));
int max_rud_inplace P_((void));
cvl_bool and_rub P_((vec_p s, int len, vec_p scratch));
int and_rub_scratch P_((int len));
int and_rub_inplace P_((void));
int and_ruz P_((vec_p s, int len, vec_p scratch));
int and_ruz_scratch P_((int len));
int and_ruz_inplace P_((void));
cvl_bool or_rub P_((vec_p s, int len, vec_p scratch));
int or_rub_scratch P_((int len));
int or_rub_inplace P_((void));
int or_ruz P_((vec_p s, int len, vec_p scratch));
int or_ruz_scratch P_((int len));
int or_ruz_inplace P_((void));
void add_rez P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int add_rez_scratch P_((int vec_len, int seg_len));
int add_rez_inplace P_((void));
void add_red P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int add_red_scratch P_((int vec_len, int seg_len));
int add_red_inplace P_((void));
void min_rez P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int min_rez_scratch P_((int vec_len, int seg_len));
int min_rez_inplace P_((void));
void min_red P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int min_red_scratch P_((int vec_len, int seg_len));
int min_red_inplace P_((void));
void max_rez P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int max_rez_scratch P_((int vec_len, int seg_len));
int max_rez_inplace P_((void));
void max_red P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int max_red_scratch P_((int vec_len, int seg_len));
int max_red_inplace P_((void));
void and_reb P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int and_reb_scratch P_((int vec_len, int seg_len));
int and_reb_inplace P_((void));
void and_rez P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int and_rez_scratch P_((int vec_len, int seg_len));
int and_rez_inplace P_((void));
void or_reb P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int or_reb_scratch P_((int vec_len, int seg_len));
int or_reb_inplace P_((void));
void or_rez P_((vec_p d, vec_p s, vec_p sd, int n, int m, vec_p scratch));
int or_rez_scratch P_((int vec_len, int seg_len));
int or_rez_inplace P_((void));
int ext_vuz P_((vec_p V, int i, int len, vec_p scratch));
int ext_vuz_scratch P_((int len));
int ext_vuz_inplace P_((void));
cvl_bool ext_vub P_((vec_p V, int i, int len, vec_p scratch));
int ext_vub_scratch P_((int len));
int ext_vub_inplace P_((void));
double ext_vud P_((vec_p V, int i, int len, vec_p scratch));
int ext_vud_scratch P_((int len));
int ext_vud_inplace P_((void));
void ext_vez P_((vec_p d, vec_p s, vec_p i, vec_p sd, int n, int m, vec_p scratch));
int ext_vez_scratch P_((int vec_len, int seg_len));
int ext_vez_inplace P_((void));
void ext_veb P_((vec_p d, vec_p s, vec_p i, vec_p sd, int n, int m, vec_p scratch));
int ext_veb_scratch P_((int vec_len, int seg_len));
int ext_veb_inplace P_((void));
void ext_ved P_((vec_p d, vec_p s, vec_p i, vec_p sd, int n, int m, vec_p scratch));
int ext_ved_scratch P_((int vec_len, int seg_len));
int ext_ved_inplace P_((void));
void rep_vuz P_((vec_p V, int i, int val, int len, vec_p scratch));
int rep_vuz_scratch P_((int len));
int rep_vuz_inplace P_((void));
void rep_vub P_((vec_p V, int i, cvl_bool val, int len, vec_p scratch));
int rep_vub_scratch P_((int len));
int rep_vub_inplace P_((void));
void rep_vud P_((vec_p V, int i, double val, int len, vec_p scratch));
int rep_vud_scratch P_((int len));
int rep_vud_inplace P_((void));
void rep_vez P_((vec_p d, vec_p s, vec_p v, vec_p sd, int n, int m, vec_p scratch));
int rep_vez_scratch P_((int vec_len, int seg_len));
int rep_vez_inplace P_((void));
void rep_veb P_((vec_p d, vec_p s, vec_p v, vec_p sd, int n, int m, vec_p scratch));
int rep_veb_scratch P_((int vec_len, int seg_len));
int rep_veb_inplace P_((void));
void rep_ved P_((vec_p d, vec_p s, vec_p v, vec_p sd, int n, int m, vec_p scratch));
int rep_ved_scratch P_((int vec_len, int seg_len));
int rep_ved_inplace P_((void));
void dis_vuz P_((vec_p d, int v, int len, vec_p scratch));
int dis_vuz_scratch P_((int len));
int dis_vuz_inplace P_((void));
void dis_vub P_((vec_p d, cvl_bool v, int len, vec_p scratch));
int dis_vub_scratch P_((int len));
int dis_vub_inplace P_((void));
void dis_vud P_((vec_p d, double v, int len, vec_p scratch));
int dis_vud_scratch P_((int len));
int dis_vud_inplace P_((void));
void dis_vez P_((vec_p d, vec_p v, vec_p sd, int n, int m, vec_p scratch));
int dis_vez_scratch P_((int vec_len, int seg_len));
int dis_vez_inplace P_((void));
void dis_veb P_((vec_p d, vec_p v, vec_p sd, int n, int m, vec_p scratch));
int dis_veb_scratch P_((int vec_len, int seg_len));
int dis_veb_inplace P_((void));
void dis_ved P_((vec_p d, vec_p v, vec_p sd, int n, int m, vec_p scratch));
int dis_ved_scratch P_((int vec_len, int seg_len));
int dis_ved_inplace P_((void));
void smp_puz P_((vec_p d, vec_p s, vec_p i, int len, vec_p scratch));
int smp_puz_scratch P_((int len));
int smp_puz_inplace P_((void));
void smp_pub P_((vec_p d, vec_p s, vec_p i, int len, vec_p scratch));
int smp_pub_scratch P_((int len));
int smp_pub_inplace P_((void));
void smp_pud P_((vec_p d, vec_p s, vec_p i, int len, vec_p scratch));
int smp_pud_scratch P_((int len));
int smp_pud_inplace P_((void));
void smp_pez P_((vec_p d, vec_p s, vec_p i, vec_p sd, int n, int m, vec_p scratch));
int smp_pez_scratch P_((int vec_len, int seg_len));
int smp_pez_inplace P_((void));
void smp_peb P_((vec_p d, vec_p s, vec_p i, vec_p sd, int n, int m, vec_p scratch));
int smp_peb_scratch P_((int vec_len, int seg_len));
int smp_peb_inplace P_((void));
void smp_ped P_((vec_p d, vec_p s, vec_p i, vec_p sd, int n, int m, vec_p scratch));
int smp_ped_scratch P_((int vec_len, int seg_len));
int smp_ped_inplace P_((void));
void bck_puz P_((vec_p d, vec_p s, vec_p i, int s_len, int d_len, vec_p scratch));
int bck_puz_scratch P_((int s_len, int d_len));
int bck_puz_inplace P_((void));
void bck_pub P_((vec_p d, vec_p s, vec_p i, int s_len, int d_len, vec_p scratch));
int bck_pub_scratch P_((int s_len, int d_len));
int bck_pub_inplace P_((void));
void bck_pud P_((vec_p d, vec_p s, vec_p i, int s_len, int d_len, vec_p scratch));
int bck_pud_scratch P_((int s_len, int d_len));
int bck_pud_inplace P_((void));
void bck_pez P_((vec_p d, vec_p s, vec_p i, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int bck_pez_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int bck_pez_inplace P_((void));
void bck_peb P_((vec_p d, vec_p s, vec_p i, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int bck_peb_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int bck_peb_inplace P_((void));
void bck_ped P_((vec_p d, vec_p s, vec_p i, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int bck_ped_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int bck_ped_inplace P_((void));
int spl_luz P_((vec_p d, vec_p s, vec_p f, int len, vec_p scratch));
int spl_luz_scratch P_((int len));
int spl_luz_inplace P_((void));
int spl_lub P_((vec_p d, vec_p s, vec_p f, int len, vec_p scratch));
int spl_lub_scratch P_((int len));
int spl_lub_inplace P_((void));
int spl_lud P_((vec_p d, vec_p s, vec_p f, int len, vec_p scratch));
int spl_lud_scratch P_((int len));
int spl_lud_inplace P_((void));
void spl_lez P_((vec_p d, vec_p d2, vec_p s, vec_p f, vec_p sd, int n, int m, vec_p scratch));
int spl_lez_scratch P_((int vec_len, int seg_len));
int spl_lez_inplace P_((void));
void spl_leb P_((vec_p d, vec_p d2, vec_p s, vec_p f, vec_p sd, int n, int m, vec_p scratch));
int spl_leb_scratch P_((int vec_len, int seg_len));
int spl_leb_inplace P_((void));
void spl_led P_((vec_p d, vec_p d2, vec_p s, vec_p f, vec_p sd, int n, int m, vec_p scratch));
int spl_led_scratch P_((int vec_len, int seg_len));
int spl_led_inplace P_((void));
void ind_luz P_((vec_p d, int len, vec_p scratch));
int ind_luz_scratch P_((int len));
int ind_luz_inplace P_((void));
void ind_lez P_((vec_p d, vec_p sd, int n, int m, vec_p scratch));
int ind_lez_scratch P_((int vec_len, int seg_len));
int ind_lez_inplace P_((void));
int pck_luz P_((vec_p d, vec_p s, vec_p f, int len, vec_p scratch));
int pck_luz_scratch P_((int len));
int pck_luz_inplace P_((void));
int pck_lub P_((vec_p d, vec_p s, vec_p f, int len, vec_p scratch));
int pck_lub_scratch P_((int len));
int pck_lub_inplace P_((void));
int pck_lud P_((vec_p d, vec_p s, vec_p f, int len, vec_p scratch));
int pck_lud_scratch P_((int len));
int pck_lud_inplace P_((void));
void pk1_lev P_((vec_p ds, vec_p f, vec_p sd, int n, int m, vec_p scratch));
int pk1_lev_scratch P_((int vec_len, int seg_len));
int pk1_lev_inplace P_((void));
void pk2_lez P_((vec_p d, vec_p s, vec_p f, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int pk2_lez_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int pk2_lez_inplace P_((void));
void pk2_leb P_((vec_p d, vec_p s, vec_p f, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int pk2_leb_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int pk2_leb_inplace P_((void));
void pk2_led P_((vec_p d, vec_p s, vec_p f, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int pk2_led_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int pk2_led_inplace P_((void));
void sfl_luz P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int sfl_luz_scratch P_((int len));
int sfl_luz_inplace P_((void));
void sfl_lub P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int sfl_lub_scratch P_((int len));
int sfl_lub_inplace P_((void));
void sfl_lud P_((vec_p d, vec_p s1, vec_p s2, int len, vec_p scratch));
int sfl_lud_scratch P_((int len));
int sfl_lud_inplace P_((void));
void fpm_puz P_((vec_p d, vec_p s, vec_p i, vec_p f, int len_src, int len_dest, vec_p scratch));
int fpm_puz_scratch P_((int s_len, int d_len));
int fpm_puz_inplace P_((void));
void fpm_pub P_((vec_p d, vec_p s, vec_p i, vec_p f, int len_src, int len_dest, vec_p scratch));
int fpm_pub_scratch P_((int s_len, int d_len));
int fpm_pub_inplace P_((void));
void fpm_pud P_((vec_p d, vec_p s, vec_p i, vec_p f, int len_src, int len_dest, vec_p scratch));
int fpm_pud_scratch P_((int s_len, int d_len));
int fpm_pud_inplace P_((void));
void fpm_pez P_((vec_p d, vec_p s, vec_p i, vec_p f, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int fpm_pez_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int fpm_pez_inplace P_((void));
void fpm_peb P_((vec_p d, vec_p s, vec_p i, vec_p f, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int fpm_peb_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int fpm_peb_inplace P_((void));
void fpm_ped P_((vec_p d, vec_p s, vec_p i, vec_p f, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int fpm_ped_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int fpm_ped_inplace P_((void));
void bfp_puz P_((vec_p d, vec_p s, vec_p i, vec_p f, int len_src, int len_dest, vec_p scratch));
int bfp_puz_scratch P_((int s_len, int d_len));
int bfp_puz_inplace P_((void));
void bfp_pub P_((vec_p d, vec_p s, vec_p i, vec_p f, int len_src, int len_dest, vec_p scratch));
int bfp_pub_scratch P_((int s_len, int d_len));
int bfp_pub_inplace P_((void));
void bfp_pud P_((vec_p d, vec_p s, vec_p i, vec_p f, int len_src, int len_dest, vec_p scratch));
int bfp_pud_scratch P_((int s_len, int d_len));
int bfp_pud_inplace P_((void));
void bfp_pez P_((vec_p d, vec_p s, vec_p i, vec_p f, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int bfp_pez_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int bfp_pez_inplace P_((void));
void bfp_peb P_((vec_p d, vec_p s, vec_p i, vec_p f, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int bfp_peb_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int bfp_peb_inplace P_((void));
void bfp_ped P_((vec_p d, vec_p s, vec_p i, vec_p f, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int bfp_ped_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int bfp_ped_inplace P_((void));
void dpe_puz P_((vec_p d, vec_p s, vec_p i, vec_p v, int len_src, int len_dest, vec_p scratch));
int dpe_puz_inplace P_((void));
int dpe_puz_scratch P_((int s_len, int d_len));
void dpe_pub P_((vec_p d, vec_p s, vec_p i, vec_p v, int len_src, int len_dest, vec_p scratch));
int dpe_pub_inplace P_((void));
int dpe_pub_scratch P_((int s_len, int d_len));
void dpe_pud P_((vec_p d, vec_p s, vec_p i, vec_p v, int len_src, int len_dest, vec_p scratch));
int dpe_pud_inplace P_((void));
int dpe_pud_scratch P_((int s_len, int d_len));
void dpe_pez P_((vec_p d, vec_p s, vec_p i, vec_p v, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
void dpe_peb P_((vec_p d, vec_p s, vec_p i, vec_p v, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
void dpe_ped P_((vec_p d, vec_p s, vec_p i, vec_p v, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int dpe_pez_inplace P_((void));
int dpe_pez_scratch P_((int n_in, int m_in, int n_out, int m_out));
int dpe_peb_inplace P_((void));
int dpe_peb_scratch P_((int n_in, int m_in, int n_out, int m_out));
int dpe_ped_inplace P_((void));
int dpe_ped_scratch P_((int n_in, int m_in, int n_out, int m_out));
void dfp_puz P_((vec_p d, vec_p s, vec_p i, vec_p f, vec_p v, int len_src, int len_dest, vec_p scratch));
void dfp_pub P_((vec_p d, vec_p s, vec_p i, vec_p f, vec_p v, int len_src, int len_dest, vec_p scratch));
void dfp_pud P_((vec_p d, vec_p s, vec_p i, vec_p f, vec_p v, int len_src, int len_dest, vec_p scratch));
int dfp_puz_inplace P_((void));
int dfp_puz_scratch P_((int s_len, int d_len));
int dfp_pub_inplace P_((void));
int dfp_pub_scratch P_((int s_len, int d_len));
int dfp_pud_inplace P_((void));
int dfp_pud_scratch P_((int s_len, int d_len));
void dfp_pez P_((vec_p d, vec_p s, vec_p i, vec_p f, vec_p v, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
void dfp_peb P_((vec_p d, vec_p s, vec_p i, vec_p f, vec_p v, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
void dfp_ped P_((vec_p d, vec_p s, vec_p i, vec_p f, vec_p v, vec_p sd_s, int n_s, int m_s, vec_p sd_d, int n_d, int m_d, vec_p scratch));
int dfp_pez_inplace P_((void));
int dfp_pez_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int dfp_peb_inplace P_((void));
int dfp_peb_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
int dfp_ped_inplace P_((void));
int dfp_ped_scratch P_((int s_vec_len, int s_seg_len, int d_vec_len, int d_seg_len));
void tgt_fos P_((cvl_timer_t *cvl_timer_p));
double tdf_fos P_((cvl_timer_t *t1, cvl_timer_t *t2));
int siz_fob P_((int length));
int siz_foz P_((int length));
int siz_fod P_((int length));
int siz_fos P_((int n, int m));
void mke_fov P_((vec_p sd, vec_p l, int n, int m, vec_p scratch));
int mke_fov_inplace P_((void));
int mke_fov_scratch P_((int n, int m));
void len_fos P_((vec_p l, vec_p sd, int n, int m, vec_p scratch));
int len_fos_scratch P_((int n, int m));
int len_fos_inplace P_((void));
vec_p alo_foz P_((unsigned int size));
void fre_fov P_((vec_p pointer));
vec_p add_fov P_((vec_p v, int a));
int sub_fov P_((vec_p v1, vec_p v2));
cvl_bool eql_fov P_((vec_p v1, vec_p v2));
int cmp_fov P_((vec_p v1, vec_p v2));

#undef P_
