(in-package :nesl-lisp) 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; DEFINITION OF THE MACHINE CONFIGURATIONS.                              ;;
;;                                                                        ;;
;; If you are NOT going to be using remote access, then this file can     ;;
;; probably be left alone.  If you are going to use remote access, then   ;;
;; you will need to set up the variables and configurations appropriately.;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; This definition is the default
(add-configuration nesl::local 
  (make-config :memsize 1048576
	       :interp-file "vinterp"
	       :machine-name "local"))

;;; THE FOLLOWING ARE EXAMPLE SETUPS, THEY NEED TO BE CHANGED.

(add-configuration nesl::cray_with_afs
  (make-config :memsize 3600000
	       :user-name "joefoo"
	       :interp-file "vinterp.cray"
	       :rsh-command "/usr/bin/rsh"
	       :machine-name "mario.psc.edu"
	       :background-function #'cray-qsub-command))

(add-configuration nesl::cray_no_afs 
  (make-config :memsize 3600000
	       :user-name "joefoo"
	       :interp-file "vinterp.cray"
	       :afs nil
	       :rcp-source-machine "joefoo@joes.machine.podunku.edu"
	       :rsh-command "/usr/bin/rsh"
	       :machine-name "mario.psc.edu"
	       :background-function #'cray-qsub-command))

(add-configuration nesl::cm5_ncsa_no_afs
  (make-config :memsize 1000000
	       :user-name "joefoo"
	       :interp-file "vinterp.cm5"
	       :afs nil
	       :rcp-source-machine "joefoo@joes.machine.podunku.edu"
	       :rsh-command "/usr/bin/rsh"
	       :machine-name "cm5.ncsa.uiuc.edu"))

(add-configuration nesl::cm2_psc_withafs
  (make-config :memsize 65536
	       :interp-file "vinterp.cm2"
	       :munch-lines 1
	       :user-name "joefoo"
	       :rsh-command "/usr/bin/rsh"
	       :machine-name "cmsuna.psc.edu"
	       :background-function #'cm-qsub-command))
