/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

#include "vcode.h"
#include "y.tab.h"

#if 0
***********************   This is  defined in vcode.h:
typedef struct {
  VOPCODE       vop;                    /* opcode */
  char          *vopname;               /* string giving its name */
  int           numargs;                /* number of arguments to check for */
  TYPE          arg_type[MAX_ARGS];     /* input argument types */
  unsigned      arg_len[MAX_ARGS];      /* bit mask for constraint checking */
  TYPE          result_type[MAX_OUT];   /* in terms of input types */
  unsigned      result_len[MAX_OUT];    /* in terms of input sizes */
  int		arg_for_scratch[MAX_ARGS];	/* arg to check scratch */
  cvl_desc_t    cvl_desc;               /* info about cvl call */
} vopdes_t;
***********************
#endif

/*
 * Descriptor table for VCODE primitives.  
 */

/* NB: make sure the order here is the same as in y.tab.h!!! */

vopdes_t vopdes_table[] = {
	{PLUS,	"+",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Agree1,},
		{AGREE1,},
		{1,},
		Elwise2},
	{MINUS,	"-",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Agree1,},
		{AGREE1,},
		{1,},
		Elwise2},
	{TIMES,	"*",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Agree1,},
		{AGREE1,},
		{1,},
		Elwise2},
	{DIV,	"/",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Agree1,},
		{AGREE1,},
		{1,},
		Elwise2},
	{MOD,	"%",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Agree1,},
		{AGREE1,},
		{1,},
		Elwise2},
	{LT,	"<",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Bool,},
		{AGREE1,},
		{1,},
		Elwise2},
	{LEQ,	"<=",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Bool,},
		{AGREE1,},
		{1,},
		Elwise2},
	{GT,	">",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Bool,},
		{AGREE1,},
		{1,},
		Elwise2},
	{GEQ,	">=",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Bool,},
		{AGREE1,},
		{1,},
		Elwise2},
	{EQ,	"=",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Bool,},
		{AGREE1,},
		{1,},
		Elwise2},
	{NEQ,	"!=",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Bool,},
		{AGREE1,},
		{1,},
		Elwise2},
	{LSHIFT,	"LSHIFT",	2,	1,
		{Int, Int, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Int,},
		{AGREE1,},
		{1,},
		Elwise2},
	{RSHIFT,	"RSHIFT",	2,	1,
		{Int, Int, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Int,},
		{AGREE1,},
		{1,},
		Elwise2},
	{NOT,	"NOT",		1,	1,
		{Given, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Agree1,},
		{AGREE1,},
		{1,},
		Elwise1},
	{AND,	"AND",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Agree1,},
		{AGREE1,},
		{1,},
		Elwise2},
	{OR,	"OR",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Agree1,},
		{AGREE1,},
		{1,},
		Elwise2},
	{XOR,	"XOR",		2,	1,
		{Given, Given, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},	
		{Agree1,},
		{AGREE1,},
		{1,},
		Elwise2},
	{SELECT,	"SELECT",	3,	1,
		{Bool, Given, Given, Illegal, Illegal, Illegal},
		{NONE, AGREE1, AGREE1, 0, 0, 0},	
		{Agree2,},
		{AGREE1,},
		{1,},
		Elwise3},
	{RAND,	"RAND",		1,	1,
		{Int, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Int,},
		{AGREE1,},
		{1,},
		Elwise1},
	{FLOOR,	"FLOOR",	1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Int,},
		{AGREE1,},
		{1,},
		Elwise1},
	{CEIL,	"CEIL",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Int,},
		{AGREE1,},
		{1,},
		Elwise1},
	{TRUNC,	"TRUNC",	1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Int,},
		{AGREE1,},
		{1,},
		Elwise1},
	{ROUND,	"ROUND",	1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Int,},
		{AGREE1,},
		{1,},
		Elwise1},
	{LOG,	"LOG",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{SQRT,	"SQRT",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{EXP,	"EXP",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{SIN,	"SIN",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{COS,	"COS",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{TAN,	"TAN",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{ASIN,	"ASIN",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{ACOS,	"ACOS",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{ATAN,	"ATAN",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{SINH,	"SINH",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{COSH,	"COSH",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{TANH,	"TANH",		1,	1,
		{Float, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{I_TO_F,	"I_TO_F",	1,	1,
		{Int, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Float,},
		{AGREE1,},
		{1,},
		Elwise1},
	{I_TO_B,	"I_TO_B",	1,	1,
		{Int, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Bool,},
		{AGREE1,},
		{1,},
		Elwise1},
	{B_TO_I,	"B_TO_I",	1,	1,
		{Bool, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Int,},
		{AGREE1,},
		{1,},
		Elwise1},

	{PLUS_SCAN,	"+_SCAN",	2,	1,
		{Given, Segdes, Illegal, Illegal, Illegal, Illegal},
		{NONE, COMPAT1, 0, 0, 0, 0},
		{Agree1,},
		{AGREE1,},
		{2,},
		Scan},
	{MAX_SCAN,	"MAX_SCAN",	2,	1,
		{Given, Segdes, Illegal, Illegal, Illegal, Illegal},
		{NONE, COMPAT1, 0, 0, 0, 0},
		{Agree1,},
		{AGREE1,},
		{2,},
		Scan},
	{MIN_SCAN,	"MIN_SCAN",	2,	1,
		{Given, Segdes, Illegal, Illegal, Illegal, Illegal},
		{NONE, COMPAT1, 0, 0, 0, 0},
		{Agree1,},
		{AGREE1,},
		{2,},
		Scan},
	{AND_SCAN,	"AND_SCAN",	2,	1,
		{Bool, Segdes, Illegal, Illegal, Illegal, Illegal},
		{NONE, COMPAT1, 0, 0, 0, 0},
		{Bool,},
		{AGREE1,},
		{2,},
		Scan},
	{OR_SCAN,	"OR_SCAN",	2,	1,
		{Bool, Segdes, Illegal, Illegal, Illegal, Illegal},
		{NONE, COMPAT1, 0, 0, 0, 0},
		{Bool,},
		{AGREE1,},
		{2,},
		Scan},

	{PLUS_REDUCE,	"+_REDUCE",	2,	1,
		{Given, Segdes, Illegal, Illegal, Illegal, Illegal},
		{NONE, COMPAT1, 0, 0, 0, 0},
		{Agree1,},
		{AGREE2,},
		{2,},
		Reduce},
	{MAX_REDUCE,	"MAX_REDUCE",	2,	1,
		{Given, Segdes, Illegal, Illegal, Illegal, Illegal},
		{NONE, COMPAT1, 0, 0, 0, 0},
		{Agree1,},
		{AGREE2,},
		{2,},
		Reduce},
	{MIN_REDUCE,	"MIN_REDUCE",	2,	1,
		{Given, Segdes, Illegal, Illegal, Illegal, Illegal},
		{NONE, COMPAT1, 0, 0, 0, 0},
		{Agree1,},
		{AGREE2,},
		{2,},
		Reduce},
	{AND_REDUCE,	"AND_REDUCE",	2,	1,
		{Bool, Segdes, Illegal, Illegal, Illegal, Illegal},
		{NONE, COMPAT1, 0, 0, 0, 0},
		{Bool,},
		{AGREE2,},
		{2,},
		Reduce},
	{OR_REDUCE,	"OR_REDUCE",	2,	1,
		{Bool, Segdes, Illegal, Illegal, Illegal, Illegal},
		{NONE, COMPAT1, 0, 0, 0, 0},
		{Bool,},
		{AGREE2,},
		{2,},
		Reduce},

	{PERMUTE,	"PERMUTE",	3,	1,
		{Given, Int, Segdes, Illegal, Illegal, Illegal},
		{NONE, AGREE1, COMPAT1, 0, 0, 0},
		{Agree1,},
		{AGREE1,},
		{3,},
		Permute},
	{DPERMUTE,	"DPERMUTE",	5,	1,
		{Given, Int, Given, Segdes, Segdes, Illegal},
		{NONE, AGREE1, NONE, COMPAT1, COMPAT3, 0},
		{Agree1,},
		{AGREE3,},
		{4,5,},
		Dpermute},
	{FPERMUTE,	"FPERMUTE",	5,	1,
		{Given, Int, Bool, Segdes, Segdes, Illegal},
		{NONE, AGREE1, AGREE1, COMPAT1, AGREE4, NONE},
		{Agree1,},
		{COMPAT5,},
		{4,5,},
		Fpermute},
	{BPERMUTE,	"BPERMUTE",	4,	1,
		{Given, Int, Segdes, Segdes, Illegal, Illegal},
		{NONE, NONE, COMPAT1, COMPAT2, 0, 0},
		{Agree1,},
		{AGREE2,},
		{3,4,},
		Bpermute},
	{BFPERMUTE,	"BFPERMUTE",	5,	1,
		{Given, Int, Bool, Segdes, Segdes, Illegal},
		{NONE, NONE, AGREE2, COMPAT1, COMPAT2|AGREE4, 0},
		{Agree1,},
		{COMPAT5,},
		{4,5,},
		Bfpermute},
	{DFPERMUTE,	"DFPERMUTE",	6,	1,
		{Given, Int, Bool, Given, Segdes, Segdes},
		{NONE, NONE, AGREE2, AGREE2, COMPAT1, AGREE5|COMPAT2},
		{Agree1,},
		{AGREE4,},
		{5,6,},
		Dfpermute},
	{EXTRACT, 	"EXTRACT",	3,	1,
		{Given, Int, Segdes, Illegal, Illegal, Illegal},
		{NONE, NONE, COMPAT1|AGREE2, 0, 0, 0}, /* weird, but true! */
		{Agree1,},
		{AGREE2,},
		{3,},
		Extract},
	{REPLACE, 	"REPLACE",	4,	1,
		{Given, Int, Given, Segdes, Illegal, Illegal},
		{NONE, NONE, AGREE2, COMPAT1|AGREE2, 0, 0},
		{Agree1,},
		{AGREE1,},
		{4,},
		Replace},
	{DIST,	"DIST",		2,	1,
		{Given, Segdes, Illegal, Illegal, Illegal, Illegal},
		{NONE, AGREE1, 0, 0, 0, 0},/* Yes, this is correct!!!!! */
		{Agree1,},
		{COMPAT2,},
		{2,},
		Dist},
	{PACK, "PACK",		3,	2,
		{Given, Bool, Segdes, Illegal, Illegal, Illegal},
		{NONE, AGREE1, COMPAT1, 0, 0 , 0},
		{Agree1, Segdes, },
		{AGREE1, AGREE2, }, 
		{3,},
		SegOp},

	{LENGTH,	"LENGTH",	1,	1,
		{Given, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},
		{Int,},
		{IS_SCALAR,},
		{1,},
		SegOp},

	{MAKE_SEGDES,	"MAKE_SEGDES",	1,	1,
		{Int, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Segdes,},
		{AGREE1,},  /* This is might be implementation dependent */
		{1,},
		SegOp},
	{LENGTHS,	"LENGTHS",	1,	1,
		{Segdes, Illegal, Illegal, Illegal, Illegal, Illegal},
		{NONE, 0, 0, 0, 0, 0},	
		{Int,},
		{AGREE1,},   /* same here */
		{1,},
		SegOp},

	{COPY,	"COPY",		0,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{POP,	"POP",		0,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{CALL,	"CALL",		0,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{RET,	"RET",		0,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{FUNC,	"FUNC",		0,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{IF,	"IF",		0,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{ELSE,	"ELSE",		0,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{ENDIF,	"ENDIF",	0,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{CONST,	"CONST",	0,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},

	{START_TIMER, "START_TIMER",	0,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{STOP_TIMER, "STOP_TIMER",	1,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},

	{READ,	"READ",		0,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{WRITE,	"WRITE",	1,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{FOPEN,	"FOPEN",	1,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{FCLOSE, "FCLOSE",	1,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{FREAD,	"FREAD",	1,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
	{FWRITE, "FWRITE",	1,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special},
        {SPAWN, "SPAWN",	1,	1,
		{Illegal, Illegal, Illegal, Illegal, Illegal, Illegal},
		{0, 0, 0, 0, 0, 0},
		{None,},
		{NONE,},
		{-1,},
		Special}
};


/* this is debugging code to check the validity of the above table.
 * I've been burnt too many times from mistakes....
 * Returns 1 if everything is OK.
 */
int ok_vcode_table()
{
    return 1;
}
