/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

/* declarations needed for parsers */
#include <stdio.h>

/* need this to store CONSTANT values */
typedef union {
	int ival;
	double dval;
	int bval;
    } const_union;

/* defined by yacc */
extern FILE 	*yyin;
extern int 	yylex();
extern int	yylineno;
extern int 	yyparse();
#ifdef cray
extern long 	yyleng;
#else
#ifdef CM5
extern long	yyleng;
#else
extern int 	yyleng;
#endif /* CM5 */
#endif /* CRAY */
extern char	yytext[];

/* defined in grammar.yy */
extern int      parse_error;            /* set to true if error during parse */
extern const_union constant;		/* CONSTANT values */
extern char     current_fn[];		/* last fn name read by lexer */
extern char     main_fn[];   		/* name of top level fn */
extern int      main_defined;           /* Has the top level fn been defined? */
extern int      first_function;         /* Is this the first fn in the file? */

/* defined in actions.c */
extern TYPE type();
extern void parse_label();
extern void parse_call();
extern void parse_stack();
extern void parse_const();
extern void parse_begin_vec();
extern void parse_val_vec();
extern void parse_end_vec();
extern void parse_string();
extern void parse_stmt();
extern void parse_if();
extern void parse_else();
extern void parse_endif();
extern void parse_return();
