;;;
;;; Copyright (c) 1992 Carnegie Mellon University 
;;;                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
;;;                                  Jonathan Hardwick, Jay Sipelstein,
;;;                                  Marco Zagha
;;; All Rights Reserved.
;;;
;;; Permission to use, copy, modify and distribute this software and its
;;; documentation is hereby granted, provided that both the copyright
;;; notice and this permission notice appear in all copies of the
;;; software, derivative works or modified versions, and any portions
;;; thereof, and that both notices appear in supporting documentation.
;;;
;;; CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
;;; CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
;;; ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
;;;
;;; The SCAL project requests users of this software to return to 
;;;
;;;  Guy Blelloch				guy.blelloch@cs.cmu.edu
;;;  School of Computer Science
;;;  Carnegie Mellon University
;;;  5000 Forbes Ave.
;;;  Pittsburgh PA 15213-3890
;;;
;;; any improvements or extensions that they make and grant Carnegie Mellon
;;; the rights to redistribute these changes.
;;;

(in-package 'nesl-lisp)

(defun strip-binds (binds environment)
  (if (null binds) nil
    (let ((bind1 (car binds)))
      (cons (list (strip-exp (first bind1) environment) 
		  (strip-exp (second bind1) environment))
	    (strip-binds (cdr binds) environment)))))

(defun strip-with (exp environment)
  `(,(first exp) ,(strip-binds (second exp) environment)
    ,(strip-exp (third exp) environment)))

(defun strip-func (exp environment)
  (let ((subcall (strip-exp (second exp) environment)))
    (if (get-typedef (first exp) environment)
	subcall
      (list (first exp) subcall))))
    
(defun strip-exp (exp environment)
  (cond ((nesl-constant-p exp) exp)
	((symbolp exp) exp)
	((listp exp)
	 (cond ((eql (car exp) 'nesl::if)
		`(nesl::if ,(strip-exp (second exp) environment)
			   ,(strip-exp (third exp) environment)
			   ,(strip-exp (fourth exp) environment)))
	       ((eql (car exp) 'nesl::pair)
		`(nesl::pair ,(strip-exp (second exp) environment)
			     ,(strip-exp (third exp) environment)))
	       ((eql (car exp) 'nesl::vector)
		`(nesl::vector ,(strip-exp (second exp) environment)))
	       ((or (eql (car exp) 'nesl::with) (eql (car exp) 'nesl::over))
		(strip-with exp environment))
	       (t (strip-func exp environment))))
	(t (nesl-error "Internal error: Invalid expression, ~s." exp))))

(defun strip-type-exp (typeexp tstack defs)
  (cond ((and (atom typeexp) (assoc typeexp tstack))
	 (cdr (assoc typeexp tstack)))
	((symbolp typeexp) typeexp)
	((listp typeexp)
	 (cond ((eql (car typeexp) 'nesl::pair)
		`(nesl::pair ,(strip-type-exp (second typeexp) tstack defs)
			     ,(strip-type-exp (third typeexp) tstack defs)))
	       ((eql (car typeexp) 'nesl::vector)
		`(nesl::vector ,(strip-type-exp (second typeexp) tstack defs)))
	       (t
		(let* ((type-dec (typedef-type
				  (get-typedef (first typeexp) defs)))
		       (nstack
			(mapcar #'(lambda (subtype var) 
				    (cons (car var) 
					  (strip-type-exp subtype tstack 
							  defs)))
				(cdr typeexp)
				(cdr type-dec))))
		  (strip-type-exp (second (car type-dec)) nstack defs)))))
	(t (nesl-error "Internal error: invalid type expression."))))

(defun strip-type (type env)
  (let* ((context (cdr type))
	(dest-type (car (car type)))
	(source-type (second (car type)))
	(result
	 (cons (list (strip-type-exp dest-type nil env) 
		       (strip-type-exp source-type nil env))
	  context)))
    result))
