#include <stdio.h>
#include "makeplot.h"

Display *getdisplay(char *displayname)
{
  Display *disp;
  if ((disp = XOpenDisplay(displayname)) == NULL){
    fprintf(stderr, "Cannot connect to Xserver %s\n",
	    XDisplayName(NULL));
    exit(-1);
  }
  return disp;
}

int width, height, x0,y0;
FILE *psstream = NULL;

void Create_Ps(int x, int y, int w, int h, char *filename)
{
  psstream = fopen(filename,"w");
  width = w; height = h;
  x0 = x; y0 = y;
  if (psstream == NULL) {
    fprintf(stderr,"Could not open Post Script output file ~a\n",filename);
    exit(1);
  }
  fputs(ps_header1,psstream);
  fprintf(psstream,"%s: %d %d %d %d\n","%%BoundingBox",x,y,x+w,y+h);
  fputs(ps_header2,psstream);
}

void Close_Ps()
{
  fputs(ps_tailer,psstream);
  fclose(psstream);
}

void Create_Window(int x, int y, int width, int height, 
		   char *title, char *displayname)
{
  int screen;
  unsigned long mask, fore_pix, back_pix;
  XSizeHints	size_hints;
  XWMHints wm_hints;
  XClassHint class_hints;
  XTextProperty wp, ip;
  static char *windowname;
  static char *iconname;
  XSetWindowAttributes winattr;
  XEvent ev;
    
  if (strlen(title) == 0) {
    windowname = (char *)malloc(strlen(DEFAULT_TITLE)+1);
    strcpy(windowname, DEFAULT_TITLE);
  }
  else windowname = title;

  iconname = (char *)malloc(strlen(ICONNAME)+1);
  strcpy(iconname, ICONNAME);

  display = getdisplay(displayname);

  screen = DefaultScreen(display);
  fore_pix = WhitePixel(display, screen);
  back_pix = BlackPixel(display, screen);

  win = XCreateSimpleWindow (display, RootWindow(display,screen),
			     x,y, width, height,
			     3,	/* border width */
			     fore_pix,back_pix);

  /* USPosition is supposed to mean user specified position */
  size_hints.flags = USPosition | USSize;

  /* This says that window will initially start exposed (instead of as
     an icon */
  wm_hints.initial_state = NormalState;
  wm_hints.flags = StateHint;
    
  /* Who knows whta these do?? */
  class_hints.res_name = "program name";
  class_hints.res_class = "program class name";

  if (XStringListToTextProperty(&windowname, 1, &wp) == 0 ||
      XStringListToTextProperty(&iconname, 1, &ip) == 0 ){
    fprintf(stderr,"name allocation failed\n");
    exit(-1);
  }
  XSetWMProperties(display, win, &wp, &ip, NULL, 0,
		   &size_hints, &wm_hints, &class_hints);

  winattr.backing_store = Always;
  winattr.bit_gravity = NorthWestGravity;
  mask = CWBackingStore | CWBitGravity;

  XSelectInput(display, win, ExposureMask);
  XMapWindow(display,win);
  do {
    XNextEvent(display,&ev);
    if (ev.type == Expose)
      break;
  } while (1); 

  XChangeWindowAttributes(display, win, mask, &winattr);
}

GC linedef(Display *display, int width)
{
  unsigned long mask;
  XGCValues values;
  int screen = DefaultScreen(display);

  mask = GCFunction | GCForeground | GCBackground | GCLineWidth;
  values.function = GXcopy;
  values.foreground = WhitePixel(display, screen);
  values.background = BlackPixel(display, screen);
  values.line_width = width;

  return XCreateGC(display, RootWindow(display, screen), mask, &values);
}

void exit_now()
{
  if (psstream != NULL) Close_Ps();
  exit(0); 
}

void exit_on_mouse()
{
  if (psstream != NULL) exit_now();
  else
    {
      XEvent ev;
      XButtonEvent* pev = (XButtonEvent *) &ev;
      XSelectInput(display, win, ButtonPressMask);
      XMapWindow(display,win);
      XNextEvent(display,&ev);
      exit(0);
    }
}

void get_mouse_coordinates()
{
  XEvent ev;
  XButtonEvent* pev = (XButtonEvent *) &ev;
  XSelectInput(display, win, ButtonPressMask);
  XMapWindow(display,win);
  XNextEvent(display,&ev);
  printf("( %d ) ( %d ) ( %d ) ( %d )\n",pev->x,pev->y,pev->button,pev->state);
  fflush(stdout);
}

void begin_paren_vector()
{
  char c1, c2;
  c1 = getchar();
  c2 = getchar();
  if (!((c1 == '(' || c1 == '[') && c2 == ' ')) {
    fprintf(stderr,"Bad input to plotting program (begin_paren_vect).\n");
    exit_on_mouse();
  }
}

void end_paren_vector()
{
  char c1, c2;
  c1 = getchar();
  c2 = getchar();
  if (!((c1 == ')' || c1 == ']') && c2 == '\n')) {
    fprintf(stderr,"Bad input to plotting program (end_paren_vect).\n");
    exit_on_mouse();
  }
}

void end_paren_vector_with_space()
{
  char c1, c2, c3;
  c1 = getchar();
  c2 = getchar();
  c3 = getchar();
  if (!(c1 == ' ' && (c2 == ')' || c2 == ']') && c3 == '\n')) {
    fprintf(stderr,"Bad input to plotting program (end_paren_vect).\n");
    exit_on_mouse();
  }
}

int get_number()
{
  int i,r;
  begin_paren_vector();
  r = scanf("%d", &i);
  if (r < 1) fprintf(stderr,"Bad input to plotting program (get_number).\n");
  end_paren_vector_with_space();
  return i;
}

char *get_string()
{
  int l,i,c;
  char* str;
  l = get_number();
  l = get_number();
  c = 0; 
  i = 0;
  str = (char *) malloc(sizeof(char)*l + 1);
  while (i < l && c != EOF)  {
    c = getchar();
    str[i++] = c;
  }
  if (c == EOF) 
    fprintf(stderr,"Bad input to plotting program (get_string).\n");
  str[i] = '\0';
  return str;
}

int read_int()
{
  int c,r;
  r = 0;
  c = getchar();
  while (c == ' ' || c == '\n') 
    c = getchar();
  while (c >= '0' && c <= '9') {
    r = 10*r + c - '0';
    c = getchar();
  }
  return r;
}

void read_points(XPoint *plist, int n)
{
  int i;

  begin_paren_vector();
  for (i = 0; i < n ; i++) plist[i].x = read_int();
  end_paren_vector();

  begin_paren_vector();
  for (i = 0; i < n ; i++) plist[i].y = read_int();
  end_paren_vector();
}

void psdrawpoints(XPoint *plist, int l) {
  int i;
  fprintf(psstream,"%d setlinewidth\n", 1);
  for (i = 0; i < l; i++)
    fprintf(psstream,"%d %d P\n",x0+plist[i].x,y0+height-plist[i].y);
}

readdrawpoints()
{
  XPoint *plist;
  int w,l,i,p;
  l = get_number();
  plist = (XPoint *) malloc(sizeof(XPoint)*l);
  read_points(plist,l);
  if (psstream == NULL) {
    XDrawPoints(display, win, linedef(display,1), plist, l, 0);
    XFlush(display);
  }
  else psdrawpoints(plist,l);
}

void psdrawlines(XPoint *plist, int w, int l) {
  int i;
  fprintf(psstream,"%d setlinewidth\n", w);
  for (i = 0; i < l; i++)
    fprintf(psstream,"%d %d L\n",x0+plist[i].x,y0+height-plist[i].y);
}

readdrawlines()
{
  XPoint *plist;
  int w,l,i,p;
  w = get_number();
  l = get_number();
  plist = (XPoint *) malloc(sizeof(XPoint)*l);
  read_points(plist,l);
  if (psstream == NULL) {
    XDrawLines(display, win, linedef(display,w), plist, l, 0);
    XFlush(display);
  }
  else psdrawlines(plist,w,l);
}

void psdrawstring(stringinfo str) {
  int angle = 0;
  fprintf(psstream,"(%s) %d %d %d T\n", 
          str.chars, angle, x0+str.x, y0+height-str.y);
}

int read_string_info(stringinfo *slist, int n)
{
  int i, sum = 0;
  begin_paren_vector();
  for (i = 0; i < n ; i++) slist[i].x = read_int();
  end_paren_vector();

  begin_paren_vector();
  for (i = 0; i < n ; i++) slist[i].y = read_int();
  end_paren_vector();

  begin_paren_vector();
  for (i = 0; i < n ; i++)
   sum += 1 + (slist[i].nchars = read_int());
  end_paren_vector();

  return sum;
}

readdrawtext()
{
  stringinfo *str_list;
  char *text_list;
  char scratch[100];
  int l,i,p,k, sum;
  char c, *pt, *end;
  l = get_number();

  str_list = (stringinfo *) malloc(sizeof(stringinfo)*l);
  sum = read_string_info(str_list,l); 
  /* fprintf(stderr, "sum1: %d\n", sum); */
  text_list = (char *) malloc(sizeof(char)*sum);
  sum = get_number();
  fflush(stderr);
  /* fprintf(stderr, "sum2: %d\n", sum); */

  for(i = 0, pt = text_list; i < l; i++) { 
    str_list[i].chars = pt;
    end = pt + str_list[i].nchars;
    while (pt < end) *(pt++) = getchar();
    *(pt++) = '\0';
    if (psstream == NULL)
      XDrawString(display,win,linedef(display,1),
		  str_list[i].x, str_list[i].y,
		  str_list[i].chars, str_list[i].nchars);
    else psdrawstring(str_list[i]);
  }
  if (psstream == NULL) XFlush(display);
}

void read_segments(XSegment *slist, int n)
{
  int i;

  begin_paren_vector();
  for (i = 0; i < n ; i++) slist[i].x1 = read_int();
  end_paren_vector();

  begin_paren_vector();
  for (i = 0; i < n ; i++) slist[i].y1 = read_int();
  end_paren_vector();

  begin_paren_vector();
  for (i = 0; i < n ; i++) slist[i].x2 = read_int();
  end_paren_vector();

  begin_paren_vector();
  for (i = 0; i < n ; i++) slist[i].y2 = read_int();
  end_paren_vector();
}

void psdrawsegments(XSegment *slist, int w, int l) {
  int i;
  fprintf(psstream,"%d setlinewidth\n", w);
  for (i = 0; i < l; i++)
    fprintf(psstream,"%d %d %d %d S\n",
            x0+slist[i].x1,y0+height-slist[i].y1,
            x0+slist[i].x2,y0+height-slist[i].y2);
}

readdrawsegments()
{
  XSegment *slist;
  int w,l,i,p;
  w = get_number();
  l = get_number();
  slist = (XSegment *) malloc(sizeof(XSegment)*l);
  read_segments(slist,l);
  if (psstream == NULL) {
    XDrawSegments(display, win, linedef(display,w), slist, l);
    XFlush(display);
  }
  else psdrawsegments(slist,w,l);
}

main() {
  int mode,x0,y0,width,height;
  char *display_name, *title;

  display_name = get_string();
  title = get_string();
  mode = get_number();
  x0 = get_number();
  y0 = get_number();
  width = get_number();
  height = get_number();

  if (mode == 0) Create_Window(x0,y0,width,height,title,display_name);
  else Create_Ps(x0,y0,width,height,display_name);
  do {
    int command = get_number();
    if (command == 0) readdrawpoints();
    else if (command == 1) readdrawlines(); 
    else if (command == 2) readdrawsegments();
    else if (command == 3) get_mouse_coordinates();
    else if (command == 4) exit_now();
    else if (command == 5) readdrawtext(win);
    else exit_on_mouse();
  } while(1);
}
