;;;
(in-package 'nesl-lisp)

;;; tokenizer for CGOL.

;;;;gdc - better cgolerr and rubout-handling could be added for common lisp
;;;; Change in cgol.cg:  tp isin !'(9. 12. 13.) => cwhitespacep(tp)
;;(defvar *escape-char*  #\esc)
(defvar *begin-comment-char*  #\%)
(defvar *end-comment-char*  #\%)

(DEFVAR EOFM (LIST 'EOFM))

(defvar token nil)
(defvar stringnud nil)
(defvar cibase 10.)
(defvar cgolerr nil "controls throws for eof condition")
(defvar ctoken-table nil)
(defvar ret-nud nil "The instance variable of a recyled closure")
(defun ret-nud () ret-nud)
(defvar fun 'TOP-LEVEL)
(defvar silence -1)
(defvar free-kons nil)

(DEFUN NORMALIZE-READ-ARGS (READ-ARGS)
  (cons (car read-args) (cadr read-args)))

(DEFUN CGOLREAD (&REST READ-ARGS &AUX STREAM EOFM)
  (SETQ READ-ARGS (NORMALIZE-READ-ARGS READ-ARGS))
  (SETQ STREAM (CAR READ-ARGS)
	EOFM (CDR READ-ARGS))
  ;;gdc - nil is supposed to be an acceptable default, but SUN/Lucid 2.0
  ;; doesn't recognize it, so use *standard-input*
  (if (null stream) (setq stream *standard-input*))
 (LET ((WHICH-OPERATIONS NIL))
    (catch 'CGOLERR
      (toplevel-parse stream))))

(DEFUN TOPLEVEL-PARSE (STANDARD-INPUT
		       &AUX
		       ;; State variables.
		       (CGOLERR T) TOKEN STRINGNUD RET-NUD
		       (FUN 'TOP-LEVEL) (token-history nil))
  (declare (special standard-input token-history))
   ;; may throw the eof marker here.
  (COND ((EQ (ADVANCE) ')
	 ;; KLUDGE for old CGOL source files.
	 '')
	(T
	 ;;gdc- added to handle initial keyword debugger command in COMMON LISP
	 (if (and (symbolp token) (char= (char (symbol-name token) 0) #\:))
	     (setq token
		   (intern (concatenate 'string
					(subseq (symbol-name token) 1)
					(if (cwhitespacep (ctyipeek)) ""
					    ;;Use (read) instead?
					    (write-to-string (cgoltoken))))
			   'keyword))
	     (progn
	       (SETQ CGOLERR NIL)
	       (PARSE -1))))))

(DEFUN CGOLERR (MESSAGE &optional LEVEL FATALP)
  (declare (special token-history))
  (COND ((AND FATALP CGOLERR)
	 (throw 'CGOLERR EOFM))
	(t
	 (let ((history (if (> (length token-history) 10)
			    (cons "...." (reverse (subseq token-history 0 10)))
			  (reverse token-history))))
	   (do ((token (cgoltoken) (cgoltoken)))
	       ((or (eql token ') (eql token 'nesl::|;|))))
	   (nesl-error "~%Syntax error in expression:~{ ~a~}~%~a"
		       history
		       message))
	 )))

#|
(defun cgolerr (message &optional level fatalp)
  (declare (special token-history) (ignore level fatalp))
  (let ((history (if (> (length token-history) 20)
		     (cons "...." (reverse (subseq token-history 0 20)))
		   (reverse token-history))))
    (do ((token (cgoltoken) (cgoltoken)))
	((or (eql token ') (eql token 'nesl::|;|))))
    (nesl-error "~%In expression:~{ ~a~}~%~a"
		history
		message)))
|#

(defun ctyi ()
  (read-char standard-input nil -1)) ;args are eof-error-p, eof-value

(defun ctyipeek () (peek-char nil standard-input nil -1))

(defun cuntyi (c)
  (unread-char c standard-input))
	 
(defun cgoltyipeek () (ctyipeek))

(DEFVAR CREAD-READTABLE *readtable*)

(defvar creadlist-readtable (copy-readtable nil)) ; totally new readtable

(defun cread ()
  (LET ((*READTABLE* CREAD-READTABLE))
    (read standard-input nil eofm)))

;;; Macros and functions used by the tokenizer loop.

(defmacro return-token (c l &optional (quoted-p 'quoted-p) (reversed-p t))
  `(progn ,(if c `(cuntyi ,c))
	  ;;gdc - last arg. added for COMMON LISP
	  (return (make-token ,l ,quoted-p ,reversed-p (or fixnum-p flonum-p)))))

;; The tokenizer is a simple loop with the character TYI'd pushed on the
;; token buffer after a series of special cases are checked.
;; The boolean state variables could be replaced with predicates
;; that look back on what in in the buffer, however the present implementation
;; is highly straightforward.

(defun cgoltoken ()
  (declare (special token-history))
  (first (push
	  (do ((l nil (KONS c l))
	       (c (cskip-whitespace) (ctyi))
	       (temp)
	       (quoted-p nil)
	       (fixnum-p nil)
	       (flonum-p nil)
	       (expt-p nil)
	       (digit-after-expt-p nil)
	       )
	      (nil)
	    (cond ((equal c -1)
		   (if (null l)
		       (cgolerr "EOF encountered inside cgol-exp - CGOLREAD" 2 t)
		       (return-token c l)))
		  ((char= c #\$)
			   (if (null l)
			       (return ')
			       (return-token c l)))
		  ((char= c #\!)
			   (if (null l)
			       (return (cread))
			       (return-token c l)))
		  ((and (char= c #\`) (eql (car nudl) 'neslnud))
			   (if (null l)
			       (return (ctyi))
			       (return-token c l)))
		  ((char= c #\?)
			   (setq quoted-p t)
			   (setq flonum-p nil)
			   (setq fixnum-p nil)
			   (setq c (ctyi)))
		  ((char= c #\") 
		   (if (null l)
		       (return (ctoken-string))
		     (return-token c l)))
		  ((cwhitespacep c)
		   (return-token c l))
		  ((char= c #\.)
			   (cond ((null l)
				  (if (cdigit-p (ctyipeek))
				      (setq fixnum-p nil flonum-p t)
				      (return '\.)))
				 ((null fixnum-p)
				  (return-token c l t))
				 (t
				  (if fixnum-p (setq flonum-p t))
				  (setq fixnum-p nil))))
		  ((and (or (char= c #\E) (char= c #\e))
			;;gdc -COMMON LISP doesn't require flonum-p (see below)
			;;flonum-p
			(or fixnum-p flonum-p)
			(not expt-p))
		   (let ((p (ctyipeek)))
		     (if (not (or (char= p #\+)
				  (char= p #\-)
				  (cdigit-p p)))
			 (return-token c l)))
		   ;;gdc - added for COMMON LISP
		   (setq flonum-p t)
		   (setq expt-p t))
		  ((cdigit-p c)
		   (if (null l)
		       (setq fixnum-p t))
		   (if expt-p (setq digit-after-expt-p t)))
		  ((and (or (char= c #\+) (char= c #\-))
			flonum-p
			expt-p
			(not digit-after-expt-p)
			(cdigit-p (ctyipeek))))
		  ((setq temp (clookup (setq c (CHAR-UPCASE c)) ctoken-table))
		   (if (null l)
		       (return-token nil (KONS c (cfollow-tail (cdr temp))) t nil)
		       (return-token c l)))
		  (t
		   ;;gdc -add to handle 34myop45 as three tokens instead of two
		   (if (or fixnum-p flonum-p) (return-token c l))
		   ;;gdc - could delete next two lines.
		   (setq fixnum-p nil)
		   (setq flonum-p nil))))
	  token-history)))


(defun cwhitespacep (c)
  (or (member c '(#\Space #\Return #\Linefeed #\Tab #\Page))
      (eql c *begin-comment-char*)))

(defun cskip-whitespace ()
  (do ((commentp nil)(c))
      (nil)
    (setq c (ctyi))
    (cond ((eql c (if commentp *end-comment-char* *begin-comment-char*))
	   ;; gdc - c will be -1 for eof
	   (setq commentp (not commentp)))
	  ((cwhitespacep c))
	  ((NOT COMMENTP)
	   (RETURN C)))))


(defun clookup (x y) (assoc x y))

(defun initialize-multi-character-token-table (string)
  (setq ctoken-table
	(mapcar #'list (coerce (string string) 'list))))

(defun cfollow-tail (alist)
  ;; this way of recognizing tokens is taken from the original cgol,
  ;; is fast and easy and passes all tokens which are subtokens
  ;; of explicitely defined tokens.
  (IF (NULL ALIST) nil
      (let ((c (CHAR-UPCASE (ctyipeek))))
	(cond ((setq alist (clookup c alist))
	       (ctyi)
	       (KONS c (cfollow-tail (cdr alist))))
	      (t
	       nil)))))

(defmacro with-working-cons (&rest l)
  (cond (nil
	 `(let ((default-cons-area working-storage-area))
	    ,@l))
	('else
	 `(progn ,@l))))

(defun puttok (token)
  ;; entry point for defining tokens.
  (with-working-cons
    (let ((l (coerce (string token) 'list)))
      (or (clookup (car l) ctoken-table)
	  (error "token with illegal first character" token))
      (setq ctoken-table (inserttok l ctoken-table)))))

(defun inserttok (tok toktable) 
  (if (null tok)
      toktable
      (let ((st (clookup (car tok) toktable)))
	(cond ((null st)
	       (cons (cons (car tok)
			   (inserttok (cdr tok) nil))
		     toktable))
	      (t
	       (rplacd st (inserttok (cdr tok) (cdr st)))
	       toktable)))))

;;; Added buy GuyB for NESL
(defun cgol-make-string (l)
  (prog1 (coerce (nreverse l) 'string) (reklaim l)))

(defun ctoken-string ()
  (do ((c (ctyi) (ctyi))
       (l nil (KONS c l))
       (fixnum-p nil) (flonum-p nil))
      (nil)
      (cond ((char= c #\\)
	     (setq c (ctyi)))
	    ((char= c #\")
	     (return (cgol-make-string l))))))
	   
(defun cdigit-p (x)
 (not (or (char< x #\0)
		  (char> x #\9))))


(defun make-token  (l do-not-try-as-number-p rp number-p)
  ;; takes the stack of characters and makes a token.
  (if rp (setq l (nreverse l)))
  (prog1
    (if (or do-not-try-as-number-p
	    ;;ok-as-number-p could be removed for both versions.
	     (not number-p))
	 (intern (coerce l 'string))
	(let ((ibase cibase))
	  (creadlist l)))
    (reklaim l)
    ))

(defun readlist (list) (read-from-string (coerce list 'string)))

(defun creadlist (l)
  (let ((*readtable* creadlist-readtable))
    (readlist l)))

;; Keeping our own free-list is a way to use lists for stacks without the
;; overhead of garbage collection. On the LISPM this should be replaced
;; with a STRING and an INDEX pointer.

(defun kons (kar kdr)
  (if free-kons
      (PROGN
	(rplaca free-kons kar)
	(rplacd (prog1 free-kons (setq free-kons (cdr free-kons)))
		kdr))
      (with-working-cons
	(cons kar kdr))))

(defun reklaim (l)
  (setq free-kons (nconc l free-kons)))


;; Interface functions.
(defun |cgol-#-readmacro| (stream)
  ;; #FOOBAR is a syntax escape to the FOOBAR language.
  (funcall (get-read (if (member (peek-char () stream)
				  '(#\Space #\Return #\Tab #\Page)
				 )
			 'CGOL
			 (read stream)))
	   stream))


(setf (get 'cgol 'read) #'cgolread)
(setf (get 'rat 'read) 'ratread)

; this is called from a splicing macro, so we want to make sure to listify
; the result. why this isn't done in maclisp is a mystery to me  -jkf

(defun list-cgolread (stream) (list (cgolread stream)))

(defun get-read (language)
  (if (symbolp language)
      (or (get language 'read)
	  (get-read (error "Undefined language ~s ~a" language 'wrng-type-arg)
		    ))
      (get-read (error "Not a language symbol ~s ~a" language 'wrng-type-arg)
		)))


(defvar rat-arithmetic_alist
  '((plus . rat-plus)
    (minus . rat-minus)
    (difference . rat-difference)
    (times . rat-times)
    (float . progn)
    (quotient . rat-quotient)
    (equal . rat-equal)
    (lessp . rat-lessp)
    (greaterp . rat-greaterp)
    (expt . rat-expt)))

(defun ratread (&rest l)
  (let ((arithmetic_alist rat-arithmetic_alist))
    (declare (special arithmetic_alist))
    (apply #'cgolread l)))

(set-dispatch-macro-character #\# #\
			      #'(lambda (stream subchar arg)
				       (declare (ignore subchar arg))
				       (|cgol-#-readmacro| stream)))

;;(set-dispatch-macro-character #\# *escape-char*
;;			      #'(lambda (stream subchar arg)
;;				       (declare (ignore subchar arg))
;;				       (|cgol-#-readmacro| stream)))

(set-dispatch-macro-character #\# #\$
			      #'(lambda (stream subchar arg)
				       (declare (ignore subchar arg))
				       (|cgol-#-readmacro| stream)))




;; The problem of invoking CGOL over a whole stream is correctly solved by 
;; pushing and popping a stack of read methods for a stream.
;; However, maclisp and the lisp machine provide special variables READ and READTABLE 
;; for this.

(progn 'compile

;; the idea here is to have a readtable such that every single
;; character causes CGOLREAD to be invoked. 

(defvar cgol-invoking-readtable
  (copy-readtable  nil))
(defvar cgol-invoking-read-char #\Space
  "Untyi'd by the cgol-invoking-read-macro")

(do ((char 0 (1+ char)))
    ((= char #o200))
  (set-syntax-from-char (coerce char 'character)
			#\'
			cgol-invoking-readtable))

(defun cgol-invoking-read-macro (stream char)
  (unread-char char stream)
  (cgolread stream))

(do ((char 0 (1+ char)))
    ((= char #o200))
  (if (/= char 3) ; don't change #\^C
      (set-macro-character (coerce char 'character) 
			   #'cgol-invoking-read-macro t
			   cgol-invoking-readtable)))
)


(defvar prin1 nil)	; since prin1 has no meaning in franz but is needed


(defvar read-prin1-stack ())

(defun cgol-enter (ignore-it)
  (push (cons *readtable*
	      PRIN1)
	read-prin1-stack)
  (setq *readtable* cgol-invoking-readtable))

(defun cgol-exit ()
   
  (let ((a (pop read-prin1-stack)))
    (if a
	(setq *readtable* (CAR A)
	      prin1 (cdr a))
	(warn "APPARENT ATTEMPT TO EXIT FROM CGOL WHEN NOT IN CGOL"))))
(defun exit () (cgolexit))

(defun funcall-reader-on-string (reader string eof)
  (funcall reader (make-string-stream string (exploden string)) eof))

