(in-package 'nesl-lisp)

(proclaim '(special token nudl ledl lbpl))

(defun advance () (setq token (cgoltoken)))

(defun verify (den) 
  (if den (progn (advance) den)))

(defun getden (indl)
  (and (symbolp token) (get token (car indl))))

(defun nud ()
  (verify
   (or (getden nudl)
       (if (getden lbpl) 
	   (cgolerr (cat token '| is missing its left argument.|) 2 T)
	 (let ((val token)) #'(lambda () val))))))

(defun led () 
  (or (verify (getden ledl))
      (cgolerr (cat token '| is not an operator with a left argument.|) 2 t)))

(defun parse (rbp)
  (do ((trans (funcall (nud)) 
	      (funcall (led) trans)))
      ((not (< rbp (or (getden lbpl) 0))) 
       trans)))

(defun cat (&rest n)
  (eval (list* 'concatenate ''string (mapcar #'(lambda (x)
				       (write-to-string x :escape nil)) n))))

(initialize-multi-character-token-table
    '|-+#&'()*,/:;<=>@[\\]^`{?\|}!|)

(defmacro deftok (&rest a)
  (subst (list 'quote a) 'a '(mapc #'puttok a)))
