(in-package 'nesl-lisp)

(let* ((root-directory *nesl-path*)
       #+(or allegro excl) (obj-tailer ".fasl")
       #+lucid             (obj-tailer ".sbin")
       #+cmu               (obj-tailer ".f")
       #+kcl               (obj-tailer ".o")
       (src-dir (concatenate 'string root-directory "/src/"))
       (obj-dir (concatenate 'string root-directory "/bin/")))
  (flet ((comp-lisp-file (name &key needs)
	   (let ((src-file (concatenate 'string src-dir name ".lisp"))
		 (obj-file (concatenate 'string obj-dir name obj-tailer)))
	     (when (not (probe-file src-file))
		   (error "No source file ~a." src-file))
	     (when (or (not (probe-file obj-file))
		       (< (file-write-date obj-file)
			  (file-write-date src-file)))
	       (when needs (load needs))
	       (compile-file src-file :output-file obj-file))))
	 (comp-c-file (name &key needs)
	   (let ((src-file (concatenate 'string src-dir name ".c"))
		 (obj-file (concatenate 'string obj-dir name)))
	     (when (not (probe-file src-file))
		   (error "No source file ~a." src-file))
	     (when (or (not (probe-file obj-file))
		       (< (file-write-date obj-file)
			  (file-write-date src-file)))
	       (when needs (load needs))
	       (run-shell-line 
		(format nil "gcc -O -o ~a ~a -lX11" obj-file src-file)))))
	 (load-file (name)
	    (load (concatenate 'string obj-dir name obj-tailer))))
    (comp-lisp-file "funspec")
    (load-file "funspec")
    (comp-lisp-file "free")
    (comp-lisp-file "type")
    (comp-lisp-file "type-check")
    (comp-lisp-file "trans")
    (comp-lisp-file "ptrans")
    (comp-lisp-file "strip-recs")
    (comp-lisp-file "output")
    (comp-lisp-file "run-vcode")
    (comp-lisp-file "vcode-lisp")
    (comp-lisp-file "defop")
    (comp-lisp-file "nesl-read")
    (comp-lisp-file "read-eval-print")
    (comp-lisp-file "pprint")
    (comp-lisp-file "doc")
    (comp-lisp-file "cgtoke")
    (comp-lisp-file "cgol-cl")
    (load-file "cgtoke")
    (load-file "cgol-cl")
    (comp-lisp-file "cnesl")
    (comp-c-file "makeplot")

    (when (probe-file "vcode/Makefile")
       (format t "~%; Compiling CVL and VCODE~%~%")
       (run-shell-line (format nil "cd ~avcode; make" *nesl-path*)))
    ))

