#+allegro-version>=
(setq excl:*cltl1-in-package-compatibility-p* t)

(in-package 'nesl-lisp)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; THE FOLLOWING VARIABLE NEEDS TO BE         ;;;;
;;;; CHANGED DEPENDING ON YOUR SYSTEM.          ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; The directory in which this file is located.
(defparameter *NESL-PATH* 
  "/usr/foo/nesl/")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; THE FOLLOWING TWO VARIABLE MIGHT NEED TO   ;;;;
;;;; BE CHANGED.                                ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Name of the directory of the vcode interpreter.
;; By default this is the vcode/bin/ subdirectory of NESL-PATH.
(defparameter *VCODE-INTERPRETER-DIR*
  (concatenate 'string *NESL-PATH* "vcode/vinterp/"))

;; Directory where the vcode files are written to.
;; It must be both readable and writable by all users of NESL.
(defparameter *VCODE-TEMP-DIRECTORY* 
  "/tmp/")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; THE REST OF THIS FILE SHOULD BE LEFT AS IS. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defparameter *nesl-version* nil)

(defparameter *nesl-date* nil)

(with-open-file (releasefile (concatenate 'string *NESL-PATH* "src/releasenum")
			     :direction :input)
  (setq *nesl-version* (read-line releasefile))
  (setq *nesl-date* (read-line releasefile)))

(format t "~%; Loading NESL version ~a, ~a~%~%"
	*nesl-version* *nesl-date*)

;;; This takes a string and executes it as if it was a line of text
;;; to the shell.  Standard in, out and error go to the terminal.
(defun run-shell-line (command-string)
  #+lucid
  (lcl::shell command-string)
  #+(or allegro excl)
  (system::run-shell-command command-string)
  #+cmu
  (extensions:run-program "/bin/csh" (list "-fc" command-string)
			  :output *standard-output* :error *standard-output*)
  #+kcl
  (system command-string)
  #-(or lucid allegro excl cmu kcl)
  (error "The NESL/VCODE interface has not been implemented ~
          for the Lisp you are using."))

(defun getenv (varname)
  "Gets an environment variable.  
Returns a string if defined or nil if undefined."
  #+cmu (cdr (assoc (intern varname "KEYWORD") extensions::*environment-list*))
  #+(and lucid lcl3.0) (lucid-common-lisp:environment-variable varname)
  #+(and lucid (not lcl3.0))  (system:environment-variable varname)
  #+(or allegro excl) (system:getenv varname)
  #+kcl (si:getenv varname)
  #-(or allegro lucid cmu excl kcl) nil)

(defun save-lisp-image (filename restart-function)
  #+allegro (excl::dumplisp :name filename :restart-function restart-function)
  ;; Note that KCL does not take a restart function argument
  #+kcl (save filename)
  #+lucid (disksave filename :restart-function restart-function)
  #+cmu (error "Don't know how to dump a Lisp image in CMU CL."))

(defparameter *obj-tailer* 
  #+(and (or allegro excl) (not allegro-version>=)) ".faslold"
  #+allegro-version>= ".fasl"
  #+lucid ".sbin"
  #+cmu ".f"
  #+kcl ".o")

(defun dump-nesl (dumpfile)
  (setq *username* nil)
  (save-lisp-image dumpfile #'nesl))

(defun load-bin-file (filename)
  (when (not (load (concatenate 'string "bin/" filename *obj-tailer*)
		   :if-does-not-exist nil))
    (format t "Sorry, there is no compiled version of this file.")))

(defparameter *plot_file* 
  (concatenate 'string *nesl-path* "bin/makeplot"))

(let ((*default-pathname-defaults* (pathname *nesl-path*)))
  (declare (special *default-pathname-defaults*))
  (load "src/packages.lisp")
  (load "make.lisp")
  (load-bin-file "funspec")
  (load-bin-file "free")
  (load-bin-file "trans")
  (load-bin-file "ptrans")
  (load-bin-file "type")
  (load-bin-file "type-check")
  (load-bin-file "strip-recs")
  (load-bin-file "output")
  (load-bin-file "run-vcode")
  (load-bin-file "vcode-lisp")
  (load-bin-file "defop")
  (load-bin-file "nesl-read")
  (load-bin-file "read-eval-print")
  (load-bin-file "pprint")
  (load-bin-file "doc")

  ;; CNESL SYNTAX STUFF
  (load-bin-file "cgtoke")
  (load-bin-file "cgol-cl")
  (load-bin-file "cnesl")
  (speaknesl)

  ;; Hack because of bug in kcl.
  #+kcl
  (defun ctyi () (read-char standard-input nil -1))

  (load "src/config.lisp")
  (init-machine-configuration)

  (let ((*redefine-default* t)
	(*verbose* nil))
    (declare (special *redefine-default* *verbose*))
    (load-nesl "src/types.nesl" :print nil)
    (load-nesl "src/scalar-ops.nesl" :print nil)
    (load-nesl "src/vector-ops.nesl" :print nil)
    (load-nesl "src/nest-ops.nesl" :print nil)
    (load-nesl "src/io.nesl" :print nil)
    (load-nesl "src/plot.nesl" :print nil)
    (load-nesl "src/ltoc.nesl" :print nil)
    (load-nesl "src/other-ops.cnesl" :print nil)
    )

  (format t "~%")

  (format t "~%~%; -> You can switch to Lisp by typing lisp();~%~
                 ; -> and back to Nesl by typing (nesl).~%~
                 ; -> Use (nesl) when an error aborts you out of the ~
                 interpreter.~%~
                 ; -> Type help(); for a list of the top level commands.~%~%")
  )

(nesl)

