/* starting time is 18:11:47 */
/* C code produced by gperf version 2.5 (GNU C++ version) */
/* Command-line: gperf -ptTD -K funct_string -k 1,2,6,7 -N vcode_lookup  */
/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

/* This file contains a list of all the VCODE tokens.  The lexer uses the
 * hash function whenever it encouters an identifer and returns the token
 * of the identifier found.
 */

#include <stdio.h>
#include "vcode.h"
#include "y.tab.h"
#include "parse.h"
#include "vcode_hash.h"

#define TOTAL_KEYWORDS 91
#define MIN_WORD_LENGTH 1
#define MAX_WORD_LENGTH 11
#define MIN_HASH_VALUE 1
#define MAX_HASH_VALUE 339
/* maximum key range = 339, duplicates = 6 */

static unsigned int
hash (str, len)
     register char *str;
     register int unsigned len;
{
  static unsigned short asso_values[] =
    {
     340, 340, 340, 340, 340, 340, 340, 340, 340, 340,
     340, 340, 340, 340, 340, 340, 340, 340, 340, 340,
     340, 340, 340, 340, 340, 340, 340, 340, 340, 340,
     340, 340, 340,   0, 340, 340, 340,  20, 340, 340,
     340, 340,  10,  80, 340,  40, 340,  15, 340, 340,
     340, 340, 340, 340, 340, 340, 340, 340, 340, 340,
      25,  30,  55, 340, 340,  20,  85,  30,  55, 104,
     115, 340,  50,  30, 340, 340, 100,  90,  20,   5,
      55,  15,  45,  40,   0,  40, 340,  10,  10, 340,
     340, 340, 340, 340, 340,  15, 340, 340, 340, 340,
     340, 340, 340, 340, 340, 340, 340, 340, 340, 340,
     340, 340, 340, 340, 340, 340, 340, 340, 340, 340,
     340, 340, 340, 340, 340, 340, 340, 340,
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 7:
        hval += asso_values[str[6]];
      case 6:
        hval += asso_values[str[5]];
      case 5:
      case 4:
      case 3:
      case 2:
        hval += asso_values[str[1]];
      case 1:
        hval += asso_values[str[0]];
    }
  return hval;
}

vcode_com_t *
vcode_lookup (str, len)
     register char *str;
     register unsigned int len;
{
  static vcode_com_t wordlist[] =
    {
      {"",}, 
      {"T",  V_TRUE},
      {"*",  TIMES},
      {"/",  DIV},
      {"XOR",  XOR},
      {"%",  MOD},
      {"TAN",  TAN},
      {"ATAN",  ATAN},
      {"TANH",  TANH},
      {"<",  LT},
      {"NOT",  NOT},
      {"=",  EQ},
      {"!=",  NEQ},
      {"COS",  COS},
      {"COSH",  COSH},
      {"COPY",  COPY},
      {"CONST",  CONST},
      {"-",  MINUS},
      {"AND",  AND},
      {"STDIN",  STDIN},
      {"STDOUT",  STDOUT},
      {"TRUNC",  TRUNC},
      {"OR",  OR},
      {"INT",  INT},
      {"ACOS",  ACOS},
      {"CALL",  CALL},
      {"ROUND",  ROUND},
      {">",  GT},
      {"<=",  LEQ},
      {"SQRT",  SQRT},
      {"WRITE",  WRITE},
      {"POP",  POP},
      {"ASIN",  ASIN},
      {"START_TIMER",  START_TIMER},
      {"RAND",  RAND},
      {"SIN",  SIN},
      {"SINH",  SINH},
      {"PACK",  PACK},
      {"STOP_TIMER",  STOP_TIMER},
      {"+",  PLUS},
      {"CHAR",  CHAR},
      {">=",  GEQ},
      {"DIST",  DIST},
      {"RSHIFT",  RSHIFT},
      {"STDERR",  STDERR},
      {"BOOL",  BOOL},
      {"OR_SCAN",  OR_SCAN},
      {"AND_SCAN",  AND_SCAN},
      {"SPAWN",  SPAWN},
      {"LOG",  LOG},
      {"NULL_STREAM",  NULL_STREAM},
      {"MAIN",  MAIN},
      {"F",  V_FALSE},
      {"EXP",  EXP},
      {"+_SCAN",  PLUS_SCAN},
      {"FOPEN",  FOPEN},
      {"ENDIF",  ENDIF},
      {"I_TO_B",  I_TO_B},
      {"B_TO_I",  B_TO_I},
      {"CEIL",  CEIL},
      {"LSHIFT",  LSHIFT},
      {"IF",  IF},
      {"SELECT",  SELECT},
      {"EXTRACT",  EXTRACT},
      {"RET",  RET},
      {"READ",  READ},
      {"OR_REDUCE",  OR_REDUCE},
      {"DPERMUTE",  DPERMUTE},
      {"FUNC",  FUNC},
      {"FREAD",  FREAD},
      {"I_TO_F",  I_TO_F},
      {"MAX_SCAN",  MAX_SCAN},
      {"+_REDUCE",  PLUS_REDUCE},
      {"MIN_SCAN",  MIN_SCAN},
      {"BPERMUTE",  BPERMUTE},
      {"SEGDES",  SEGDES},
      {"ELSE",  ELSE},
      {"AND_REDUCE",  AND_REDUCE},
      {"FPERMUTE",  FPERMUTE},
      {"FLOOR",  FLOOR},
      {"FLOAT",  FLOAT},
      {"FWRITE",  FWRITE},
      {"FCLOSE",  FCLOSE},
      {"LENGTH",  LENGTH},
      {"MAKE_SEGDES",  MAKE_SEGDES},
      {"PERMUTE",  PERMUTE},
      {"MAX_REDUCE",  MAX_REDUCE},
      {"MIN_REDUCE",  MIN_REDUCE},
      {"REPLACE",  REPLACE},
      {"LENGTHS",  LENGTHS},
      {"DFPERMUTE",  DFPERMUTE},
      {"BFPERMUTE",  BFPERMUTE},
    };

  static short lookup[] =
    {
        -1,   1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   2,  -1,  -1,
        -1,  -1,   3,  -1,   4,  -1,  -1,   5,  -1,   6, 344,  -1,   9,  -1,
        10,  -7,  -2,  11,  12,  -1,  -1,  -1,  -1,  -1,  13, 347,  16,  17,
        -1,  18,  -1,  19,  20, -14,  -2,  -1,  21,  -1,  22,  23, 346,  26,
        27,  28,  -1,  29,  30, -24,  -2,  31,  32,  -1,  33,  -1,  -1,  34,
        -1,  -1,  -1,  35,  36,  -1,  -1,  -1,  -1,  37,  38,  39,  -1,  -1,
        40,  -1,  -1,  41,  -1,  42,  -1, 340, -43,  -2,  45,  -1,  -1,  46,
        47,  -1,  48,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  49,  -1,  -1,  50,
        -1,  -1,  51,  -1,  52,  53,  -1,  -1,  -1,  54,  -1,  -1,  -1,  55,
        -1,  -1,  -1,  56,  -1,  -1,  -1,  -1,  -1,  -1, 342,  -1,  59, -57,
        -2,  -1,  -1,  -1,  -1,  -1,  60,  61,  -1,  -1,  62,  63,  64,  65,
        66,  -1,  -1,  -1,  67,  68,  -1,  -1,  -1,  -1,  -1,  69,  70,  -1,
        71,  -1,  -1,  -1,  -1,  72,  -1,  -1,  -1,  -1,  73,  -1,  -1,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  74,  -1,  75,  -1,  -1,  -1,  -1,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  76,  77,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  78,  -1, 340, -79,  -2,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  81,  -1,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
        -1,  -1,  -1,  82,  -1,  -1,  -1,  -1,  83,  -1,  -1,  -1,  -1,  84,
        -1,  -1,  -1,  -1,  85,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  86,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  87,  88,  -1,  -1,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  89,  -1,  -1,  -1,  -1,  -1,  -1,
        -1,  90,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
        -1,  -1,  -1,  91,
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register int index = lookup[key];

          if (index >= 0 && index < MAX_HASH_VALUE)
            {
              register char *s = wordlist[index].funct_string;

              if (*s == *str && !strcmp (str + 1, s + 1))
                return &wordlist[index];
            }
          else if (index < 0 && index >= -MAX_HASH_VALUE)
            return 0;
          else
            {
              register int offset = key + index + (index > 0 ? -MAX_HASH_VALUE : MAX_HASH_VALUE);
              register vcode_com_t *base = &wordlist[-lookup[offset]];
              register vcode_com_t *ptr = base + -lookup[offset + 1];

              while (--ptr >= base)
                if (*str == *ptr->funct_string && !strcmp (str + 1, ptr->funct_string + 1))
                  return ptr;
            }
        }
    }
  return 0;
}

VOPCODE lookup_id(id)
char *id;
{
    vcode_com_t *result;

    result = vcode_lookup(id , strlen(id));
    if (result == NULL)
	return IDENTIFIER;
    else return result->vop;
}
/* ending time is 18:11:48 */
