/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

/* Functions for doing link of user defined vcode procedures */

#include <stdio.h>
#include <strings.h>

#include "vcode.h"
#include "vstack.h"
#include "program.h"
#include "symbol_table.h"

extern int yylineno;
typedef struct link_list_entry {
    char                    fn_name[FN_NAME_MAX];
    int                     prog_num;
    struct link_list_entry *next;
} *link_list_entry_t, link_list_entry_data_t;

link_list_entry_t    link_list;

void link_list_init()
{
    link_list = NULL;
}

static link_list_entry_t new_link()
{
    link_list_entry_t link = (link_list_entry_t) malloc(sizeof(link_list_entry_data_t));
    if (link == NULL) {
        fprintf(stderr, "couldn't allocate link list entry");
        vinterp_exit(1);
    } 
    return link;
}

void link_list_enter(id, prog_num)
char *id;
int prog_num;
{
	link_list_entry_t	new_link_entry;
	
	if (link_trace)
	    fprintf(stderr, "adding link for linking %s\n", id);

	new_link_entry = new_link();
	new_link_entry->next = link_list;
	link_list = new_link_entry;

	(void) strncpy(new_link_entry->fn_name, id, FN_NAME_MAX);
	new_link_entry->prog_num = prog_num;
}

/* link up program: traverse the linked list looking up each function in
 * the symbol table and fixing up program branch entries.
 * Returns 1 on error, 0 if everything links.
 */
int do_link()
{
    link_list_entry_t link = link_list;
    int link_error = 0;

    for (link = link_list; link != NULL; link = link->next) {
	hash_entry_t hash_entry = hash_table_lookup(link->fn_name);

        if (link_trace)
	    fprintf(stderr, "linking %s\n", link->fn_name);

	if (hash_entry == NULL) {
	    fprintf(stderr, "vinterp: unresolved identifier %s on line %d\n", 
                            link->fn_name, link->prog_num);
	    link_error = 1;
	} else {
	    program[link->prog_num].misc.branch = hash_entry->prog_num;
	}
    }
    return link_error;
}
