/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

#include <math.h>
#include "defins.h"
#include <cvl.h>

/* This file has lots of ugly C preprocessor macros for generating
 * elementwise CVL operations.
 */

/* --------------Function definition macros --------------------*/

#define onefun(_name, _funct, _srctype, _desttype)          \
    void _name (d, s, len, scratch)                         \
    vec_p d, s, scratch;                                    \
    int len;                                                \
    {                                                       \
        register _desttype *dest = (_desttype *) d;         \
        register _srctype *src = (_srctype *) s;            \
        unroll(len, *dest++ = _funct(*src++);)              \
    }                                                       \
    make_no_scratch(_name)                                  \
    make_inplace(_name,INPLACE_TRUE)

#define twofun(_name, _funct, _srctype, _desttype)          \
    void _name (d, s1, s2, len, scratch)                    \
    vec_p d, s1, s2, scratch;                               \
    int len;                                                \
    {                                                       \
        register _desttype *dest = (_desttype *) d;         \
        register _srctype *src1 = (_srctype *) s1;          \
        register _srctype *src2 = (_srctype *) s2;          \
        unroll(len, *dest++ = _funct(*src1++, *src2++);)    \
    }                                                       \
    make_no_scratch(_name)                                  \
    make_inplace(_name,INPLACE_TRUE)

#define twofunlazy(_name, _funct, _srctype, _desttype)      \
    void _name (d, s1, s2, len, scratch)                    \
    vec_p d, s1, s2, scratch;                               \
    int len;                                                \
    {                                                       \
        register _desttype *dest = (_desttype *) d;         \
        register _srctype *src1 = (_srctype *) s1;          \
        register _srctype *src2 = (_srctype *) s2;          \
        unroll(len, *dest = _funct(*src1, *src2); dest++;src1++;src2++;)    \
    }                                                       \
    make_no_scratch(_name)                                  \
    make_inplace(_name,INPLACE_TRUE)

#define twofuni(_name, _funct, _srctype, _desttype)         \
    void _name (d, s1, s2, len, scratch)                    \
    vec_p d, s1, s2, scratch;                               \
    int len;                                                \
    {                                                       \
        register _desttype *dest = (_desttype *) d;         \
        register _srctype *src1 = (_srctype *) s1;          \
        register _srctype *src2 = (_srctype *) s2;          \
        unroll(len, *dest++ = _funct(src1, src2);)          \
    }                                                       \
    make_no_scratch(_name)                                  \
    make_inplace(_name,INPLACE_TRUE)

/* selection functs must do their own pointer bumping
 * and the first arg is a cvl_bool */

#define selfun(_name, _funct, _type)                        \
    void _name (d, s1, s2, s3, len, scratch)                \
    vec_p d, s1, s2, s3, scratch;                           \
    int len;                                                \
    {                                                       \
        _type *dest = (_type *) d;                          \
        cvl_bool *src1 = (cvl_bool *) s1;                   \
        _type *src2 = (_type *) s2;                         \
        _type *src3 = (_type *) s3;                         \
        unroll(len, *dest = _funct(src1, src2, src3); dest++;)    \
    }                                                       \
    make_no_scratch(_name)                                  \
    make_inplace(_name,INPLACE_TRUE)

#define make_two_zd(_basename, _funct)                     \
    twofun(GLUE(_basename,z), _funct, int, int)            \
    twofun(GLUE(_basename,d), _funct, double, double)

#define make_twoi_zd(_basename, _funct)                    \
    twofuni(GLUE(_basename,z), _funct, int, int)           \
    twofuni(GLUE(_basename,d), _funct, double, double)

#define make_two_cvl_bool_bzd(_basename, _funct)           \
    twofun(GLUE(_basename,b), _funct, cvl_bool, cvl_bool)  \
    twofun(GLUE(_basename,z), _funct, int, cvl_bool)       \
    twofun(GLUE(_basename,d), _funct, double, cvl_bool)

#define make_two_cvl_bool_zd(_basename, _funct)            \
    twofun(GLUE(_basename,z), _funct, int, cvl_bool)       \
    twofun(GLUE(_basename,d), _funct, double, cvl_bool)

/* Arithmetic functions, min and max, only defined on z, f, d */
make_twoi_zd(max_wu, maxi)
make_twoi_zd(min_wu, mini)
make_two_zd(add_wu, plus)
make_two_zd(sub_wu, minus)
make_two_zd(mul_wu, times)
make_two_zd(div_wu, div)

make_two_cvl_bool_zd(grt_wu, gt)
make_two_cvl_bool_zd(les_wu, lt)
make_two_cvl_bool_zd(geq_wu, geq)
make_two_cvl_bool_zd(leq_wu, leq)


/* shifts, mod and random only on integers */
twofun(lsh_wuz, lshift, int, int)
twofun(rsh_wuz, rshift, int, int)
twofun(mod_wuz, mod, int, int)
onefun(rnd_wuz, rand, int, int)

/* comparison functions: valid on all input types and returns a cvl_bool */
make_two_cvl_bool_bzd(eql_wu, eq)
make_two_cvl_bool_bzd(neq_wu, neq)

/* selection functions */
selfun(sel_wuz, selecti, int) 
selfun(sel_wub, selecti, cvl_bool) 
selfun(sel_wud, selecti, double) 

/* logical functions */
onefun(not_wub, not, cvl_bool, cvl_bool)
twofun(xor_wub, xor, cvl_bool, cvl_bool)

twofunlazy(or_wub, or, cvl_bool, cvl_bool)    /* be careful!: && and || short circuit */
twofunlazy(and_wub, and, cvl_bool, cvl_bool)

/* bitwise functions */
twofun(or_wuz, bor, int, int)
twofun(and_wuz, band, int, int)
onefun(not_wuz, bnot, int, int)
twofun(xor_wuz, xor, int, int)

/* conversion routines */
onefun(int_wud, d_to_z, double, int)
onefun(int_wub, b_to_z, cvl_bool, int)
onefun(dbl_wuz, z_to_d, int, double)
onefun(boo_wuz, z_to_b, int, cvl_bool)

/* double routines */
onefun(flr_wud, cvl_floor, double, int)
onefun(cei_wud, cvl_ceil, double, int)
onefun(trn_wud, d_to_z, double, int)
onefun(rou_wud, cvl_round, double, int)
onefun(exp_wud, exp, double, double)
onefun(log_wud, log, double, double)
onefun(sqt_wud, sqrt, double, double)
onefun(sin_wud, sin, double, double)
onefun(cos_wud, cos, double, double)
onefun(tan_wud, tan, double, double)
onefun(asn_wud, asin, double, double)
onefun(acs_wud, acos, double, double)
onefun(atn_wud, atan, double, double)
onefun(snh_wud, sinh, double, double)
onefun(csh_wud, cosh, double, double)
onefun(tnh_wud, tanh, double, double)

/* Copy functions must handle overwriting properly */
#define cpyfun(_name, _funct, _srctype, _desttype)          \
    void _name (d, s, len, scratch)                         \
    vec_p d, s, scratch;                                    \
    int len;                                                \
    {                                                       \
        register _desttype *dest = (_desttype *) d;         \
        register _srctype *src = (_srctype *) s;            \
	if (dest < src) {				    \
            unroll(len, *dest++ = *src++;)	            \
	} else if (dest > src) {			    \
	    dest = dest + len;				    \
	    src = src + len;				    \
            unroll(len, *--dest = *--src;)                  \
	}						    \
    }                                                       \
    make_no_scratch(_name)                                  \
    make_inplace(_name,INPLACE_TRUE)

/* copy functions good for everything, including segdes */
onefun(cpy_wuz, ident, int, int)
onefun(cpy_wub, ident, cvl_bool, cvl_bool)
onefun(cpy_wud, ident, double, double)

void cpy_wus(d, s, n, m, scratch)
    vec_p d, s, scratch;
    int n, m;
    {
	cpy_wuz(d, s, m, scratch);
    }
int cpy_wus_scratch(n, m) { return cpy_wuz_scratch(m); }
make_inplace(cpy_wus,INPLACE_TRUE)
