
;;; This package used by the compiler.
(in-package 'nesl-lisp :use '(lisp))

;;; This package used for NESL functions
(eval-when (compile load eval)
  (unless (find-package 'nesl)
    (make-package 'nesl :use nil)))

;;; This package used for parallel versions of the NESL functions
(eval-when (compile load eval)
  (unless (find-package 'neslp)
    (make-package 'neslp :use nil)))

(eval-when (compile load eval) 
  (defparameter nesl-lisp-symbols 
    '(defop <- with over if tup defrec defrecs
       bool int char v.bool v.int .bool .int v.
       write-op nesl
       t nil f
       vcode-equal)))

(eval-when (compile load eval) 
  (defparameter lisp-symbols
    '(load setq defvar in-package progn assert provide require)))

(eval-when (compile load eval) 
  (defparameter system-symbols
    (append nil
	    ;; The symbols are internal to the system package in Lucid 3.0.
	    #+lucid  '(system::quit system::pwd system::cd)
	    #+gclisp '(user::exit)
	    #+cmu    '(user::quit))))

(export nesl-lisp-symbols 'nesl-lisp)

(import nesl-lisp-symbols 'nesl)
(import lisp-symbols 'nesl)
(import system-symbols 'nesl)

(export nesl-lisp-symbols 'nesl)
(export lisp-symbols 'nesl)
(export system-symbols 'nesl)

