(in-package 'nesl-lisp)

(defun undopairs (struct)
  (if (and (listp struct) (eq (car struct) 'nesl::pair))
      (cons (second struct) (undopairs (third struct)))
    (list struct)))

(defun speaknesl nil
  (setq nudl (list 'neslnud))
  (setq ledl (list 'neslled))
  (setq lbpl (list 'nesllbp))
  nil) 

(defun forgetnesl nil
  (setq nudl (list 'nud))
  (setq ledl (list 'led))
  (setq lbpl (list 'lbp))
  nil) 

(defun parseiterbind nil
  (prog (bindname
         bindbody)
    (setq bindname (parse 1))
    (setq bindbody
          (if (eq token 'nesl::in) (progn
                                     (advance)
                                     (parse 1)) bindname))
    (return (list bindname bindbody)))) 

(defun parsetypelist ()
  (let ((type (parse 29)))
    (cond ((eql token  'nesl::|,|)
	   (advance)
	   (cons type (parsetypelist)))
	  (t (list type)))))

(defun parsecontext ()
  (let ((context (list token (progn (advance) (check 'nesl::in) token))))
    (advance)
    (cond ((eql token  'nesl::|;|)
	   (advance)
	   (cons context (parsecontext)))
	  (t (list context)))))

(defparameter *currently-parsing-type* nil)

(defun parsetype ()
  (let ((*currently-parsing-type* t))
    (declare (special *currently-parsing-type*))
    (let ((sourcetypes (prog1 (parsetypelist) (check 'nesl::->)))
	  (desttype (parse 29))
	  (context (if (eq token 'nesl::|::|)
		       (progn (advance) (parsecontext))
		     nil)))
      (cons (cons desttype (cons '<- sourcetypes)) context))))

(defun parsealist ()
  (let ((arg (parse 29)))
    (if (eql token 'nesl::|,|)
	(cons arg (progn (advance) (parsealist)))
      (list arg))))

(learn 'nesl) 

(setf (get ' 'nesllbp) (- 1)) 

(setf (get 'nesl::|;| 'nesllbp) (- 1)) 

(setf (get 'if 'neslnud)
      #'(lambda ()
          (list 'if (parse 2) (progn
                                (check 'nesl::then)
                                (parse 2))
                (progn
                  (check 'nesl::else)
                  (parse 2))))) 

(progn
  (progn
    (setf (get 'nesl::then 'nesllbp) 0)
    (setf (get 'nesl::then 'neslled) nil))) 

(progn
  (progn
    (setf (get 'nesl::else 'nesllbp) 0)
    (setf (get 'nesl::else 'neslled) nil))) 

(setf (get 'nesl::let 'neslnud)
      #'(lambda ()
          (prog (bindings)
            (do ()
                ((equal token 'nesl::in))
              (setq binding (parse 1))
              (if (equal token 'nesl::|;|) (advance))
              (if (eq (first binding) 'nesl::set)
                  (setq bindings (append bindings (list (cdr binding))))
                  (cgolerr '|bad syntax for binding.| 2 t)))
            (advance)
            (return (list 'with bindings (parse 0)))))) 

(setf (get 'nesl::function 'neslnud)
      #'(lambda ()
	  (let* ((funname (prog1 token (advance)))
		 (*current-fundef* funname)
		 (varnames (prog2 (check 'nesl::|(|)
				  (if (eql token 'nesl::|)|)
				      nil
				    (parsealist))
				  (check 'nesl::|)|)))
		 (type (if (eql token 'nesl::|:|)
			   (progn (advance) (parsetype))
			 nil))
		 (body (progn (check 'nesl::=) (parse 0))))
	    (if type
		(list 'defop (cons funname varnames) 'nesl::! type body)
	      (list 'defop (cons funname varnames) body)))))

(setf (get 'nesl::datatype 'neslnud)
      #'(lambda ()
          (prog (typename
                 types
                 context)
            (setq typename token)
            (advance)
            (setq types (parsealist))
            (setq context (parsecontext))
            (return (cons 'defrec (cons (cons typename types) context)))))) 

(setf (get 'nesl::describe 'neslnud)
      #'(lambda ()
          (let ((dval (progn (check 'nesl::|(|) token)))
	    (advance)
	    (check 'nesl::|)|)
	    (list 'nesl::describe dval)))) 

(defun parse-empty-sequence ()
  (let ((*currently-parsing-type* t))
    (declare (special *currently-parsing-type*))
    (advance)
    (flatten-exp (list (make-nested-sequence :data nil))
		 (expand-type (list 'nesl::vector (parse 29)) 
			      *definitions*))))

(defun parse-integer-sequence (val1)
  (advance)
  (let ((val2 (parse 1)))
    (prog1 (if (eq token 'nesl::|:|)
	       (progn (advance) (list 'nesl::iseq val1 (parse 1) val2))
	     (list 'nesl::iseq val1 1 val2))
      (check 'nesl::]))))

(defun parse-sequence-list (current-list)
  (if (eql token 'nesl::|,|)
      (parse-sequence-list 
       (progn (advance) (list 'nesl::snoc current-list (parse 1))))
    (progn (check 'nesl::]) current-list)))

(setf (get 'nesl::[ 'neslnud)
      #'(lambda ()
	  (if *currently-parsing-type*
	      (prog1 (list 'nesl::vector (parse 29)) (check 'nesl::]))
	    (if (eq token 'nesl::])
		(parse-empty-sequence)
	      (let ((val1 (parse 1)))
		(if (eq token 'nesl::|:|)
		    (parse-integer-sequence val1)
		  (parse-sequence-list (list 'nesl::dist val1 1))))))))


(setf (get 'nesl::{ 'neslnud)
      #'(lambda ()
          (prog (body
                 form
                 bindname
                 bindform
                 bindbody
                 packform)
            (setq body (parse 1))
            (if (eq token 'nesl::|:|)
                (progn
                  (advance)
                  (setq bindname (parse 1)))
                (progn
                  (setq bindname body)
                  (setq body nil)))
            (if (eq token 'nesl::in)
                (setq bindbody (progn
                                 (advance)
                                 (parse 1)))
                (setq bindbody bindname))
            (setq bindform (list (list bindname bindbody)))
            (do ()
                ((not (eq token 'nesl::|;|)))
              (advance)
              (setq bindform (cons (parseiterbind) bindform)))
            (setq form (if body (list 'over bindform body) bindbody))
            (if (eq token 'nesl::|\||)
                (progn
                  (advance)
                  (setq packform (parse 1))
                  (setq form
                        (list 'nesl::pack form (list 'over bindform packform)))))
            (check 'nesl::})
            (return form)))) 

(progn
  (setf (get 'nesl::[ 'neslled)
        #'(lambda (left)
            (prog (form)
              (setq form (list 'nesl::elt left (parse 0)))
              (check 'nesl::])
              (return form))))
  (setf (get 'nesl::[ 'nesllbp) '30)) 

(setf (get 'nesl::|(| 'neslnud)
      #'(lambda ()
          (prog2
            nil
            (parse 0)
            (check 'nesl::|)|)))) 

(progn
  (setf (get 'nesl::|(| 'neslled)
        #'(lambda (left)
            (prog2
              nil
              (cons left
                    (if (not (equal token 'nesl::|)|)) (parselist 1 'nesl::|,|)))
              (check 'nesl::|)|))))
  (setf (get 'nesl::|(| 'nesllbp) '30)) 

(progn
  (deftok ->)
  (deftok <-)
  (deftok |::|)) 

(progn
  (deftok ++)
  (deftok |:+|)
  (deftok |+:|)) 

(progn
  (deftok /=)
  (deftok ==)
  (deftok <=)
  (deftok >=)) 

(progn
  (setf (get 'nesl::|,| 'neslled) #'(lambda (left)
                                      (isi left 'nesl::pair 0)))
  (setf (get 'nesl::|,| 'nesllbp) '1)) 

(progn
  (setf (get 'nesl::-> 'neslled) #'(lambda (left)
                                     (isi left 'nesl::-> 24)))
  (setf (get 'nesl::-> 'nesllbp) '24)) 

(progn
  (setf (get '<- 'neslled) #'(lambda (left)
                               (isi left 'nesl::<- 23)))
  (setf (get '<- 'nesllbp) '23)) 

(progn
  (setf (get 'nesl::++ 'neslled) #'(lambda (left)
                                     (isi left 'nesl::++ 20)))
  (setf (get 'nesl::++ 'nesllbp) '20)) 

(setf (get 'nesl::|#| 'neslnud) #'(lambda ()
                                    (isp 'nesl::length 25))) 

(setf (get 'nesl::@ 'neslnud) #'(lambda ()
                                  (isp 'nesl::string 25))) 

(setf (get 'nesl::- 'neslnud) #'(lambda ()
                                  (isp 'nesl::negate 25))) 

(setf (get 'nesl::& 'neslnud)
      #'(lambda ()
          (setq r (parse 25))
          (list 'nesl::print_debug (format nil "~a: " r) r))) 

(progn
  (setf (get 'nesl::= 'neslled) #'(lambda (left)
                                    (isi left 'nesl::set 2)))
  (setf (get 'nesl::= 'nesllbp) '2)) 

(progn
  (setf (get 'nesl::nand 'neslled) #'(lambda (left)
                                       (isi left 'nesl::nand 8)))
  (setf (get 'nesl::nand 'nesllbp) '8)) 

(progn
  (setf (get 'nesl::and 'neslled) #'(lambda (left)
                                      (isi left 'nesl::and 8)))
  (setf (get 'nesl::and 'nesllbp) '8)) 

(progn
  (setf (get 'nesl::or 'neslled) #'(lambda (left)
                                     (isi left 'nesl::or 7)))
  (setf (get 'nesl::or 'nesllbp) '7)) 

(progn
  (setf (get 'nesl::nor 'neslled) #'(lambda (left)
                                      (isi left 'nesl::nor 7)))
  (setf (get 'nesl::nor 'nesllbp) '7)) 

(progn
  (setf (get 'nesl::xor 'neslled) #'(lambda (left)
                                      (isi left 'nesl::xor 7)))
  (setf (get 'nesl::xor 'nesllbp) '7)) 

(progn
  (setf (get 'nesl::== 'neslled) #'(lambda (left)
                                     (isi left 'nesl::= 10)))
  (setf (get 'nesl::== 'nesllbp) '10)) 

(progn
  (setf (get 'nesl::/= 'neslled) #'(lambda (left)
                                     (isi left 'nesl::/= 10)))
  (setf (get 'nesl::/= 'nesllbp) '10)) 

(progn
  (setf (get 'nesl::< 'neslled) #'(lambda (left)
                                    (isi left 'nesl::< 10)))
  (setf (get 'nesl::< 'nesllbp) '10)) 

(progn
  (setf (get 'nesl::> 'neslled) #'(lambda (left)
                                    (isi left 'nesl::> 10)))
  (setf (get 'nesl::> 'nesllbp) '10)) 

(progn
  (setf (get 'nesl::<= 'neslled) #'(lambda (left)
                                     (isi left 'nesl::<= 10)))
  (setf (get 'nesl::<= 'nesllbp) '10)) 

(progn
  (setf (get 'nesl::>= 'neslled) #'(lambda (left)
                                     (isi left 'nesl::>= 10)))
  (setf (get 'nesl::>= 'nesllbp) '10)) 

(progn
  (setf (get 'nesl::+ 'neslled) #'(lambda (left)
                                    (isi left 'nesl::+ 20)))
  (setf (get 'nesl::+ 'nesllbp) '20)) 

(progn
  (setf (get 'nesl::- 'neslled) #'(lambda (left)
                                    (isi left 'nesl::- 20)))
  (setf (get 'nesl::- 'nesllbp) '20)) 

(progn
  (setf (get 'nesl::* 'neslled) #'(lambda (left)
                                    (isi left 'nesl::* 21)))
  (setf (get 'nesl::* 'nesllbp) '21)) 

(progn
  (setf (get 'nesl::/ 'neslled) #'(lambda (left)
                                    (isi left 'nesl::/ 21)))
  (setf (get 'nesl::/ 'nesllbp) '21)) 

(progn
  (setf (get 'nesl::^ 'neslled)
        #'(lambda (left)
            (setq l left)
            (setq r (parse 22))
            (if (eq r 2) (list 'nesl::power2 l)
                (if (eq r 3) (list 'nesl::power3 l) (list 'nesl::power l r)))))
  (setf (get 'nesl::^ 'nesllbp) '22)) 
