;;;
(in-package 'nesl-lisp)

;;; tokenizer for CGOL.

;;Different dialects use different names.
#+common-lisp 
(eval-when (eval load compile)
   (push :common *features*))

;;;;gdc - better cgolerr and rubout-handling could be added for common lisp
;;;; Change in cgol.cg:  tp isin !'(9. 12. 13.) => cwhitespacep(tp)
(defvar *escape-char* #+common (int-char 27) #-common 27)
(defvar *begin-comment-char* #+common #\% #-common 37)
(defvar *end-comment-char* #+common #\% #-common 37)
;;;Needed to stop franz lisp from complaining about bad use of #\ construct
;;; in code to stop common lisp from complaining about ....
#+franz 
(eval-when (compile eval)
	   (defsharp #.(if (eq '\  '| |) '\\ '\  ) (x)
	     (list (if (member (implode (list (tyipeek)))
			       '(|#| |^| | | |;| |$| |!| |"| |.| |(| |)|
				 #.(if (eq '/  '| |) '// '/ )))
		       (tyi)
		       (let ((char (read)))
			 (declare (special franz-symbolic-character-names))
			 (if (greaterp (flatc char) 1)
			     (or (cdr
				  (assq char franz-symbolic-character-names))
				 -1)
			     (car (exploden char)))))))
)
;;;Needed to stop common lisp from complaining about undefined #/ construct
#+common
(eval-when (eval compile)
	   (set-dispatch-macro-character #\# #\^
					 #'(lambda (stream y z)
					     (declare (ignore y z))
					     (read-char stream) nil))
	   (set-dispatch-macro-character #\# #\/
					 #'(lambda (stream y z)
					     (declare (ignore y z))
					     (read-char stream) nil)))

#+Maclisp
(progn 'compile
       (herald CGTOKE)
       (or (get 'CGRUB 'version) (load '((PRATT)CGRUB)))
       (eval-when (compile)
	 (macros nil)
	 (SETQ DEFMACRO-FOR-COMPILING NIL))
       (eval-when (eval compile)
	 (or (fboundp 'defstruct)
	     (load "liblsp;struct")))
       (defvar standard-input nil))

#+franz
(progn 'compile
       ;;gdc 'push changed to 'when since push now standard in franz
   (eval-when (eval) (cond ((null (getd 'when))
			    (cvttomaclisp)
			    (load 'machacks))))
   (defvar standard-input nil)
   (eval-when (compile load eval) (setsyntax #\esc 'vcharacter)))


(DEFVAR EOFM (LIST 'EOFM))

(defvar token nil)
(defvar stringnud nil)
(defvar cibase 10.)
(defvar cgolerr nil "controls throws for eof condition")
(defvar ctoken-table nil)
(defvar ret-nud nil "The instance variable of a recyled closure")
(defun ret-nud () ret-nud)
(defvar fun 'TOP-LEVEL)
(defvar silence -1)
(defvar free-kons nil)

(DEFUN NORMALIZE-READ-ARGS (READ-ARGS)
   #+(or Franz common) (cons (car read-args) (cadr read-args))
  #+Lispm
  (MULTIPLE-VALUE-BIND (STREAM EOF)
		       (SI:DECODE-READ-ARGS READ-ARGS)
    (CONS STREAM EOF))
  #+Maclisp
  (LET ((STREAM (CAR READ-ARGS))
	(EOF (CADR READ-ARGS)))
    ;; apply the correction.
    (COND ((AND (NULL (CDR READ-ARGS))
		(NOT (OR (EQ STREAM T)
			 (SFAP STREAM)
			 (FILEP STREAM))))
	   (SETQ STREAM NIL EOF STREAM)))
    (COND ((EQ STREAM T)
	   (SETQ STREAM TYI))
	  ((EQ STREAM NIL)
	   (IF ^Q (SETQ STREAM INFILE) (SETQ STREAM TYI))))
    (CONS STREAM EOF)))

(DEFUN CGOLREAD (&REST READ-ARGS &AUX STREAM EOFM)
  (SETQ READ-ARGS (NORMALIZE-READ-ARGS READ-ARGS))
  (SETQ STREAM (CAR READ-ARGS)
	EOFM (CDR READ-ARGS))
  ;;gdc - nil is supposed to be an acceptable default, but SUN/Lucid 2.0
  ;; doesn't recognize it, so use *standard-input*
  #+common (if (null stream) (setq stream *standard-input*))
  (LET ((WHICH-OPERATIONS
	 #+LISPM
	 (FUNCALL STREAM ':WHICH-OPERATIONS)
	 #+MACLISP
	 (AND (SFAP STREAM) (SFA-CALL STREAM 'WHICH-OPERATIONS ()))
	 #+common NIL))
    (#-common *CATCH #+common catch 'CGOLERR
      #+MACLISP
      (COND ((MEMQ 'RUBOUT-HANDLER WHICH-OPERATIONS)
	     (SFA-CALL STREAM 'RUBOUT-HANDLER #'TOPLEVEL-PARSE))
	    (T
	     (TOPLEVEL-PARSE STREAM)))
      #+(or franz common) (toplevel-parse stream)
      #+LISPM
      (COND ((MEMQ ':RUBOUT-HANDLER WHICH-OPERATIONS)
	     (FUNCALL STREAM ':RUBOUT-HANDLER '() #'TOPLEVEL-PARSE STREAM))
	    (T
	     (TOPLEVEL-PARSE STREAM))))))

(DEFUN TOPLEVEL-PARSE (STANDARD-INPUT
		       &AUX
		       ;; State variables.
		       (CGOLERR T) TOKEN STRINGNUD RET-NUD
		       (FUN 'TOP-LEVEL) (token-history nil))
  (declare (special standard-input token-history))
   ;; may throw the eof marker here.
  (COND ((EQ (ADVANCE) ')
	 ;; KLUDGE for old CGOL source files.
	 '')
	(T
	 ;;gdc- added to handle initial keyword debugger command in COMMON LISP
	 (if (and (symbolp token) (char= (char (symbol-name token) 0) #\:))
	     (setq token
		   (intern (concatenate 'string
					(subseq (symbol-name token) 1)
					(if (cwhitespacep (ctyipeek)) ""
					    ;;Use (read) instead?
					    (write-to-string (cgoltoken))))
			   'keyword))
	     (progn ;gdc - If a keyword command, don't wait for $
	       (SETQ CGOLERR NIL)
	       (PARSE -1))))))

(DEFUN CGOLERR (MESSAGE LEVEL FATALP)
  (declare (special token-history))
  (COND ((AND FATALP CGOLERR)
	 (#-common *THROW #+common throw 'CGOLERR EOFM))
	(t
	 #+Maclisp
	 (PROGN  (COND ((> LEVEL SILENCE)
			(TERPRI MSGFILES)
			(PRINC MESSAGE msgfiles)
			(princ " IN " msgfiles)
			(princ FUN msgfiles)
			(terpri msgfiles)))
		 (if fatalp (force-rubout standard-input)))
	 #+Franz
	 (error (concat "Error: " message " in " fun))
	 #+common
	 (let ((history (if (> (length token-history) 20)
			    (cons "...." (reverse (subseq token-history 0 20)))
			  (reverse token-history))))
	   (do ((token (cgoltoken) (cgoltoken)))
	       ((or (eql token ') (eql token 'nesl::|;|))))
	   (nesl-error "~%In expression:~{ ~a~}~%~a"
		       history
		       message))
	 #+Lispm
	 (PROGN LEVEL
		(CERROR (NOT FATALP) ;; procedable sometimes.
			NIL ;; Not restartable.
			NIL ;; no condition given, since READ uses (FERROR NIL ...)
			"~A IN ~A"
			MESSAGE FUN)))))


#+Maclisp
(DEFUN FORCE-RUBOUT (stream)
  (COND ((and (sfap stream)
	      (memq 'force-rubout (sfa-call stream 'which-operations NIL)))
	 (SFA-CALL STREAM 'FORCE-RUBOUT ()))
	(T
	 (COND ((AND (FILEP STREAM)
		     (LET ((MODE (STATUS FILEMODE STREAM)))
		       (AND (MEMQ 'FILEPOS (CDR MODE))
			    (MEMQ 'DSK (CAR MODE)))))
		(FILEPOS STREAM (MAX 0 (- (FILEPOS STREAM) 50.)))
		(DO ((J 0 (1+ J))
		     (C))
		    ((> J 100.))
		  (SETQ C (TYI STREAM -1))
		  (OR (= C -1) (= C #^C) (TYO C MSGFILES))
		  )))
	 (DO ()
	     ((= (TYI STREAM -1) -1)
	      (error "End of file while forcing rubout" STREAM))))))

(defun ctyi ()
  #+LISPM
  (LET ((C (FUNCALL STANDARD-INPUT ':TYI)))
    (IF (NULL C) -1 C))
  #-(or Franz LISPM common)
  (tyi standard-input -1)
  #+Franz (tyi standard-input)
  #+common (read-char standard-input nil -1)) ;args are eof-error-p, eof-value

(defun ctyipeek () 
  #-(or Franz LISPM common)(tyipeek nil standard-input -1)
  #+Franz (tyipeek standard-input)
  #+common (peek-char nil standard-input nil -1)
  #+LISPM(let ((c (ctyi)))
	   (cuntyi c)
	   c))
(defun cuntyi (c)
  #+(or Franz Maclisp)
  (untyi c standard-input)
  #+common
  (unread-char c standard-input)
  #+Lispm
  (funcall standard-input ':untyi c))
	 
(defun cgoltyipeek ()(ctyipeek))

;;COMMON LISP uses *readtable* instead of readtable; already special
#-common(declare (special readtable))

(DEFVAR CREAD-READTABLE #-common READTABLE #+common *readtable*)
(defvar creadlist-readtable #-common (makereadtable t)
  #+common (copy-readtable nil))	; totally new readtable
;;;All of these characters are already standard in COMMON LISP
#+franz
(progn 'compile
   (let ((readtable creadlist-readtable))
      (setsyntax #^z 'vcharacter)	; ^Z must be a char
      (setsyntax #^s 'vcharacter)
      (setsyntax #^r 'vcharacter)
      (setsyntax #^f 'vcharacter)
      (setsyntax #^p 'vcharacter)
      (setsyntax '/[  'vcharacter)
      (setsyntax '/] 'vcharacter))
   (let ((readtable cread-readtable))
      (setsyntax #^z 'vcharacter)	; ^Z must be a char
      (setsyntax #^s 'vcharacter)
      (setsyntax #^r 'vcharacter)
      (setsyntax #^f 'vcharacter)
      (setsyntax #^p 'vcharacter)
      (setsyntax '/[ 'vcharacter)
      (setsyntax '/] 'vcharacter)))

#+franz
(defun myzapline ()
   (do ((ch (tyi) (tyi)))
       ((= #\eof ch) (list '|;|))
       (cond ((= ch #\lf) (return nil)))))
	  

(defun cread ()
  (LET ((#-common readtable #+common *READTABLE* CREAD-READTABLE))
    (read standard-input #+common nil eofm)))


;;; Macros and functions used by the tokenizer loop.

(defmacro return-token (c l &optional (quoted-p 'quoted-p) (reversed-p t))
  `(progn ,(if c `(cuntyi ,c))
	  ;;gdc - last arg. added for COMMON LISP
	  (return (make-token ,l ,quoted-p ,reversed-p (or fixnum-p flonum-p)))))

;; The tokenizer is a simple loop with the character TYI'd pushed on the
;; token buffer after a series of special cases are checked.
;; The boolean state variables could be replaced with predicates
;; that look back on what in in the buffer, however the present implementation
;; is highly straightforward.

(defun cgoltoken ()
  (declare (special token-history))
  (first (push
	  (do ((l nil (KONS c l))
	       (c (cskip-whitespace) (ctyi))
	       (temp)
	       (quoted-p nil)
	       (fixnum-p nil)
	       (flonum-p nil)
	       (expt-p nil)
	       (digit-after-expt-p nil)
	       )
	      (nil)
	    (cond ((equal c -1)
		   (if (null l)
		       (cgolerr "EOF encountered inside cgol-exp - CGOLREAD" 2 t)
		       (return-token c l)))
		  (#-common(or (= c #/$) (= c *escape-char*))
			   #+common(or (char= c #\$) (char= c *escape-char*))
			   (if (null l)
			       (return ')
			       (return-token c l)))
		  (#-common(= c #/!) #+common(char= c #\!)
			   (if (null l)
			       (return (cread))
			       (return-token c l)))
		  ((and (char= c #\`) (eql (car nudl) 'neslnud))
			   (if (null l)
			       (return (ctyi))
			       (return-token c l)))
		  (#-common(= c #/?) #+common(char= c #\?)
			   (setq quoted-p t)
			   (setq flonum-p nil)
			   (setq fixnum-p nil)
			   (setq c (ctyi)))
		  (#-common(= c #/") #+common(char= c #\") ; FOR EMACS: " )
			   (if (null l)
			       (let ((x (ctoken-string)))
				 ;; Added conditional for NESL -- GuyB
				 (if (not (eql (car nudl) 'neslnud))
				     (setq ret-nud `',x
					   stringnud #'ret-nud))
				 (return x))
			     (return-token c l)))
		  ((cwhitespacep c)
		   (return-token c l))
		  (#-common(= c #/.) #+common(char= c #\.)
			   (cond ((null l)
				  (if (cdigit-p (ctyipeek))
				      (setq fixnum-p nil flonum-p t)
				      (return #-common '/. #+common '\.)))
				 ((null fixnum-p)
				  (return-token c l t))
				 (t
				  (if fixnum-p (setq flonum-p t))
				  (setq fixnum-p nil))))
		  ((and #-common (or (= c #/E) (= c #/e))
			#+common (or (char= c #\E) (char= c #\e))
			;;gdc -COMMON LISP doesn't require flonum-p (see below)
			;;flonum-p
			(or fixnum-p flonum-p)
			(not expt-p))
		   (let ((p (ctyipeek)))
		     (if (not (or #-common (= p #/+) #+common (char= p #\+)
				  #-common (= p #/-) #+common (char= p #\-)
				  (cdigit-p p)))
			 (return-token c l)))
		   ;;gdc - added for COMMON LISP
		   (setq flonum-p t)
		   (setq expt-p t))
		  ((cdigit-p c)
		   (if (null l)
		       (setq fixnum-p t))
		   (if expt-p (setq digit-after-expt-p t)))
		  ((and #-common (or (= c #/+) (= c #/-))
			#+common (or (char= c #\+) (char= c #\-))
			flonum-p
			expt-p
			(not digit-after-expt-p)
			(cdigit-p (ctyipeek))))
		  ((setq temp (clookup (setq c (CHAR-UPCASE c)) ctoken-table))
		   (if (null l)
		       (return-token nil (KONS c (cfollow-tail (cdr temp))) t nil)
		       (return-token c l)))
		  (t
		   ;;gdc -add to handle 34myop45 as three tokens instead of two
		   (if (or fixnum-p flonum-p) (return-token c l))
		   ;;gdc - could delete next two lines.
		   (setq fixnum-p nil)
		   (setq flonum-p nil))))
	  token-history)))


(defun cwhitespacep (c)
  #-common
  (or (= c #\SP)
      (= c #\CR)
      (= c #\LF)
      (= c #\Tab)
      (= c #\FF)
      (= c #/%))
  #+common (or (member c '(#\Space #\Return #\Linefeed #\Tab #\Page))
	       (eql c *begin-comment-char*)))

(defun cskip-whitespace ()
  (do ((commentp nil)(c))
      (nil)
    (setq c (ctyi))
    (cond ((#-common = #+common eql c
		     (if commentp *end-comment-char* *begin-comment-char*))
	   ;; gdc - c will be -1 for eof
	   (setq commentp (not commentp)))
	  ((cwhitespacep c))
	  ((NOT COMMENTP)
	   (RETURN C)))))


(defun clookup (x y) (assoc x y))

(defun initialize-multi-character-token-table (string)
  (setq ctoken-table
	(mapcar #'list #-common (exploden string)
		#+common (coerce (string string) 'list))))

(defun cfollow-tail (alist)
  ;; this way of recognizing tokens is taken from the original cgol,
  ;; is fast and easy and passes all tokens which are subtokens
  ;; of explicitely defined tokens.
  (IF (NULL ALIST) nil
      (let ((c (CHAR-UPCASE (ctyipeek))))
	(cond ((setq alist (clookup c alist))
	       (ctyi)
	       (KONS c (cfollow-tail (cdr alist))))
	      (t
	       nil)))))

(defmacro with-working-cons (&rest l)
  (cond (#-common (status feature lispm) #+common nil
	 `(let ((default-cons-area working-storage-area))
	    ,@l))
	('else
	 `(progn ,@l))))

(defun puttok (token)
  ;; entry point for defining tokens.
  (with-working-cons
    (let ((l #-common(exploden token) #+common(coerce (string token) 'list)))
      (or (clookup (car l) ctoken-table)
	  (error "token with illegal first character" token))
      (setq ctoken-table (inserttok l ctoken-table)))))

(defun inserttok (tok toktable) 
  (if (null tok)
      toktable
      (let ((st (clookup (car tok) toktable)))
	(cond ((null st)
	       (cons (cons (car tok)
			   (inserttok (cdr tok) nil))
		     toktable))
	      (t
	       (rplacd st (inserttok (cdr tok) (cdr st)))
	       toktable)))))

;;; Added buy GuyB for NESL
(defun cgol-make-string (l)
  (prog1 (coerce (nreverse l) 'string) (reklaim l)))

(defun ctoken-string ()
  ;; this is as in the original cgol, #/? is used to quote
  ;; #/$ or #/? and #/" is used to quote #/".
  (do ((c (ctyi) (ctyi))
       (l nil (KONS c l))
       (fixnum-p nil) (flonum-p nil))
      (NIL)
      (when (not (eql (car nudl) 'neslnud))
	(setq c (char-upcase c)))
      (cond ((or (char= c #\$) (char= c *escape-char*))
	     ;; a little Dwim.
	     ;;gdc - "..." changed to |...| to allow portable quoting of "; "
	     (cgolerr '|tokenizer has inserted missing " before $| 0 nil)
	     (return-token c l nil))
	    ((char= c #\")
	     (if (char= (ctyipeek) #\")
		 (ctyi)
	       ;; Added buy GuyB for NESL
	       ;; (returns a string instead of a token)
	       (if (eql (car nudl) 'neslnud)
		   (return (cgol-make-string l))
		 (return-token nil l nil))))
	    ((and (char= c #\?)
		  (or (char= (ctyipeek) #\$)
		      (char= (ctyipeek) *escape-char*)))
	     (setq c (ctyi))))))

	   
(defun cdigit-p (x)
#-common (not (or (< x #/0)
		  (> x #/9)))
#+common (not (or (char< x #\0)
		  (char> x #\9))))

;; for franz, we lower the case rather than upper case it.
#-(or LISPM common)
(DEFUN CHAR-UPCASE (C)
   #-Franz (IF (AND (>= C #/a) (<= C #/z)) (- C #.(- #/a #/A)) C)
   #+Franz (if (and (>= C #/A) (<= C #/Z)) (+ C #.(- #/a #/A)) C)
  )

(defun make-token  (l do-not-try-as-number-p rp number-p)
  ;; takes the stack of characters and makes a token.
  (if rp (setq l (nreverse l)))
  (prog1
    (if (or do-not-try-as-number-p
	    ;;ok-as-number-p could be removed for both versions.
	    #-common (not (ok-as-number-p l)) #+common (not number-p))
	#-common (implode l)
	#+common (intern (coerce l 'string))
	(let ((ibase cibase))
	  (creadlist l)))
    (reklaim l)
    ))

#+common (defun readlist (list) (read-from-string (coerce list 'string)))
(defun creadlist (l)
  (let ((#+common *readtable* #-common readtable creadlist-readtable))
    (readlist l)))

#-common
(defun ok-as-number-p (l)
  ;; its more efficient to determine the type of
  ;; the token by collecting information in state variables
  ;; as it is read. However we aren't that sure of our book-keeping.
  (numberp (car (let ((errset nil))
		  (errset (creadlist l) nil)))))  ;jkf - was nil

;; Keeping our own free-list is a way to use lists for stacks without the
;; overhead of garbage collection. On the LISPM this should be replaced
;; with a STRING and an INDEX pointer.

(defun kons (kar kdr)
  (if free-kons
      (PROGN
	(rplaca free-kons kar)
	(rplacd (prog1 free-kons (setq free-kons (cdr free-kons)))
		kdr))
      (with-working-cons
	(cons kar kdr))))

(defun reklaim (l)
  (setq free-kons (nconc l free-kons)))


;; Interface functions.
(defun |cgol-#-readmacro| (stream)
  ;; #FOOBAR is a syntax escape to the FOOBAR language.
  (funcall (get-read (if (member (#-common tyipeek #+common peek-char
					   () #-Franz stream)
			       #-common '(#\SP #\CR #\TAB #\FF)
			       #+common '(#\Space #\Return #\Tab (int-char 12))
				 )
			 'CGOL
			 (read stream)))
	   stream))


#-(or Franz common) (defprop cgol cgolread read)
#+Franz (defprop cgol list-cgolread read)
#+common (setf (get 'cgol 'read) #'cgolread)
#-common (defprop rat ratread read)
#+common (setf (get 'rat 'read) 'ratread)

; this is called from a splicing macro, so we want to make sure to listify
; the result. why this isn't done in maclisp is a mystery to me  -jkf
#+(or Franz common)
(defun list-cgolread (stream) (list (cgolread stream)))

(defun get-read (language)
  (if (symbolp language)
      (or (get language 'read)
	  (get-read #-common
		    (error "Undefined language" language 'wrng-type-arg)
		    #+common
		    (error "Undefined language ~s ~a" language 'wrng-type-arg)
		    ))
      (get-read #-common
		(error "Not a language symbol" language 'wrng-type-arg)
		#+common
		(error "Not a language symbol ~s ~a" language 'wrng-type-arg)
		)))


(defvar rat-arithmetic_alist
  '((plus . rat-plus)
    (minus . rat-minus)
    (difference . rat-difference)
    (times . rat-times)
    (float . progn)
    (quotient . rat-quotient)
    (equal . rat-equal)
    (lessp . rat-lessp)
    (greaterp . rat-greaterp)
    (expt . rat-expt)))

(defun ratread (&rest l)
  (let ((arithmetic_alist rat-arithmetic_alist))
    (declare (special arithmetic_alist))
    (apply #'cgolread l)))

#+(or Franz Maclisp)
(defsharp / (ignore-arg)
  (|cgol-#-readmacro| nil))

#+Lispm
(set-syntax-#-macro-char #\ALT
			 #'(LAMBDA (IGNORE-LIST-SO-FAR STREAM)
			     (CGOL-/#-READMACRO STREAM)))
#+common
(set-dispatch-macro-character #\# #\
			      #'(lambda (stream subchar arg)
				       (declare (ignore subchar arg))
				       (|cgol-#-readmacro| stream)))
#+common
(set-dispatch-macro-character #\# *escape-char*
			      #'(lambda (stream subchar arg)
				       (declare (ignore subchar arg))
				       (|cgol-#-readmacro| stream)))
#+common
(set-dispatch-macro-character #\# #\$
			      #'(lambda (stream subchar arg)
				       (declare (ignore subchar arg))
				       (|cgol-#-readmacro| stream)))




;; The problem of invoking CGOL over a whole stream is correctly solved by 
;; pushing and popping a stack of read methods for a stream.
;; However, maclisp and the lisp machine provide special variables READ and READTABLE 
;; for this.

#+(or Lispm common)

(progn 'compile

;; the idea here is to have a readtable such that every single
;; character causes CGOLREAD to be invoked. 

(defvar cgol-invoking-readtable
  (copy-readtable #-common si:initial-readtable #+common nil))
(defvar cgol-invoking-read-char #-common #\SP #+common #\Space
  "Untyi'd by the cgol-invoking-read-macro")

(do ((char 0 (1+ char)))
    ((= char #o200))
  (set-syntax-from-char #-common char #+common (int-char char)
			#-common #/' #+common #\'
			cgol-invoking-readtable))

#-common
(defun cgol-invoking-read-macro (ignore-list-so-far stream)
  (funcall stream ':untyi cgol-invoking-read-char)
  (cgolread stream))
#+common
(defun cgol-invoking-read-macro (stream char)
  (unread-char char stream)
  (cgolread stream))

(do ((char 0 (1+ char)))
    ((= char #o200))
  (if (/= char 3) ; don't change #\^C
      #-common
      (set-syntax-macro-char char
			     (LET-CLOSED ((cgol-invoking-READ-CHAR CHAR))
					 #'cgol-invoking-read-macro)
			     cgol-invoking-readtable)
      #+common
      (set-macro-character (int-char char) #'cgol-invoking-read-macro t
			   cgol-invoking-readtable)))
)

;; for franz, we use the lisp machine idea:
#+Franz
(progn 'compile

(defvar cgol-invoking-readtable (makereadtable nil))
(defvar cgol-invoking-read-char #\sp)

;; bind all characters to call cgol-invoking-read-macro

(let ((#-common readtable #+common *readtable* cgol-invoking-readtable))
   (do ((char 0 (1+ char)))
       ((= char #o200))
       (setsyntax char 'macro `(lambda ()
				  (cgol-invoking-macro ,char)))))

(defun cgol-invoking-macro (ch)
   (untyi ch)	; re eat character
   ((lambda (x)
       ;(print x)
       ;(terpr)
       x)
    (cgolread standard-input)))

); end progn 'compile for franz

#+(or franz common)
(defvar prin1 nil)	; since prin1 has no meaning in franz but is needed


(defvar read-prin1-stack ())

#+franz
(defvar exit-stack ())

(defun cgol-enter (ignore-it)
   #+Franz (progn (push (getd 'exit) exit-stack)
		  (putd 'exit (getd 'cgolexit)))
  (push (cons #+MACLISP READ
	      #+(or Franz LISPM) READTABLE
	      #+common *readtable*
	      PRIN1)
	read-prin1-stack)
  #+MACLISP (SETQ READ #'CGOLREAD)
  #+(or Franz LISPM) (SETQ READTABLE CGOL-INVOKING-READTABLE)
  #+common (setq *readtable* cgol-invoking-readtable))

(defun cgol-exit ()
   #+Franz (progn (putd 'exit (car exit-stack))
		  (pop exit-stack))
   
  (let ((a (pop read-prin1-stack)))
    (if a
	(setq #+MACLISP READ #+(or Franz LISPM) READTABLE
	      #+common *readtable* (CAR A)
	      prin1 (cdr a))
	(warn "APPARENT ATTEMPT TO EXIT FROM CGOL WHEN NOT IN CGOL"))))
(defun exit () (cgolexit))

#+maclisp
(progn 'compile
(defstruct (string-stream sfa conc-name default-pointer)
  string)
(defun string-stream (string-stream com arg)
  (caseq com
    ((tyi)
     (if (string-stream-string) (pop (string-stream-string)) arg))
    ((tyipeek)
     (if (string-stream-string) (car (string-stream-string)) arg))
    ((untyi)
     (push arg (string-stream-string)))
    ((which-operations)
     '(tyi tyipeek untyi))
    (t
     (string-stream string-stream
		    (error (list "unknown command to" 'string-stream)
			   com
			   'wrng-type-arg)
		    arg)))))

(defun funcall-reader-on-string (reader string eof)
  (funcall reader (make-string-stream string (exploden string)) eof))

