(in-package 'nesl-lisp)

(IF (NOT (FBOUNDP 'CGOLTOKEN)) (LOAD "cgtoke.o"))
NIL
(PROCLAIM
    '(SPECIAL CIBASE TOKEN STRINGNUD SYNTAX-NEEDED DRBP FUN DENTYPE
              ISFUN SILENCE IT DEFBP IVARS WHENVAR RESULT BODY NUDL LEDL
              LBPL CNUD CLED CLBP LANGUAGEALIST ARITHMETICALIST))
(PROGN
  'COMPILE
  (SETF (GET 'ADVANCE 'NUD) #'(LAMBDA () (LIST (PROG2 () 'ADVANCE))))
  (DEFUN ADVANCE ()
    (SETQ STRINGNUD NIL)
    (SETQ TOKEN (CGOLTOKEN))
    TOKEN))
(DEFUN VERIFY (DEN) (IF DEN (PROGN (ADVANCE) DEN)))
(PROGN
  'COMPILE
  (SETF (GET 'NUDERR 'NUD) #'(LAMBDA () (LIST (PROG2 () 'NUDERR))))
  (DEFUN NUDERR ()
    (IF (AND (GETDEN LBPL) (NULL (FUNBOUNDP TOKEN)))
        (CGOLERR (CAT TOKEN '| is missing its left argument.|) 2 T)
        ((LAMBDA (OP TP)
           (ADVANCE)
           (LIST 'LAMBDA NIL
                 (LIST 'QUOTE
                       (IF (AND (FUNBOUNDP OP) (CWHITESPACEP TP)
				(NOT (GETDEN LBPL)))
                           (LIST OP (PARSE (OR (GET OP 'RBP) 25))) OP))))
         TOKEN (CGOLTYIPEEK)))))
(PROGN
  'COMPILE
  (SETF (GET 'FUNBOUNDP 'NUD)
        #'(LAMBDA ()
            (LIST (PROG2 () 'FUNBOUNDP) (PROG2 () (PARSE 25)))))
  (DEFUN FUNBOUNDP (X)
    (AND (SYMBOLP X)
         (OR (GET-PROPERTIES (SYMBOL-PLIST X)
                 '(SUBR FSUBR LSUBR EXPR FEXPR LEXPR MACRO *EXPR *FEXPR
                        *LEXPR AUTOLOAD))
             (FBOUNDP X)))))
(PROGN
  'COMPILE
  (SETF (GET 'LEDERR 'NUD) #'(LAMBDA () (LIST (PROG2 () 'LEDERR))))
  (DEFUN LEDERR ()
    (CGOLERR (CAT TOKEN '| is not an operator with a left argument.|) 2
             T)))
(PROGN
  'COMPILE
  (SETF (GET 'GETDEN 'NUD)
        #'(LAMBDA () (LIST (PROG2 () 'GETDEN) (PROG2 () (PARSE 25)))))
  (DEFUN GETDEN (INDL)
    (AND INDL
         (OR (AND (SYMBOLP TOKEN) (GET TOKEN (CAR INDL)))
             (GETDEN (CDR INDL))))))
(PROGN
  'COMPILE
  (SETF (GET 'NUD 'NUD) #'(LAMBDA () (LIST (PROG2 () 'NUD))))
  (DEFUN NUD ()
    (OR (VERIFY (OR STRINGNUD
                    (IF (NUMBERP TOKEN) (LIST 'LAMBDA NIL TOKEN)
                        (GETDEN NUDL))))
        (NUDERR))))
(PROGN
  'COMPILE
  (SETF (GET 'LED 'NUD) #'(LAMBDA () (LIST (PROG2 () 'LED))))
  (DEFUN LED () (OR (VERIFY (GETDEN LEDL)) (LEDERR))))
(PROGN
  'COMPILE
  (SETF (GET 'PARSE 'NUD)
        #'(LAMBDA () (LIST (PROG2 () 'PARSE) (PROG2 () (PARSE 25)))))
  (DEFUN PARSE (RBP)
    (DO ((TRANSLATION (FUNCALL (NUD)) (FUNCALL (LED) TRANSLATION)))
        ((NOT (< RBP (OR (GETDEN LBPL) 0))) TRANSLATION)
      NIL)))
(SETF (GET ' 'LBP) (- 1))
(DEFMACRO CGOL (&REST A)
  (SUBST (LIST 'QUOTE A) 'A '(PROGN (CGOL-ENTER A) NIL)))
(PROGN
  'COMPILE
  (SETF (GET 'CGOLEXIT 'NUD) #'(LAMBDA () (LIST (PROG2 () 'CGOLEXIT))))
  (DEFUN CGOLEXIT () (CGOL-EXIT) NIL))
(SETF (GET 'EXIT 'NUD) #'(LAMBDA () (LIST 'EXIT)))
(DEFUN SPEAK (X)
  ((LAMBDA (LANG)
     (IF LANG (SETQ LANG (CDR LANG))
         (CGOLERR (CAT X '| IS AN UNKNOWN LANGUAGE|) 3 T))
     (SETQ NUDL (CONS (CAR LANG) NUDL))
     (SETQ LEDL (CONS (CADR LANG) LEDL))
     (SETQ LBPL (CONS (CADDR LANG) LBPL))
     NIL)
   (ASSOC X LANGUAGEALIST)))
(PROGN
  'COMPILE
  (SETF (GET 'FORGET 'NUD) #'(LAMBDA () (LIST (PROG2 () 'FORGET))))
  (DEFUN FORGET ()
    (AND (CDR NUDL)
         (PROGN
           (SETQ NUDL (CDR NUDL))
           (SETQ LEDL (CDR LEDL))
           (SETQ LBPL (CDR LBPL))))
    NIL))
(PROGN
  'COMPILE
  (SETF (GET 'RESETLANGUAGE 'NUD)
        #'(LAMBDA () (LIST (PROG2 () 'RESETLANGUAGE))))
  (DEFUN RESETLANGUAGE ()
    (SETQ NUDL '(NUD))
    (SETQ LEDL '(LED))
    (SETQ LBPL '(LBP))
    (SETQ CNUD 'NUD)
    (SETQ CLED 'LED)
    (SETQ CLBP 'LBP)
    (setq *begin-comment-char* #\% *end-comment-char* #\%)
    NIL))
(DEFUN LEARN (X)
  ((LAMBDA (LANG)
     (IF LANG (SETQ LANG (CDR LANG))
         (PROGN
           (SETQ LANG
                 (MAPCAR #'INTERN
                         (LIST (CAT X 'NUD) (CAT X 'LED) (CAT X 'LBP))))
           (SETQ LANGUAGEALIST (CONS (CONS X LANG) LANGUAGEALIST))))
     (SETQ CNUD (CAR LANG))
     (SETQ CLED (CADR LANG))
     (SETQ CLBP (CADDR LANG))
     (LIST 'OR (LIST 'ASSOC (LIST 'QUOTE X) 'LANGUAGEALIST)
           (LIST 'PUSH (LIST 'QUOTE (LIST* X LANG)) 'LANGUAGEALIST)))
   (ASSOC X LANGUAGEALIST)))
(SETF (GET 'RIGHT 'NUD) #'(LAMBDA () (LIST 'PARSE DRBP)))
(SETF (GET 'RIGHTLIST 'NUD) #'(LAMBDA () (LIST 'PARSELIST DRBP ''|,|)))
(SETF (GET 'RIGHTREP 'NUD)
      #'(LAMBDA () (LIST 'PARSELIST DRBP (LIST 'QUOTE FUN))))
(DEFUN DEFFIX (DENTYPE ISFUN FUN DLBP DRBP)
  ((LAMBDA (FORM)
     (IF DLBP
         (SETQ FORM
               (LIST 'PROGN ''COMPILE FORM
                     (LIST 'SETF
                           (LIST 'GET (LIST 'QUOTE FUN)
                                 (LIST 'QUOTE CLBP))
                           (LIST 'QUOTE DLBP)))))
     (IF SYNTAX-NEEDED (EVAL FORM))
     FORM)
   (LIST 'SETF (LIST 'GET (LIST 'QUOTE FUN) (LIST 'QUOTE DENTYPE))
         (LIST 'FUNCTION
               (CONS 'LAMBDA
                     (CONS (IF (EQUAL DENTYPE CLED) '(LEFT))
                           (PROGN (ADVANCE) (DEPROGNIFY (PARSE 0)))))))))
(SETF (GET 'NILFIX 'NUD)
      #'(LAMBDA () (DEFFIX CNUD 'ISN TOKEN NIL NIL)))
(SETF (GET 'PREFIX 'NUD)
      #'(LAMBDA () (DEFFIX CNUD 'ISP TOKEN NIL (ADVANCE))))
(SETF (GET 'SUFFIX 'NUD)
      #'(LAMBDA () (DEFFIX CLED 'ISS TOKEN (ADVANCE) NIL)))
(SETF (GET 'INFIX 'NUD)
      #'(LAMBDA () (DEFFIX CLED 'ISI TOKEN (ADVANCE) TOKEN)))
(SETF (GET 'INFIXR 'NUD)
      #'(LAMBDA () (DEFFIX CLED 'ISI TOKEN (ADVANCE) (- TOKEN 1))))
(SETF (GET 'INFIXD 'NUD)
      #'(LAMBDA () (DEFFIX CLED 'ISI TOKEN (ADVANCE) (ADVANCE))))
(SETF (GET 'INFIXM 'NUD)
      #'(LAMBDA () (DEFFIX CLED 'ISM TOKEN (ADVANCE) TOKEN)))
(SETF (GET 'DELIM 'NUD)
      #'(LAMBDA ()
          ((LAMBDA (FORM) (IF SYNTAX-NEEDED (EVAL FORM)) FORM)
           (CONS 'PROGN
                 (MAPCAR #'(LAMBDA (I)
                               (LIST 'PROGN
                                     (LIST 'SETF
                                      (LIST 'GET (LIST 'QUOTE I)
                                       (LIST 'QUOTE CLBP))
                                      0)
                                     (LIST 'SETF
                                      (LIST 'GET (LIST 'QUOTE I)
                                       (LIST 'QUOTE CLED))
                                      NIL)))
                         (GETVARLIST))))))
(SETF (GET 'IS 'NUD)
      #'(LAMBDA ()
          (CONS ISFUN
                (APPEND (IF (EQUAL DENTYPE CLED) '(LEFT))
                        (LIST (PARSE 25)) (IF DRBP (LIST DRBP))
                        (IF (EQUAL ISFUN 'ISM)
                            (LIST (LIST 'QUOTE FUN)))))))
(DEFUN ISN (FCN) (LIST FCN))
(DEFUN ISS (LEFT FCN) (LIST FCN LEFT))
(DEFUN ISP (FCN RB) (LIST FCN (PARSE RB)))
(DEFUN ISI (LEFT FCN RB) (LIST FCN LEFT (PARSE RB)))
(DEFUN ISM (LEFT FCN RB CONT)
  (CONS FCN (CONS LEFT (PARSELIST RB CONT))))
(PROGN
  'COMPILE
  (SETF (GET 'CHECK 'NUD)
        #'(LAMBDA () (LIST (PROG2 () 'CHECK) (PROG2 () (PARSE 25)))))
  (DEFUN CHECK (DEL)
    (IF (OR (EQUAL TOKEN DEL)
            (AND (NOT (ATOM DEL)) (MEMBER TOKEN DEL)))
        (ADVANCE)
        (CGOLERR (CAT '|missing | DEL '| before | TOKEN '|.|) 0
                 NIL))))
(DEFUN CAT (&REST N)
  (EVAL (LIST* 'CONCATENATE ''STRING (MAPCAR #'(lambda (x)
				       (WRITE-TO-STRING x :escape nil)) N))))
(DEFUN PARSELIST (RB CONT)
  (CONS (PARSE RB)
        (IF (EQ TOKEN CONT) (PROGN (ADVANCE) (PARSELIST RB CONT)))))
(PROGN
  'COMPILE
  (SETF (GET 'GETVARLIST 'NUD)
        #'(LAMBDA () (LIST (PROG2 () 'GETVARLIST))))
  (DEFUN GETVARLIST ()
    (IF (OR (NOT (EQUAL TOKEN '|;|)) STRINGNUD)
        (CONS (PROG2 () TOKEN (ADVANCE))
              (IF (EQUAL TOKEN '|,|) (PROGN (ADVANCE) (GETVARLIST)))))))
(PROGN
  'COMPILE
  (SETF (GET 'GETTOKENS 'NUD)
        #'(LAMBDA () (LIST (PROG2 () 'GETTOKENS))))
  (DEFUN GETTOKENS ()
    (IF (NOT (MEMBER TOKEN '(|)| ] |'|  |;|)))
        (CONS (PROG2 () TOKEN (ADVANCE)) (GETTOKENS)))))
(DEFUN DEPROGNIFY (X)
  (IF (AND (NOT (ATOM X)) (EQUAL (CAR X) 'PROGN)) (CDR X) (LIST X)))
(PROGN
  'COMPILE
  (SETF (GET 'NOTIFY 'NUD)
        #'(LAMBDA () (LIST (PROG2 () 'NOTIFY) (PROG2 () (PARSE 25)))))
  (DEFUN NOTIFY (X)
    (AND (NOT (EQUAL X T))
         (IF (AND (NOT (ATOM X)) (EQUAL (CAR X) 'NOT)) (CADR X)
             (LIST 'NOT X)))))
(PROGN
  'COMPILE
  (SETF (GET 'ORIFY 'NUD)
        #'(LAMBDA () (LIST (PROG2 () 'ORIFY) (PROG2 () (PARSE 25)))))
  (DEFUN ORIFY (X)
    (AND X
         (IF (AND (NOT (ATOM X)) (NULL (CDR X))) (CAR X) (CONS 'OR X)))))
(DEFMACRO LITERAL (&REST X)
  (SUBST (LIST 'QUOTE X) 'X '(MAPC #'(LAMBDA (I) (SET I I)) X)))
(PROGN
  'COMPILE
  (SETF (GET 'ARITH 'NUD)
        #'(LAMBDA () (LIST (PROG2 () 'ARITH) (PROG2 () (PARSE 25)))))
  (DEFUN ARITH (X)
    (IF (SETQ IT (ASSOC X ARITHMETICALIST)) (CDR IT) X)))
(SETF (GET 'DEFINE 'NUD)
      #'(LAMBDA ()
          (PROG (FUN TTYPE ARGTS CODE INSTR LB RB EXPR FORM)
            (SETQ EXPR
                  (IF (MEMBER TOKEN '(EXPR FEXPR LEXPR MACRO))
                      (PROG2 () TOKEN (ADVANCE)) 'EXPR))
            (IF (OR STRINGNUD (EQUAL (CGOLTYIPEEK) (INT-CHAR 40)))
                (PROGN
                  (SETQ ARGTS NIL)
                  (SETQ TTYPE CNUD)
                  (SETQ CODE (LIST 'LIST))
                  (SETQ INSTR (LIST 'PROG2 NIL (LIST 'QUOTE TOKEN))))
                (PROGN
                  (SETQ ARGTS (LIST TOKEN))
                  (ADVANCE)
                  (SETQ TTYPE CLED)
                  (SETQ CODE (LIST 'LIST (LIST 'QUOTE TOKEN)))
                  (SETQ INSTR (LIST 'PROG2 NIL 'LEFT))))
            (SETQ FUN TOKEN)
            (ADVANCE)
            (IF (AND (EQUAL TOKEN '|(|) (NOT STRINGNUD))
                (PROGN
                  (ADVANCE)
                  (SETQ ARGTS
                        (IF (NOT (EQUAL TOKEN '|)|)) (GETVARLIST)))
                  (IF (EQUAL EXPR 'LEXPR)
                      (PROGN
                        (SETQ ARGTS (CONS '&REST ARGTS))
                        (SETQ EXPR 'EXPR)))
                  (CHECK '|)|)
                  (SETQ CODE NIL)
                  (SETQ INSTR NIL))
                (DO ()
                    ((NOT (OR (NOT (OR (EQUAL TOKEN '|;|)
                                    (EQUAL TOKEN '|,|)))
                              STRINGNUD)))
                  (DO () ((NOT STRINGNUD))
                    (SETQ INSTR
                          (APPEND INSTR
                                  (LIST (LIST 'CHECK
                                         (LIST 'QUOTE TOKEN)))))
                    (SETQ FORM
                          (CONS (LIST 'SETF (LIST 'GET TOKEN CLBP) 0)
                                FORM))
                    (ADVANCE))
                  (SETQ CODE (APPEND CODE (LIST INSTR)))
                  (IF (AND (OR (EQUAL TOKEN '|;|) (EQUAL TOKEN '|,|))
                           (NOT STRINGNUD))
                      (SETQ INSTR NIL)
                      (PROGN
                        (SETQ INSTR
                              (LIST 'PROG2 NIL (LIST 'PARSE '|#RBP|)))
                        (SETQ ARGTS (APPEND ARGTS (LIST TOKEN)))
                        (ADVANCE)))))
            (SETQ LB
                  (IF (EQUAL TTYPE CLED)
                      (IF (EQUAL TOKEN '|,|)
                          (PROGN (ADVANCE) (EVAL (PARSE 1))) DEFBP)))
            (SETQ RB
                  (IF (EQUAL TOKEN '|,|)
                      (PROGN (ADVANCE) (EVAL (PARSE 1))) (OR LB DEFBP)))
            (SETQ CODE
                  (SUBST RB '|#RBP|
                         (APPEND CODE (IF INSTR (LIST INSTR)))))
            (CHECK '|;|)
            (IF CODE
                (PROGN
                  (SETQ FORM
                        (CONS 'PROGN
                              (CONS ''COMPILE
                                    (CONS
                                     (LIST 'SETF
                                      (LIST 'GET (LIST 'QUOTE FUN)
                                       (LIST 'QUOTE TTYPE))
                                      (LIST 'FUNCTION
                                       (LIST 'LAMBDA
                                        (IF (EQUAL TTYPE CLED) '(LEFT))
                                        CODE)))
                                     (APPEND
                                      (IF LB
                                       (LIST
                                        (LIST 'SETF
                                         (LIST 'GET (LIST 'QUOTE FUN)
                                          (LIST 'QUOTE CLBP))
                                         (LIST 'QUOTE LB))))
                                      (NREVERSE FORM))))))
                  (IF SYNTAX-NEEDED (EVAL FORM))))
            (IF (NOT (EQUAL TOKEN '))
                (IF (NOT (EQUAL EXPR 'FEXPR))
                    (SETQ FORM
                          (APPEND FORM
                                  (LIST (CONS 'DEFUN
                                         (CONS FUN
                                          (APPEND (LIST ARGTS)
                                           (DEPROGNIFY (PARSE 0))))))))
                    (IF (EQ EXPR 'FEXPR)
                        (SETQ FORM
                              (APPEND FORM
                                      (LIST
                                       (CONS 'DEFMACRO
                                        (CONS FUN
                                         (APPEND
                                          (LIST
                                           (APPEND '(&REST) ARGTS))
                                          (LIST
                                           (LIST 'SUBST
                                            (LIST 'LIST ''QUOTE
                                             (CAR ARGTS))
                                            (LIST 'QUOTE (CAR ARGTS))
                                            (LIST 'QUOTE (PARSE 0)))))))))))))
            (RETURN (IF CODE FORM (CAR FORM))))))
(SETQ DEFBP 25)
(INITIALIZE-MULTI-CHARACTER-TOKEN-TABLE
    '|-+#&'()*,/:;<=>@[\\]^`{?\|}!|)
(DEFMACRO DEFTOK (&REST A)
  (SUBST (LIST 'QUOTE A) 'A '(MAPC #'PUTTOK A)))
(SETF (GET 'NEWTOK 'NUD)
      #'(LAMBDA ()
          ((LAMBDA (FORM) (IF SYNTAX-NEEDED (EVAL FORM)) FORM)
           (CONS 'DEFTOK (GETVARLIST)))))
(SETF (GET '|(| 'NUD) #'(LAMBDA () (PROG2 () (PARSE 0) (CHECK '|)|))))
(PROGN (SETF (GET '|)| 'LBP) 0))
(PROGN
  'COMPILE
  (SETF (GET '|(| 'LED)
        #'(LAMBDA (LEFT)
            (PROG2 ()
                   (CONS LEFT
                         (IF (NOT (EQUAL TOKEN '|)|))
                             (PARSELIST 0 '|,|)))
              (CHECK '|)|))))
  (SETF (GET '|(| 'LBP) '30))
(PROGN (SETF (GET '|,| 'LBP) 0))
(PROGN
  'COMPILE
  (SETF (GET '{ 'LED)
        #'(LAMBDA (LEFT)
            (PROG2 ()
                   (CONS 'APPLY
                         (CONS (LIST 'FUNCTION LEFT)
                               (PARSELIST 0 '|,|)))
              (CHECK '}))))
  (SETF (GET '{ 'LBP) '30))
(PROGN (SETF (GET '} 'LBP) 0))
(SETF (GET '[ 'NUD)
      #'(LAMBDA ()
          (PROG2 ()
                 (IF (NOT (EQUAL TOKEN ']))
                     ((LAMBDA (A)
                        (IF (EQUAL TOKEN '|)|) (LIST 'CIRC A) A))
                      (CONS 'LIST (PARSELIST 0 '|,|))))
            (CHECK '(] |)|)))))
(DEFUN CIRC (X) (PROG2 () X (RPLACD (LAST X) X)))
(PROGN (SETF (GET '] 'LBP) 0))
(PROGN
  'COMPILE
  (SETF (GET '[ 'LED)
        #'(LAMBDA (LEFT)
            (PROG2 ()
                   (IF (EQUAL TOKEN '{)
                       (PROG2 ()
                              (PROGN
                                (ADVANCE)
                                (SUBLIS (LIST (CONS 'A LEFT)
                                         (CONS 'B (PARSE 0)))
                                        '(APPLY #'MAPCAR (CONS #'A B))))
                         (CHECK '}))
                       (IF (OR (AND (ATOM LEFT) (FUNBOUNDP LEFT))
                               (AND (NOT (ATOM LEFT))
				    (EQUAL (CAR LEFT) 'LAMBDA)))
                           (CONS 'MAPCAR
                                 (CONS (LIST 'FUNCTION LEFT)
                                       (PARSELIST 0 '|,|)))
                           (CONS 'AREF (CONS LEFT (PARSELIST 0 '|,|)))))
              (CHECK ']))))
  (SETF (GET '[ 'LBP) '30))
(SETF (GET 'OCT 'NUD)
      #'(LAMBDA ()
          (PROG2 () ((LAMBDA (CIBASE) (CHECK '|(|) (PARSE 0)) 8)
            (CHECK '|)|))))
(SETF (GET '|'| 'NUD)
      #'(LAMBDA () (PROG2 () (ISP 'QUOTE 0) (CHECK '|'|))))
(PROGN (SETF (GET '|'| 'LBP) 0))
(SETF (GET '|#| 'NUD) #'(LAMBDA () (PROG2 () TOKEN (ADVANCE))))
(SETF (GET '= 'NUD) #'(LAMBDA () (EVAL (PARSE 25))))
(SETF (GET '|\\| 'NUD)
      #'(LAMBDA ()
          (PROG2 ()
                 (CONS 'LAMBDA
                       (CONS (PROG2 () (GETVARLIST) (CHECK '|;|))
                             (DEPROGNIFY (PARSE 0))))
            (IF (EQUAL TOKEN '|\\|) (ADVANCE)))))
(PROGN (SETF (GET '|\\| 'LBP) 0))
(SETF (GET 'LET 'NUD)
      #'(LAMBDA ()
          (PROG (VARS ARGTS PACKFLAG)
            (DO () ((MEMBER TOKEN '(|;| IN)))
              (SETQ VARS (APPEND VARS (GETVARLIST)))
              (CHECK '(BE |:=| =))
              (SETQ ARGTS
                    (CONS (IF (EQUAL TOKEN '{)
                              (LIST '&UNP
                                    (PROG2 ()
                                     (PROGN (ADVANCE) (PARSE 0))
                                      (PROGN
                                        (SETQ PACKFLAG T)
                                        (CHECK '}))))
                              (PARSE 1))
                          ARGTS))
              (IF (EQUAL TOKEN '|,|) (ADVANCE)))
            (ADVANCE)
            (RETURN
              (IF PACKFLAG
                  (PROGN
                    (SETQ ARGTS
                          (REVERSE (MAPCAR
                                    #'(LAMBDA (I)
                                        (IF (EQUAL (CAR I) '&UNP)
                                         (CADR I) (LIST 'LIST I)))
                                    ARGTS)))
                    (LIST 'APPLY
                          (LIST 'FUNCTION
                                (CONS 'LAMBDA
                                      (CONS VARS
                                       (DEPROGNIFY (PARSE 0)))))
                          (IF (EQUAL (LENGTH ARGTS) 1) (CAR ARGTS)
                              (CONS 'APPEND ARGTS))))
                  (CONS (CONS 'LAMBDA
                              (CONS VARS (DEPROGNIFY (PARSE 0))))
                        (NREVERSE ARGTS)))))))
(SETF (GET 'PROG 'NUD)
      #'(LAMBDA ()
          (CONS 'PROG
                (CONS (PROG2 () (GETVARLIST) (CHECK '|;|))
                      (DEPROGNIFY (PARSE 0))))))
(SETF (GET 'NEW 'NUD)
      #'(LAMBDA ()
          (CONS 'PROG
                (CONS (PROG2 () (GETVARLIST) (CHECK '|;|))
                      ((LAMBDA (X)
                         ((LAMBDA (Y)
                            (RPLACA Y (LIST 'RETURN (CAR Y)))
                            X)
                          (LAST X)))
                       (DEPROGNIFY (PARSE 0)))))))
(SETF (GET 'SPECIAL 'NUD)
      #'(LAMBDA ()
          (LIST 'PROCLAIM (LIST 'QUOTE (CONS 'SPECIAL (GETVARLIST))))))
(SETF (GET 'LITERAL 'NUD)
      #'(LAMBDA () (CONS 'LITERAL (PARSELIST 1 '|,|))))
(DEFMACRO CGOLARRAY (&REST X)
  (SUBST (LIST 'QUOTE X) 'X
         '(IF (EQUAL TOKEN '|(|)
              (PROG2 ()
                     (PROGN
                       (ADVANCE)
                       (CONS (CAR X)
                             (MAPCAR #'(LAMBDA (Y) (LIST '1- Y))
                                     (PARSELIST 0 '|,|))))
                (CHECK '|)|))
              (IF (EQUAL TOKEN '|:=|)
                  (PROGN (ADVANCE) (LIST 'FILL (CAR X) (PARSE 1)))
                  (CAR X)))))
(SETF (GET 'ARRAY 'NUD)
      #'(LAMBDA ()
          (IF (MEMBER TOKEN '(|(| { [)) 'MAKE-ARRAY
              ((LAMBDA (NAMES)
                 ((LAMBDA (OLDNUDS)
                    (PROG2 ()
                           (PROGN
                             (MAPC #'(LAMBDA (NAME)
                                       (SETF (GET NAME CNUD)
                                        (LIST 'LAMBDA NIL
                                         (LIST 'CGOLARRAY NAME))))
                                   NAMES)
                             (IF (EQUAL TOKEN '|(|)
                                 (PROGN
                                   (ADVANCE)
                                   ((LAMBDA (DIMS)
                                      (CHECK '|)|)
                                      ((LAMBDA (TTYPE)
                                         ((LAMBDA (SOURCE)
                                            (IF (EQUAL TOKEN '|;|)
                                             (PROGN
                                               (ADVANCE)
                                               (CONS
                                                (CONS 'LAMBDA
                                                 (CONS NAMES
                                                  (DEPROGNIFY
                                                   (PARSE 0))))
                                                (MAPCAR
                                                 #'(LAMBDA (NAME)
                                                     (CONS 'MAKE-ARRAY
                                                      (CONS DIMS
                                                       (CONS
                                                        '|:ELEMENT-TYPE|
                                                        (CONS TTYPE
                                                         (IF SOURCE
                                                          (LIST
                                                           '|:INITIAL-CONTENTS|
                                                           SOURCE)))))))
                                                 NAMES)))
                                             (CONS 'PROG2
                                              (CONS NIL
                                               (CONS
                                                (LIST 'QUOTE
                                                 (CAR NAMES))
                                                (MAPCAN
                                                 #'(LAMBDA (NAME)
                                                     (CONS
                                                      (LIST 'SETF
                                                       (LIST 'GET
                                                        (LIST 'QUOTE
                                                         NAME)
                                                        (LIST 'QUOTE
                                                         'NUD))
                                                       (LIST 'QUOTE
                                                        (GET NAME 'NUD)))
                                                      (LIST 'SETQ NAME
                                                       (CONS
                                                        'MAKE-ARRAY
                                                        (CONS DIMS
                                                         (CONS
                                                          '|:ELEMENT-TYPE|
                                                          (CONS TTYPE
                                                           (IF SOURCE
                                                            (LIST
                                                             '|:INITIAL-CONTENTS|
                                                             SOURCE)))))))))
                                                 NAMES))))))
                                          (IF (MEMBER TOKEN '(|:=| =))
                                           (PROGN (ADVANCE) (PARSE 1)))))
                                       (IF
                                        (MEMBER TOKEN
                                         '(FIXNUM FLOAT NIL T))
                                        (PROG2 () TOKEN (ADVANCE)) T)))
                                    (PARSELIST 0 '|,|)))
                                 (IF (EQUAL TOKEN '|;|)
                                     (PROGN (ADVANCE) (PARSE 0)))))
                      (MAPC #'(LAMBDA (NAME OLDNUD)
                                (IF OLDNUD
                                    (SETF (GET NAME CNUD) OLDNUD)
                                    (REMPROP NAME CNUD)))
                            NAMES OLDNUDS)))
                  (MAPCAR #'(LAMBDA (NAME) (GET NAME CNUD)) NAMES)))
               (GETVARLIST)))))
(SETF (GET 'DIM 'NUD)
      #'(LAMBDA () (LIST 'ARRAY-DIMENSIONS (PARSE 25))))
(SETF (GET 'EVAL 'RBP) 1)
(PROGN
  'COMPILE
  (SETF (GET '|;| 'LED) #'(LAMBDA (LEFT) (ISM LEFT 'PROGN 1 '|;|)))
  (SETF (GET '|;| 'LBP) '1))
(PROGN
  'COMPILE
  (SETF (GET '& 'LED)
        #'(LAMBDA (LEFT) (LIST 'PROG2 NIL LEFT (PARSE 0))))
  (SETF (GET '& 'LBP) '1))
(SETF (GET 'IF 'NUD)
      #'(LAMBDA ()
          (APPEND (LIST 'IF)
                  (CONS (PARSE 2)
                        (PROGN (CHECK 'THEN) (LIST (PARSE 2))))
                  (IF (EQ TOKEN 'ELSE)
                      (PROGN (ADVANCE) (LIST (PARSE 2)))))))
(PROGN (SETF (GET 'THEN 'LBP) 0))
(PROGN (SETF (GET 'ELSE 'LBP) 0))
(SETF (GET 'RETURN 'RBP) 1)
(SETF (GET 'GO 'RBP) 1)
(SETF (GET 'WHILE 'NUD)
      #'(LAMBDA ()
          (CONS 'DO
                (CONS NIL
                      (CONS (LIST (NOTIFY (PARSE 2)))
                            (PROGN (CHECK 'DO) (DEPROGNIFY (PARSE 2))))))))
(SETF (GET 'REPEAT 'NUD)
      #'(LAMBDA ()
          (LIST 'DO NIL
                (LIST (CONS 'PROG2
                            (APPEND (DEPROGNIFY (PARSE 2))
                                    (DEPROGNIFY
                                     (PROGN (CHECK 'UNTIL) (PARSE 2)))))))))
(PROGN (SETF (GET 'DO 'LBP) 0))
(SETF (GET 'FOR 'NUD)
      #'(LAMBDA ()
          (PROG (PARS ARGTS INON FCN BODY)
            (SETQ PARS (LIST TOKEN))
            (SETQ INON (ADVANCE))
            (ADVANCE)
            (SETQ FCN
                  (ASSOC INON
                         '((IN (DO MAPC) (COLLECT MAPCAR)
                               (COALESCE MAPCAN))
                           (ON (DO MAPL) (COLLECT MAPLIST)
                               (COALESCE MAPCON)))))
            (IF FCN (SETQ FCN (CDR FCN))
                (CGOLERR (CAT INON '| FOUND WHERE IN OR ON EXPECTED|) 2
                         T))
            (SETQ ARGTS (LIST (PARSE 1)))
            (DO () ((NOT (EQ TOKEN '|,|)))
              (SETQ PARS (CONS (ADVANCE) PARS))
              (ADVANCE)
              (CHECK INON)
              (SETQ ARGTS (CONS (PARSE 1) ARGTS)))
            (SETQ FCN (ASSOC TOKEN FCN))
            (IF FCN (SETQ FCN (CADR FCN))
                (CGOLERR (CAT TOKEN
                              '| FOUND WHERE DO, COLLECT OR COALESCE EXPECTED|)
                         2 T))
            (ADVANCE)
            (SETQ ARGTS (NREVERSE ARGTS))
            (SETQ PARS (NREVERSE PARS))
            (SETQ BODY (PARSE 1))
            (RETURN
              (IF (AND (EQUAL FCN 'MAPC)
                       (EVERY #'(LAMBDA (X)
                                  (AND (NOT (ATOM X))
                                       (EQUAL (CAR X) 'TO)))
                              ARGTS))
                  (CONS 'DO
                        (CONS (MAPCAR #'(LAMBDA (P A)
                                          (LIST P (CADR A)
                                           (IF (EQUAL (CADDDR A) 1)
                                            (LIST '1+ P)
                                            (LIST '+ P (CADDDR A)))))
                                      PARS ARGTS)
                              (CONS (LIST
                                     (ORIFY
                                      (MAPCAR
                                       #'(LAMBDA (P A)
                                           (LIST '> P (CADDR A)))
                                       PARS ARGTS)))
                                    (DEPROGNIFY BODY))))
                  (CONS FCN
                        (CONS (LIST 'FUNCTION
                                    (IF
                                     (AND (EQUAL (CDR BODY) PARS)
                                      (ATOM (CAR BODY)))
                                     (CAR BODY)
                                     (LIST 'LAMBDA PARS BODY)))
                              ARGTS)))))))
(PROGN
  (PROGN (SETF (GET 'IN 'LBP) 0))
  (PROGN (SETF (GET 'ON 'LBP) 0))
  (PROGN (SETF (GET 'COLLECT 'LBP) 0))
  (PROGN (SETF (GET 'COALESCE 'LBP) 0)))
(SETF (GET 'ITER 'NUD)
      #'(LAMBDA ()
          (PROG (IVARS WHENVAR RESULT BODY)
            (DO ()
                ((NOT (SETQ IT
                            (ASSOC TOKEN
                                   '((FOR
                                      (SETQ IVARS
                                       (CONS
                                        (CONS TOKEN
                                         (IF (EQUAL (ADVANCE) '|:=|)
                                          (CONS
                                           (PROGN
                                             (ADVANCE)
                                             (SETQ IT (PARSE 2)))
                                           (IF (EQUAL TOKEN 'STEP)
                                            (LIST
                                             (IF
                                              (EQUAL (ADVANCE) 'DITTO)
                                              (PROGN (ADVANCE) IT)
                                              (PARSE 2)))))))
                                        IVARS)))
                                     (WHEN (SETQ WHENVAR (PARSE 2)))
                                     (UNTIL (SETQ WHENVAR (PARSE 2)))
                                     (WHILE
                                      (SETQ WHENVAR
                                       (LIST 'NOT (PARSE 2))))
                                     (RETURN (SETQ RESULT (PARSE 2)))
                                     (DO (SETQ BODY (PARSE 2))))))))
              (ADVANCE)
              (EVAL (CADR IT)))
            (IF (NOT (OR IVARS WHENVAR RESULT BODY))
                (SETQ BODY (PARSE 2)))
            (RETURN
              (APPEND (LIST 'DO (NREVERSE IVARS) (LIST WHENVAR RESULT))
                      (IF (AND (NOT (ATOM BODY))
                               (EQ (CAR BODY) 'PROGN))
                          (CDR BODY) (LIST BODY)))))))
(PROGN
  (SETF (GET 'FOR 'LBP) 0)
  (SETF (GET 'WHEN 'LBP) 0)
  (SETF (GET 'UNTIL 'LBP) 0)
  (SETF (GET 'WHILE 'LBP) 0)
  (SETF (GET 'STEP 'LBP) 0)
  (SETF (GET 'RETURN 'LBP) 0))
(PROGN
  'COMPILE
  (SETF (GET 'TO 'LED)
        #'(LAMBDA (LEFT)
            (CONS 'TO
                  (CONS LEFT
                        (CONS (PARSE 18)
                              (LIST (IF (EQUAL TOKEN 'BY)
                                     (PROGN (ADVANCE) (PARSE 18)) 1)))))))
  (SETF (GET 'TO 'LBP) '18))
(PROGN (SETF (GET 'BY 'LBP) 0))
(DEFUN TO (AA B C)
  (IF (> AA B) NIL
      (PROG (X)
        (RETURN
          (PROG2 () (SETQ X (LIST AA))
            (DO () ((< B (SETQ AA (+ AA C))))
              (SETQ X (CDR (RPLACD X (LIST AA))))))))))
(PROGN
  'COMPILE
  (SETF (GET 'LOTSOF 'LED)
        #'(LAMBDA (LEFT)
            (LIST 'DO '*I LEFT '(- *I 1) '(NOT (> *I 0)) (PARSE 1))))
  (SETF (GET 'LOTSOF 'LBP) '19))
(DEFTOK |:=|)
(SETF (GET 'CGOLPRINT 'NUD) '(LAMBDA () (LIST 'CGOLPRINT (PARSE 1))))
(SETF (GET 'CGOLPRIN1 'NUD) '(LAMBDA () (LIST 'CGOLPRIN1 (PARSE 1))))
(PROGN
  'COMPILE
  (SETF (GET '|:=| 'LED)
        #'(LAMBDA (LEFT)
            (IF (ATOM LEFT) (ISI LEFT 'SETQ 1)
                (IF (EQ (CAR LEFT) 'GET)
                    (LIST 'SETF (LIST 'GET (CADR LEFT) (CADDR LEFT))
                          (PARSE 1))
                    (IF (SETQ IT (GET (CAR LEFT) 'STOREFORM))
                        ((LAMBDA (X)
                           (SUBLIS (LIST (CONS 'LEFT (CADR LEFT))
                                    (CONS 'RIGHT (PARSE 1)))
                                   X))
                         IT)
                        (ISI LEFT 'SETF 1))))))
  (SETF (GET '|:=| 'LBP) '25))
(PROGN
  (SETF (GET 'CAR 'STOREFORM) '(RPLACA LEFT RIGHT))
  (SETF (GET 'CDR 'STOREFORM) '(RPLACD LEFT RIGHT))
  (SETF (GET 'SYMBOL-PLIST 'STOREFORM)
        '(SETF (SYMBOL-PLIST LEFT) RIGHT)))
(PROGN
  'COMPILE
  (SETF (GET 'OF 'LED) #'(LAMBDA (LEFT) (LIST 'GET (PARSE 25) LEFT)))
  (SETF (GET 'OF 'LBP) '26))
(PROGN
  'COMPILE
  (SETF (GET 'OFQ 'LED)
        #'(LAMBDA (LEFT) (LIST 'GET (PARSE 25) (LIST 'QUOTE LEFT))))
  (SETF (GET 'OFQ 'LBP) '26))
(SETF (GET 'NOT 'RBP) 9)
(PROGN
  'COMPILE
  (SETF (GET 'NOT 'LED)
        #'(LAMBDA (LEFT) (LIST 'NOT (FUNCALL (LED) LEFT))))
  (SETF (GET 'NOT 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET 'AND 'LED) #'(LAMBDA (LEFT) (ISM LEFT 'AND 8 'AND)))
  (SETF (GET 'AND 'LBP) '8))
(PROGN
  'COMPILE
  (SETF (GET 'OR 'LED) #'(LAMBDA (LEFT) (ISM LEFT 'OR 7 'OR)))
  (SETF (GET 'OR 'LBP) '7))
(PROGN
  (DEFTOK |=#|)
  (DEFTOK =$)
  (DEFTOK |<#|)
  (DEFTOK |>#|)
  (DEFTOK <$)
  (DEFTOK >$)
  (DEFTOK <=)
  (DEFTOK >=))
(PROGN
  'COMPILE
  (SETF (GET '= 'LED) #'(LAMBDA (LEFT) (ISI LEFT (ARITH 'EQUAL) 10)))
  (SETF (GET '= 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET 'NE 'LED)
        #'(LAMBDA (LEFT) (LIST 'NOT (ISI LEFT (ARITH 'EQUAL) 10))))
  (SETF (GET 'NE 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET 'EQ 'LED) #'(LAMBDA (LEFT) (ISI LEFT 'EQ 10)))
  (SETF (GET 'EQ 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET '< 'LED) #'(LAMBDA (LEFT) (ISM LEFT (ARITH '<) 10 '<)))
  (SETF (GET '< 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET '> 'LED) #'(LAMBDA (LEFT) (ISM LEFT (ARITH '>) 10 '>)))
  (SETF (GET '> 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET '|=#| 'LED) #'(LAMBDA (LEFT) (ISI LEFT '= 10)))
  (SETF (GET '|=#| 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET '=$ 'LED) #'(LAMBDA (LEFT) (ISI LEFT '= 10)))
  (SETF (GET '=$ 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET '|<#| 'LED) #'(LAMBDA (LEFT) (ISI LEFT '< 10)))
  (SETF (GET '|<#| 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET '|>#| 'LED) #'(LAMBDA (LEFT) (ISI LEFT '> 10)))
  (SETF (GET '|>#| 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET '<$ 'LED) #'(LAMBDA (LEFT) (ISI LEFT '< 10)))
  (SETF (GET '<$ 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET '>$ 'LED) #'(LAMBDA (LEFT) (ISI LEFT '> 10)))
  (SETF (GET '>$ 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET '<= 'LED)
        #'(LAMBDA (LEFT) (LIST 'NOT (ISI LEFT (ARITH '>) 10))))
  (SETF (GET '<= 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET '>= 'LED)
        #'(LAMBDA (LEFT) (LIST 'NOT (ISI LEFT (ARITH '<) 10))))
  (SETF (GET '>= 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET '|\|| 'LED)
        #'(LAMBDA (LEFT)
            (LIST (ARITH 'ZEROP) (LIST (ARITH 'REM) (PARSE 10) LEFT))))
  (SETF (GET '|\|| 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET 'ISIN 'LED) #'(LAMBDA (LEFT) (ISI LEFT 'MEMBER 10)))
  (SETF (GET 'ISIN 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET 'ISATOM 'LED) #'(LAMBDA (LEFT) (ISS LEFT 'ATOM)))
  (SETF (GET 'ISATOM 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET 'ISNUM 'LED) #'(LAMBDA (LEFT) (ISS LEFT 'NUMBERP)))
  (SETF (GET 'ISNUM 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET 'EXISTS 'LED) #'(LAMBDA (LEFT) (LIST 'SETQ 'IT LEFT)))
  (SETF (GET 'EXISTS 'LBP) '10))
(SETF (GET 'NULL 'RBP) 10)
(PROGN
  'COMPILE
  (SETF (GET '|.| 'LED) #'(LAMBDA (LEFT) (ISI LEFT 'CONS 14)))
  (SETF (GET '|.| 'LBP) '15))
(PROGN
  'COMPILE
  (SETF (GET '@ 'LED) #'(LAMBDA (LEFT) (ISM LEFT 'APPEND 15 '@)))
  (SETF (GET '@ 'LBP) '15))
(SETF (GET '{ 'NUD)
      #'(LAMBDA ()
          (PROG2 ()
                 (CONS 'GATHER
                       (IF (NOT (EQUAL TOKEN '})) (PARSELIST 0 '|,|)))
            (CHECK '}))))
(PROGN
  'COMPILE
  (SETF (GET ' 'LED) #'(LAMBDA (LEFT) (ISM LEFT 'UNION 16 ')))
  (SETF (GET ' 'LBP) '16))
(PROGN
  'COMPILE
  (SETF (GET ' 'LED) #'(LAMBDA (LEFT) (ISM LEFT 'INTERSECTION 16 ')))
  (SETF (GET ' 'LBP) '16))
(SETF (GET '~ 'NUD) #'(LAMBDA () (ISP 'SET-DIFFERENCE 16)))
(PROGN
  'COMPILE
  (SETF (GET '~ 'LED)
        #'(LAMBDA (LEFT) (ISM LEFT 'SET-DIFFERENCE 16 '~)))
  (SETF (GET '~ 'LBP) '16))
(PROGN
  'COMPILE
  (SETF (GET ' 'LED) #'(LAMBDA (LEFT) (ISM LEFT 'MEMBER 10 ')))
  (SETF (GET ' 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET ' 'LED) #'(LAMBDA (LEFT) (ISM LEFT 'SUBSETP 10 ')))
  (SETF (GET ' 'LBP) '10))
(PROGN
  'COMPILE
  (SETF (GET '^ 'LED) #'(LAMBDA (LEFT) (ISM LEFT 'CAT 18 '^)))
  (SETF (GET '^ 'LBP) '18))
(PROGN
  'COMPILE
  (SETF (GET 'CAT 'LED) #'(LAMBDA (LEFT) (ISM LEFT 'CAT 18 'CAT)))
  (SETF (GET 'CAT 'LBP) '18))
(SETF (GET '|\|| 'NUD)
      #'(LAMBDA () (PROG2 () (ISP (ARITH 'ABS) 19) (CHECK '|\||))))
(SETF (GET '+ 'NUD)
      #'(LAMBDA ()
          (IF (MEMBER TOKEN '(|(| { [)) (ARITH '+) (PARSE 20))))
(PROGN
  'COMPILE
  (SETF (GET '+ 'LED) #'(LAMBDA (LEFT) (ISM LEFT (ARITH '+) 20 '+)))
  (SETF (GET '+ 'LBP) '20))
(PROGN
  'COMPILE
  (SETF (GET '- 'LED) #'(LAMBDA (LEFT) (ISM LEFT (ARITH '-) 20 '-)))
  (SETF (GET '- 'LBP) '20))
(SETF (GET '- 'NUD) #'(LAMBDA () (ISP (ARITH '-) 20)))
(SETF (GET '* 'NUD)
      #'(LAMBDA () (IF (MEMBER TOKEN '(|(| [ {)) (ARITH '*) '*)))
(PROGN
  'COMPILE
  (SETF (GET '* 'LED) #'(LAMBDA (LEFT) (ISM LEFT (ARITH '*) 21 '*)))
  (SETF (GET '* 'LBP) '21))
(PROGN
  'COMPILE
  (SETF (GET '/ 'LED)
        #'(LAMBDA (LEFT)
            (LIST (ARITH '/) LEFT (LIST (ARITH 'FLOAT) (PARSE 21)))))
  (SETF (GET '/ 'LBP) '21))
(DEFTOK |:|)
(PROGN
  'COMPILE
  (SETF (GET '|:| 'LED)
        #'(LAMBDA (LEFT) (ISM LEFT (ARITH '/) 21 '|:|)))
  (SETF (GET '|:| 'LBP) '21))
(PROGN
  'COMPILE
  (SETF (GET 'REM 'LED) #'(LAMBDA (LEFT) (ISI LEFT (ARITH 'REM) 21)))
  (SETF (GET 'REM 'LBP) '21))
(PROGN
  'COMPILE
  (SETF (GET 'MOD 'LED) #'(LAMBDA (LEFT) (ISI LEFT (ARITH 'MOD) 21)))
  (SETF (GET 'MOD 'LBP) '21))
(DEFTOK **)
(PROGN
  'COMPILE
  (SETF (GET '** 'LED) #'(LAMBDA (LEFT) (ISI LEFT (ARITH 'EXPT) 21)))
  (SETF (GET '** 'LBP) '22))
(PROGN
  (DEFTOK |+#|)
  (DEFTOK |-#|)
  (DEFTOK |*#|)
  (DEFTOK |/#|)
  (DEFTOK |\\\\|))
(PROGN
  'COMPILE
  (SETF (GET '|+#| 'LED) #'(LAMBDA (LEFT) (ISM LEFT '+ 20 '|+#|)))
  (SETF (GET '|+#| 'LBP) '20))
(PROGN
  'COMPILE
  (SETF (GET '|-#| 'LED) #'(LAMBDA (LEFT) (ISM LEFT '- 20 '|-#|)))
  (SETF (GET '|-#| 'LBP) '20))
(PROGN
  'COMPILE
  (SETF (GET '|*#| 'LED) #'(LAMBDA (LEFT) (ISM LEFT '* 21 '|*#|)))
  (SETF (GET '|*#| 'LBP) '21))
(PROGN
  'COMPILE
  (SETF (GET '|/#| 'LED) #'(LAMBDA (LEFT) (ISM LEFT '/ 21 '|/#|)))
  (SETF (GET '|/#| 'LBP) '21))
(PROGN
  'COMPILE
  (SETF (GET '|\\\\| 'LED) #'(LAMBDA (LEFT) (ISI LEFT 'MOD 19)))
  (SETF (GET '|\\\\| 'LBP) '19))
(PROGN (DEFTOK +$) (DEFTOK -$) (DEFTOK *$) (DEFTOK /$))
(PROGN
  'COMPILE
  (SETF (GET '+$ 'LED) #'(LAMBDA (LEFT) (ISM LEFT '+$ 20 '+$)))
  (SETF (GET '+$ 'LBP) '20))
(PROGN
  'COMPILE
  (SETF (GET '-$ 'LED) #'(LAMBDA (LEFT) (ISM LEFT '-$ 20 '-$)))
  (SETF (GET '-$ 'LBP) '20))
(PROGN
  'COMPILE
  (SETF (GET '*$ 'LED) #'(LAMBDA (LEFT) (ISM LEFT '*$ 21 '*$)))
  (SETF (GET '*$ 'LBP) '21))
(PROGN
  'COMPILE
  (SETF (GET '/$ 'LED) #'(LAMBDA (LEFT) (ISM LEFT '/$ 21 '/$)))
  (SETF (GET '/$ 'LBP) '21))
(PROGN
;; The following 4 lines were commented out by GuyB.
;;  (DEFTOK |:N:|)
;;  (DEFTOK |:A:|)
;;  (DEFTOK |:V:|)
;;  (DEFTOK |:X:|)
  (DEFTOK |:^:|))
(SETF (GET '|:N:| 'NUD) #'(LAMBDA () (LIST 'BOOLE 12 0 (PARSE 21))))
(PROGN
  'COMPILE
  (SETF (GET '|:A:| 'LED)
        #'(LAMBDA (LEFT)
            (CONS 'BOOLE (CONS 1 (CONS LEFT (PARSELIST 21 '|:A:|))))))
  (SETF (GET '|:A:| 'LBP) '21))
(PROGN
  'COMPILE
  (SETF (GET '|:V:| 'LED)
        #'(LAMBDA (LEFT)
            (CONS 'BOOLE (CONS 7 (CONS LEFT (PARSELIST 20 '|:V:|))))))
  (SETF (GET '|:V:| 'LBP) '20))
(PROGN
  'COMPILE
  (SETF (GET '|:X:| 'LED)
        #'(LAMBDA (LEFT)
            (CONS 'BOOLE (CONS 6 (CONS LEFT (PARSELIST 20 '|:X:|))))))
  (SETF (GET '|:X:| 'LBP) '20))
(PROGN
  'COMPILE
  (SETF (GET '|:^:| 'LED) #'(LAMBDA (LEFT) (ISI LEFT 'ASH 22)))
  (SETF (GET '|:^:| 'LBP) '22))
(SETF (GET 'PRINT 'RBP) 2)
(SETF (GET 'PRINC 'RBP) 2)
(SETF (GET 'PRIN1 'RBP) 2)
(SETF (GET 'WRITE 'NUD)
      #'(LAMBDA ()
          (SUBST (CONS 'LIST (PARSELIST 2 '|,|)) 'X
                 '(PROGN (TERPRI) (MAPC #'PRINC X) (PRINC '| |)))))
(SETF (GET 'NEWLINE 'NUD) #'(LAMBDA () (ISN 'TERPRI)))
(SETF (GET 'UREAD 'NUD) #'(LAMBDA () (CONS 'UREAD (GETTOKENS))))
(SETF (GET 'UWRITE 'NUD) #'(LAMBDA () (CONS 'UWRITE (GETTOKENS))))
(SETF (GET 'UFILE 'NUD) #'(LAMBDA () (CONS 'UFILE (GETTOKENS))))
(SETF (GET 'LOAD 'NUD)
      #'(LAMBDA ()
          (CONS 'LOAD (MAPCAR #'STRING-DOWNCASE (GETTOKENS)))))
(IF (NOT (MEMBER :CGOL *FEATURES*))
    (PROGN
      (SETQ SYNTAX-NEEDED T)
      (SETQ SILENCE (- 1))
      (SETQ DEFBP 25)
      (SETQ NUDL '(NUD))
      (SETQ LEDL '(LED))
      (SETQ LBPL '(LBP))
      (SETQ CNUD 'NUD)
      (SETQ CLED 'LED)
      (SETQ CLBP 'LBP)
      (SETQ FUN 'TOP-LEVEL)
      (SETQ LANGUAGEALIST NIL)
      (SETQ ARITHMETICALIST NIL)
      (PUSH :CGOL *FEATURES*)))
