(in-package 'nesl-lisp)

(defun execute-shell-line (command-string)
  #+lucid
  (lcl::shell command-string)
  #+(or allegro excl)
  (system::run-shell-command command-string)
  #-(or lucid allegro excl)
  (error "The NESL/VCODE interface has not been implemented ~
          for the Lisp you are using."))

(let* ((root-directory *nesl-path*)
       #+(or allegro excl) (obj-tailer ".fasl")
       #+lucid             (obj-tailer ".sbin")
       #+cmu               (obj-tailer ".f")
       (src-dir (concatenate 'string root-directory "/src/"))
       (obj-dir (concatenate 'string root-directory "/bin/")))
  (flet ((comp-file (name &key needs)
	   (let ((src-file (concatenate 'string src-dir name ".lisp"))
		 (obj-file (concatenate 'string obj-dir name obj-tailer)))
	     (when (not (probe-file src-file))
		   (error "No source file ~a." src-file))
	     (when (or (not (probe-file obj-file))
		       (< (file-write-date obj-file)
			  (file-write-date src-file)))
	       (when needs (load needs))
	       (compile-file src-file :output-file obj-file))))
	 (load-file (name)
	    (load (concatenate 'string obj-dir name obj-tailer))))
    (comp-file "packages")
    (load-file "packages")
    (comp-file "funspec")
    (load-file "funspec")
    (comp-file "free")
    (comp-file "type")
    (comp-file "type-check")
    (comp-file "trans")
    (comp-file "ptrans")
    (comp-file "output")
    (comp-file "run-vcode")
    (comp-file "vcode-lisp")
    (comp-file "defop")
    (comp-file "read-eval-print")
    (comp-file "cgtoke")
    (comp-file "cgol-cl")
    (load-file "cgtoke")
    (load-file "cgol-cl")
    (comp-file "cnesl")

    (when (probe-file "vcode/Makefile")
       (format t "~%; Compiling CVL and VCODE~%~%")
       (execute-shell-line (format nil "cd ~avcode; make" *nesl-path*)))
    ))

