(in-package 'nesl-lisp)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; THE FOLLOWING VARIABLE NEEDS TO BE         ;;;;
;;;; CHANGED DEPENDING ON YOUR SYSTEM.          ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; The directory in which this file is located.
(defparameter *NESL-PATH* 
  "/usr/foo/nesl/")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; THE FOLLOWING TWO VARIABLE MIGHT NEED TO   ;;;;
;;;; BE CHANGED.                                ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Name of the directory of the vcode interpreter.
;; By default this is the vcode/bin/ subdirectory of NESL-PATH.
(defparameter *VCODE-INTERPRETER-DIR*
  (concatenate 'string *NESL-PATH* "vcode/vinterp/"))

;; Directory where the vcode files are written to.
;; It must be both readable and writable by all users of NESL.
(defparameter *VCODE-TEMP-DIRECTORY* 
  "/tmp/")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; THE REST OF THIS FILE SHOULD BE LEFT AS IS. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defparameter *nesl-version* nil)

(defparameter *nesl-date* nil)

(with-open-file (releasefile (concatenate 'string *NESL-PATH* "src/releasenum")
			     :direction :input)
  (setq *nesl-version* (read-line releasefile))
  (setq *nesl-date* (read-line releasefile)))

(format t "~%; Loading NESL version ~a, ~a~%~%"
	*nesl-version* *nesl-date*)

(defparameter *obj-tailer* 
  #+(or allegro excl) ".fasl"
  #+lucid ".sbin")

(defun load-bin-file (filename)
  (when (not (load (concatenate 'string "bin/" filename *obj-tailer*)
		   :if-does-not-exist nil))
    (format t "Sorry, there is no compiled version of this file.")))

(let ((*default-pathname-defaults* (pathname *nesl-path*)))
  (declare (special *default-pathname-defaults*))
  (load "make")
  (load-bin-file "packages")
  (load-bin-file "funspec")
  (load-bin-file "free")
  (load-bin-file "trans")
  (load-bin-file "ptrans")
  (load-bin-file "type")
  (load-bin-file "type-check")
  (load-bin-file "output")
  (load-bin-file "run-vcode")
  (load-bin-file "vcode-lisp")
  (load-bin-file "defop")
  (load-bin-file "read-eval-print")

  ;; CNESL SYNTAX STUFF
  (load-bin-file "cgtoke")
  (load-bin-file "cgol-cl")
  (load-bin-file "cnesl")
  (speaknesl)

  (load "src/config.lisp")
      
  (let ((*redefine-default* t))
    (declare (special *redefine-default*))
    (load-nesl "src/types.nesl" :print nil)
    (load-nesl "src/scalar-ops.nesl" :print nil)
    (load-nesl "src/vector-ops.nesl" :print nil)
    (load-nesl "src/nest-ops.nesl" :print nil)
    (load-nesl "src/other-ops.cnesl" :print nil)
    (load-nesl "src/io.nesl" :print nil)
    (load-nesl "src/ltoc.nesl" :print nil))

  (format t "~%")
  (init-machine-configuration)

  (format t "~%~%; -> You can switch to Lisp by typing lisp();~%~
                 ; -> and back to Nesl by typing (nesl).~%~
                 ; -> Use (nesl) when an error aborts you out of the ~
                 interpreter.~%~
                 ; -> Type help(); for a list of the top level commands.~%~%")
  )

(nesl)
