%{
/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

/* 
 * Lex source file for analyzing VCODE source.  yyin is redefined in 
 * main.c to point to the input VCODE file.
 */

#include "vcode.h"
#include "y.tab.h"
#include "parse.h"
#include "vcode_hash.h"

#ifndef _TOKENS
#define _TOKENS 1
#endif	_TOKENS

#define show_token() if (lex_trace) printf("%s\n", yytext)

VOPCODE lookup;

%}

digit		[0-9]
integer		[-+]?{digit}+
float		[-+]?{digit}+\.({digit}+)?([Ee][-+]?{digit}+)?
identifier	[-+*/%<>=!._A-Za-z0-9]+
comment		"{"[^}]*"}"
string		\"[^"]*\"
whitespace	[ \t\n]
begin_vector	"("
end_vector	")"

%%				/* rules section begins here */

{integer}	{
		 show_token(); 
		 sscanf(yytext, "%d", &yylval.ival);
		 return(INTEGER);
		}

{float}		{
		 show_token(); 
		 sscanf(yytext, "%f", &yylval.dval);
		 return(REAL);
		} 

{identifier}	{
		 show_token(); 
		 lookup = lookup_id(yytext);
		 if (lookup == IDENTIFIER) 
		    yylval.id = yytext;
		 else 
		    yylval.vop = lookup;
		 return (lookup);
		}

{string}	{
		 show_token();
		 yylval.cval = yytext;
		 return(STRING);
		}

{begin_vector}  {
		 show_token();
		 return(BEGIN_VECTOR);
		}
{end_vector}	{
		 show_token();
		 return(END_VECTOR);
		}
{comment}	{show_token();}

{whitespace}	; 
.		{
    		    fprintf(stderr, "vinterp: lexer: Unexpected character in input at ");
		    fprintf(stderr, "line %d\n", yylineno);
		}
%%
