(in-package 'nesl-lisp)

(defun execute-shell-line (command-string)
  #+lucid
  (lcl::shell command-string)
  #+(or allegro excl)
  (system::run-shell-command command-string)
  #-(or lucid allegro excl)
  (error "The NESL/VCODE interface has not been implemented ~
          for the Lisp you are using."))

(let* ((src-dir (concatenate 'string *NESL-PATH* "src/"))
       (obj-dir (concatenate 'string *NESL-PATH* "bin/")))
  (flet ((comp-file (name &key needs)
	   (let ((src-file (concatenate 'string src-dir name ".lisp"))
		 (obj-file (concatenate 'string obj-dir name *obj-tailer*)))
	     (when (not (probe-file src-file))
		   (error "No source file ~a." src-file))
	     (when (or (not (probe-file obj-file))
		       (< (file-write-date obj-file)
			  (file-write-date src-file)))
	       (when needs (load needs))
	       (compile-file src-file :output-file obj-file)))))
    (comp-file "packages")
    (load (concatenate 'string src-dir "packages.lisp"))
    (comp-file "funspec")
    (load (concatenate 'string src-dir "funspec.lisp"))
    (comp-file "free")
    (comp-file "type")
    (comp-file "type-check")
    (comp-file "trans")
    (comp-file "ptrans")
    (comp-file "output")
    (comp-file "run-vcode")
    (comp-file "vcode-lisp")
    (comp-file "defop")
    (comp-file "read-eval-print")

    (when (probe-file "vcode/Makefile")
       (format t "~%; Compiling CVL and VCODE~%~%")
       (execute-shell-line "cd vcode; make"))))
