/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

#ifndef VSTACK_H
#define VSTACK_H

#include <cvl.h>
#include "vcode.h"

typedef struct vblock_t {
   vec_p vector;                        /* pointer into vector memory */
   int count;                           /* reference count of block */
   TYPE type;                           /* type of the vector */
   int len;                             /* length of vector */
   int seg_len;                         /* if segd, length of vector */
   int size;                            /* size, in vector memory units */
   int active;                          /* is memory active or free */
   struct vblock_t *bnext, *bprev;      /* doubly linked block list */
   struct vblock_t *fnext, *fprev;      /* doubly linked free list */
} vb_t;

extern void vstack_init();
extern vb_t *new_vector();
extern void vstack_copy();
extern void assert_mem_size();
extern void vb_print();

extern vb_t *scratch_block;
#define SCRATCH 	(scratch_block->vector)

/* speed hack to optimize common case of reusing vectors */
#ifdef SPEEDHACKS
#define vstack_pop(_vb)					\
	do {if (--_vb->count == 0) vstack_pop_real(_vb);} while (0)
#else
#define vstack_pop(_vb) vstack_pop_real(_vb)
#endif
extern void vstack_pop_real();

/* another speed hack to optimize case of enough scratch space */
#ifdef SPEEDHACKS
#define assert_mem_size(_size)				\
    do {						\
	int _foo = (_size);				\
	if (_foo > scratch_block->size) assert_mem_size_real(_foo); \
    } while (0)
#else
#define assert_mem_size(_size) assert_mem_size_real(_size)
#endif
extern void assert_mem_size_real();

#ifdef SPEEDHACKS
#define vstack_copy(_vb) ((_vb)->count++)
#endif

#endif
