/* starting time is 14:34:17 */
/* C code produced by gperf version 2.5 (GNU C++ version) */
/* Command-line: gperf -ptTD -K funct_string -k 1,2,6,7 -N vcode_lookup  */
/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

/* This file contains a list of all the VCODE tokens.  The lexer uses the
 * hash function whenever it encouters an identifer and returns the token
 * of the identifier found.
 */

#include <stdio.h>
#include "vcode.h"
#include "y.tab.h"
#include "parse.h"
#include "vcode_hash.h"

#define TOTAL_KEYWORDS 86
#define MIN_WORD_LENGTH 1
#define MAX_WORD_LENGTH 11
#define MIN_HASH_VALUE 1
#define MAX_HASH_VALUE 243
/* maximum key range = 243, duplicates = 5 */

static unsigned int
hash (str, len)
     register char *str;
     register int unsigned len;
{
  static unsigned char asso_values[] =
    {
     244, 244, 244, 244, 244, 244, 244, 244, 244, 244,
     244, 244, 244, 244, 244, 244, 244, 244, 244, 244,
     244, 244, 244, 244, 244, 244, 244, 244, 244, 244,
     244, 244, 244,   0, 244, 244, 244,  20, 244, 244,
     244, 244,  10,  47, 244,  40, 244,  15, 244, 244,
     244, 244, 244, 244, 244, 244, 244, 244, 244, 244,
      25,   5,  45, 244, 244,  20,  45,  25,  30,   0,
      90, 244,  15,  30, 244, 244,  55,  15,  20,   5,
      95,  25, 110,  50,   0,  50, 244,  20,  10, 244,
     244, 244, 244, 244, 244,   0, 244, 244, 244, 244,
     244, 244, 244, 244, 244, 244, 244, 244, 244, 244,
     244, 244, 244, 244, 244, 244, 244, 244, 244, 244,
     244, 244, 244, 244, 244, 244, 244, 244,
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 7:
        hval += asso_values[str[6]];
      case 6:
        hval += asso_values[str[5]];
      case 5:
      case 4:
      case 3:
      case 2:
        hval += asso_values[str[1]];
      case 1:
        hval += asso_values[str[0]];
    }
  return hval;
}

vcode_com_t *
vcode_lookup (str, len)
     register char *str;
     register unsigned int len;
{
  static vcode_com_t wordlist[] =
    {
      {"",}, 
      {"T",  V_TRUE},
      {"=",  EQ},
      {"!=",  NEQ},
      {"*",  TIMES},
      {"EXP",  EXP},
      {"/",  DIV},
      {"XOR",  XOR},
      {"%",  MOD},
      {"TAN",  TAN},
      {"ATAN",  ATAN},
      {"TANH",  TANH},
      {"ENDIF",  ENDIF},
      {"<",  LT},
      {"NOT",  NOT},
      {"CEIL",  CEIL},
      {"<=",  LEQ},
      {"COS",  COS},
      {"COSH",  COSH},
      {"COPY",  COPY},
      {"CONST",  CONST},
      {"MAIN",  MAIN},
      {"-",  MINUS},
      {"EXTRACT",  EXTRACT},
      {"AND",  AND},
      {"CHAR",  CHAR},
      {">",  GT},
      {"+",  PLUS},
      {"ACOS",  ACOS},
      {"CALL",  CALL},
      {">=",  GEQ},
      {"INT",  INT},
      {"BOOL",  BOOL},
      {"SELECT",  SELECT},
      {"ELSE",  ELSE},
      {"START_TIMER",  START_TIMER},
      {"LOG",  LOG},
      {"DIST",  DIST},
      {"+_SCAN",  PLUS_SCAN},
      {"ASIN",  ASIN},
      {"MAX_REDUCE",  MAX_REDUCE},
      {"LENGTH",  LENGTH},
      {"SQRT",  SQRT},
      {"AND_REDUCE",  AND_REDUCE},
      {"I_TO_B",  I_TO_B},
      {"B_TO_I",  B_TO_I},
      {"SIN",  SIN},
      {"SINH",  SINH},
      {"MIN_REDUCE",  MIN_REDUCE},
      {"MAX_SCAN",  MAX_SCAN},
      {"STOP_TIMER",  STOP_TIMER},
      {"F",  V_FALSE},
      {"AND_SCAN",  AND_SCAN},
      {"MAKE_SEGDES",  MAKE_SEGDES},
      {"MIN_SCAN",  MIN_SCAN},
      {"FOPEN",  FOPEN},
      {"PERMUTE",  PERMUTE},
      {"POP",  POP},
      {"SEGDES",  SEGDES},
      {"LSHIFT",  LSHIFT},
      {"RET",  RET},
      {"READ",  READ},
      {"TRUNC",  TRUNC},
      {"FWRITE",  FWRITE},
      {"OR",  OR},
      {"PACK",  PACK},
      {"ROUND",  ROUND},
      {"FCLOSE",  FCLOSE},
      {"IF",  IF},
      {"I_TO_F",  I_TO_F},
      {"LENGTHS",  LENGTHS},
      {"+_REDUCE",  PLUS_REDUCE},
      {"RAND",  RAND},
      {"WRITE",  WRITE},
      {"REPLACE",  REPLACE},
      {"FUNC",  FUNC},
      {"FLOOR",  FLOOR},
      {"FLOAT",  FLOAT},
      {"OR_SCAN",  OR_SCAN},
      {"RSHIFT",  RSHIFT},
      {"DPERMUTE",  DPERMUTE},
      {"DFPERMUTE",  DFPERMUTE},
      {"BPERMUTE",  BPERMUTE},
      {"OR_REDUCE",  OR_REDUCE},
      {"FREAD",  FREAD},
      {"BFPERMUTE",  BFPERMUTE},
      {"FPERMUTE",  FPERMUTE},
    };

  static short lookup[] =
    {
        -1,   1,  -1,  -1,  -1,  -1,   2,   3,  -1,  -1,  -1,   4,  -1,   5,
        -1,  -1,   6,  -1,   7,  -1,  -1,   8,  -1,   9, 249,  12,  13,  -1,
        14,  15, -10,  -2,  16,  17, 245,  20, -18,  -2,  -1,  21,  -1,  22,
        23,  24,  25,  -1,  26,  -1,  27, 244, -28,  -2,  30,  31,  32,  -1,
        33,  -1,  -1,  34,  -1,  35,  -1,  36,  37,  -1,  -1,  -1,  -1,  -1,
        -1,  -1,  -1,  38,  39,  40,  41,  -1,  -1,  42,  43, 248,  -1,  46,
        47,  48, -44,  -2,  49,  -1,  50,  51,  -1,  52,  -1,  -1,  53,  -1,
        54,  -1,  55,  -1,  56,  57,  -1,  -1,  58,  -1,  -1,  -1,  -1,  59,
        -1,  60,  61,  62,  63,  64,  -1,  65,  66,  67,  68,  -1,  -1,  -1,
        69,  70,  -1,  -1,  71,  -1,  -1,  -1,  72,  73,  -1,  -1,  -1,  -1,
        -1,  -1,  74,  -1,  75,  -1,  -1,  -1,  -1,  -1, 244, -76,  -2,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  78,  -1,  -1,  -1,  79,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
        -1,  80,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  81,  -1,
        -1,  -1,  82,  -1,  -1,  -1,  -1,  -1,  83,  84,  -1,  -1,  -1,  85,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
        -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
        -1,  -1,  -1,  -1,  -1,  86,
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register int index = lookup[key];

          if (index >= 0 && index < MAX_HASH_VALUE)
            {
              register char *s = wordlist[index].funct_string;

              if (*s == *str && !strcmp (str + 1, s + 1))
                return &wordlist[index];
            }
          else if (index < 0 && index >= -MAX_HASH_VALUE)
            return 0;
          else
            {
              register int offset = key + index + (index > 0 ? -MAX_HASH_VALUE : MAX_HASH_VALUE);
              register vcode_com_t *base = &wordlist[-lookup[offset]];
              register vcode_com_t *ptr = base + -lookup[offset + 1];

              while (--ptr >= base)
                if (*str == *ptr->funct_string && !strcmp (str + 1, ptr->funct_string + 1))
                  return ptr;
            }
        }
    }
  return 0;
}

VOPCODE lookup_id(id)
char *id;
{
    vcode_com_t *result;

    result = vcode_lookup(id , strlen(id));
    if (result == NULL)
	return IDENTIFIER;
    else return result->vop;
}
/* ending time is 14:34:18 */
