/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

/* Module for dealing with runtime stack */

/* The runtime stack is an array of integers representing 
 * the call stack of the pc as the interpreter executes the program.
 */
#include <stdio.h>

#include "vcode.h"
#include "rtstack.h"

static rt_stack_max = 10;
static rt_stack_count = 0;	/* points to place for new item */

int *rt_stack;

void rtstack_init()
{
    if ((rt_stack = (int *) malloc(rt_stack_max * sizeof(int))) == NULL) {
	fprintf(stderr, "vinterp: Couldn't allocate rt_stack.\n");
	vinterp_exit (1);
    }
    return;
}
    
/* push a new value onto the stack, increasing size of array, if necessary. */
void rtstack_push(val)
int val;
{
    /* double size of stack if run out of room */
    if (rt_stack_count == rt_stack_max) {
	rt_stack_max *= 2;
	rt_stack = (int *) realloc(rt_stack, rt_stack_max * sizeof(int));
	if (rt_stack == NULL) {
	    fprintf(stderr, "vinterp: Couldn't reallocate rt_stack to %d\n", rt_stack_max);
	    vinterp_exit (1);
        }
    }

    if (runtime_trace)
        fprintf(stderr, "push: \t stack_count = %d, saved_pc = %d\n", rt_stack_count, val);

    rt_stack[rt_stack_count++] = val;
    return;
}

/* pop the PC */
int rtstack_pop()
{
    if (runtime_trace)
        fprintf(stderr, "pop: \t stack_count = %d, new_pc = %d\n", rt_stack_count - 1, rt_stack[rt_stack_count - 1]);

    return rt_stack[--rt_stack_count];
}
