/*
* Copyright (c) 1992 Carnegie Mellon University 
*                    SCAL project: Guy Blelloch, Siddhartha Chatterjee,
*                                  Jonathan Hardwick, Jay Sipelstein,
*                                  Marco Zagha
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
* CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
* ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The SCAL project requests users of this software to return to 
*
*  Guy Blelloch				guy.blelloch@cs.cmu.edu
*  School of Computer Science
*  Carnegie Mellon University
*  5000 Forbes Ave.
*  Pittsburgh PA 15213-3890
*
* any improvements or extensions that they make and grant Carnegie Mellon
* the rights to redistribute these changes.
*/

#include "vcode.h"

extern void show_program();
extern void show_prog_entry();
extern char *type_string();

/* data structures for representation of vcode program */
typedef struct prog_entry {
    VOPCODE	vop;		/* opcode of command */
    vopdes_t	*vopdes;	/* descriptor for command (vcode_table.c) */
    int 	lineno;		/* line number in text */
    TYPE	type;		/* type of vop argument */
    int	is_in_const_pool;       /* is the value in the pool */
    union {			/* misc stuff */
	int 	branch;		/* prog_entry number to branch to */
	int	int_const;	/* value of constants */
	float	float_const;
	int	bool_const;	
	int	const_pool_index; /* location of vector constant in pool */
	struct {		/* args to copy and pop */
	    int arg1, arg2;    
	} stack_args;		
    } misc;
} prog_entry_t;

#define PROG_SIZE_MAX 10000
extern prog_entry_t  program[];	/* the VCODE program */
extern int next_prog_num;	/* place for next prog_entry */

#define UNKNOWN_BRANCH -1	/* place holder before linking */
